<?php

use App\Http\Controllers\Web\CroneJobC;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Web\DataCollectionC;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Web\BinaryDataController;
use App\Http\Controllers\Web\ReadingController;
use App\Http\Controllers\ExportController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them willc
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/export/{table}', [ExportController::class, 'export']);
Route::get('/setPowerFactor/{type?}/{table?}', [ExportController::class, 'setPowerFactor']);
Route::get('/calculateNCL/{id?}', [ExportController::class, 'calculateNC']);
Route::get('/device-list-export', [ExportController::class, 'exportDeviceList'])->name('deviceListExport');
Route::get('/device-distance-export', [ExportController::class, 'deviceDistanceExport'])->name('deviceDistanceExport');

// socket url ---------------------------------------------------------------------

Route::get('/simulator', function () {
    return view('simulator');
});

Route::get('/reading', [ReadingController::class, 'load_form']);
Route::post('/reading', [ReadingController::class, 'store']);

Route::get('/kwh-reading', [ReadingController::class, 'load_kwh_form']);
Route::post('/kwh-reading', [ReadingController::class, 'kwh_store']);


Route::get('/reading-list', [ReadingController::class, 'index'])->name('reading-list');
Route::get('/kwh-reading-list', [ReadingController::class, 'kwh_index'])->name('kwh-reading-list');



Route::get('/send-message', function () {
    return view('send_message');
});



// ----------------------------------------------------------------------------------
Route::redirect('/','/login' );

Auth::routes();

Route::get('/template', function () {
    return view('emails.thanks');
});

Route::get('/clear-cache', function () {
    $exitCode = Artisan::call('cache:clear');
    return 'Cache cleared successfully!';
});

Auth::routes();


// Route::get('/datacollection',[DataCollectionC::class,'dataCollection']);

//item-real-time-dataRoute::get('/cronejobrun',[CroneJobC::class,'index']); //put data in  TrCurrentLog ,TrKwhLog ,BillingData
Route::get('/monthly_billing_data_cronejob',[CroneJobC::class,'monthly_billing_data']);// monthly billing data cronjob

Route::get('/load_profile',[CroneJobC::class,'load_profile']);// every 30 minuts updat the load profile table . so we cant change it to socket




Route::get('/send-binary-chunk', [BinaryDataController::class, 'sendBinaryChunk']);


//Route::group(['middleware' => 'auth'], function () {
    Route::get('/user-list', [UserController::class, 'userList'])->name('user-list');

    Route::get('/add-user-form', [UserController::class, 'addUserForm'])->name('add-user-form');
    Route::post('/add-user', [UserController::class, 'addUserNew'])->name('add-user');


    Route::get('/editUserForm/{id}', [UserController::class, 'editUserForm'])->name('edit-user-Form');
    Route::post('/editUser/{id}', [UserController::class, 'editUser'])->name('edit-user');

//});


Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/data-list', [HomeController::class, 'dataList'])->name('data-list');

Route::get('/get-cofiguration/{id}', [HomeController::class, 'getCofiguration'])->name('get-cofiguration');



Route::get('/data-list-tabular', [HomeController::class, 'dataListTabular'])->name('data-list-tabular');
Route::get('/data-list-map', [HomeController::class, 'dataListMap'])->name('data-list-map');
Route::get('/data-list-connection', [HomeController::class, 'dataListConnection'])->name('data-list-connection');


Route::get('/item-switch/{id}', [HomeController::class, 'itemSwitch'])->name('item-switch');
Route::get('/single-item-data/{id}', [HomeController::class, 'dataItem'])->name('item-data');
Route::get('/single-item-data-delete/{id}', [HomeController::class, 'dataItemDelete'])->name('item-data-delete');
Route::get('/item-graph-data/{id}/{time?}', [HomeController::class, 'itemGraphDataAjax'])->name('item-graph-data');

Route::get('/item-real-time-data/{id}', [HomeController::class, 'ItemRealTimeData'])->name('item-real-time-data');

Route::get('/deviceData/{id}', [HomeController::class, 'deviceData'])->name('device-data');

// Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/currentLog', [HomeController::class, 'currentLog'])->name('currentLog');
Route::get('/kwhLog', [HomeController::class, 'kwhLog'])->name('kwhLog');
Route::get('/kvaLog', [HomeController::class, 'kvaLog'])->name('kvaLog');
Route::get('/mdiLog', [HomeController::class, 'mdiLog'])->name('mdiLog');
Route::get('/thdlog', [HomeController::class, 'thdlog'])->name('thdlog');
Route::get('/extraLog', [HomeController::class, 'extraLog'])->name('extraLog');

Route::get('/rawpanel', [HomeController::class, 'rawpanel'])->name('rawpanel');

Route::get('/alert', [HomeController::class, 'alert'])->name('alert');

Route::get('/get-recent-log/{id?}/{id2?}', [HomeController::class, 'getRecentLog'])->name('get-recent-log');


Route::get('/transformerSwitching', [HomeController::class, 'transformerSwitching'])->name('transformerSwitching');
Route::post('/transformerSwitchingSave', [HomeController::class, 'transformerSwitchingSave'])->name('transformerSwitchingSave');
Route::get('/deleteSwitchRecord/{id}', [HomeController::class, 'deleteSwitchRecord'])->name('deleteSwitchRecord');
Route::get('/addTransformerForm', [HomeController::class, 'addTransformerForm'])->name('addTransformerForm');
Route::post('/addTransformer', [HomeController::class, 'addTransformer'])->name('addTransformer');

Route::get('/addTransformerThresholdForm', [HomeController::class, 'addTransformerThresholdForm'])->name('addTransformerThresholdForm');
Route::post('/addTransformerTreshold', [HomeController::class, 'addTransformerTreshold'])->name('addTransformerTreshold');

Route::get('/editTransformerForm/{id}', [HomeController::class, 'editTransformerForm'])->name('editTransformerForm');
Route::post('/editTransformer/{id}', [HomeController::class, 'editTransformer'])->name('editTransformer');

Route::get('/report/technicalReportForm', [ReportController::class, 'technicalReportForm'])->name('technicalReportForm');
Route::get('/report/commercialReportForm', [ReportController::class, 'commercialReportForm'])->name('commercialReportForm');

Route::get('/report/deviceGraphs', [ReportController::class, 'deviceGraphs'])->name('deviceGraphs');

Route::get('/report/timeDomainGraph', [ReportController::class, 'timeDomainGraph'])->name('timeDomainGraph');

Route::get('/report/deviceTree', [ReportController::class, 'deviceTree'])->name('deviceTree');
Route::get('/report/mannualReading', [ReportController::class, 'mannualReading'])->name('mannualReading');


Route::get('/errorLog', [HomeController::class, 'errorLog'])->name('errorLog');

Route::get('/report/deviceListReport', [ReportController::class, 'deviceList'])->name('deviceListReport');
Route::get('/report/deviceDistanceReport', [ReportController::class, 'deviceDistance'])->name('deviceDistanceReport');
Route::get('/report/unresponsiveDevices', [ReportController::class, 'unresponsiveDevices'])->name('unresponsiveDevices');
Route::get('/report/neutralLosses', [ReportController::class, 'neutralLosses'])->name('neutralLosses');
Route::get('/report/neutralCurrentLossGraph', [ReportController::class, 'neutralCurrentLossGraph'])->name('neutralCurrentLossGraph');

Route::get('/apmsrawpanel', [HomeController::class, 'apmsrawpanel'])->name('apmsrawpanel');

