@extends('layouts.app')

@section('center')
<link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.css" />
<link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.date.css" />
<link rel="stylesheet" href="{{asset('assets')}}/vendor/bs-select/bs-select.css" />

<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <form action="{{route('technicalReportForm')}}">
            <div class="row gutters">
			<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2">
			<!-- <label class="label">Total Technical Loss </label> -->
			</div>
				{{--  
                <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2">
                    <div class="form-group">
                        <label class="label">Device ID</label>
                        <select class="form-control selectpicker" data-live-search="true" name="DeviceId">
                            <option value=''>Select Device ID</option>
                            @foreach($tr_data as $k => $row)
                                <option value="{{$row->global_device_id}}" 
                                    @isset($_GET["DeviceId"])
                                        @if($_GET["DeviceId"]==$row->global_device_id) selected @endif
                                    @endisset>
                                    {{$row->global_device_id}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
				

                <div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12">
                    <div class="form-group">
                        <label class="label">&nbsp;</label>
                        <button type="submit" class="form-control btn btn-primary generate">Generate</button>
                    </div>
                </div>
				--}}
            </div>
        </form>
    </div>
                   
	
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-2 col-12">
        @if(!empty($graph_data2) && count($graph_data2) > 0)
        <div style="width: 100%; overflow-x: auto;height:400px;">
        <canvas id="childVoltageChart" height="120"></canvas>
        </div>
        @endif
    </div>
</div>

@push('scripts')
<script src="{{asset('assets')}}/vendor/datepicker/js/picker.js"></script>
<script src="{{asset('assets')}}/vendor/datepicker/js/picker.date.js"></script>
<script src="{{asset('assets')}}/vendor/datepicker/js/custom-picker.js"></script>
<script src="{{asset('assets')}}/vendor/bs-select/bs-select.min.js"></script>
<script src="{{asset('assets')}}/js/main.js"></script>



@if(!empty($graph_data2) && count($graph_data2) > 0)
<!-- Load Luxon and Chart.js Adapter First -->
<!-- Chart.js v4 -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.2/dist/chart.umd.min.js"></script>

<!-- Luxon v3 -->
<script src="https://cdn.jsdelivr.net/npm/luxon@3.4.4/build/global/luxon.min.js"></script>

<!-- Chart.js Luxon Adapter v1.3.1 (works with Chart.js v4) -->
<script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-luxon@1.3.1/dist/chartjs-adapter-luxon.umd.min.js"></script>

<script>
        const labels = {!! json_encode(array_keys($graph_data2)) !!};

        const v1Data = {!! json_encode(array_column($graph_data2, 'v1_loss')) !!};
        const v2Data = {!! json_encode(array_column($graph_data2, 'v2_loss')) !!};
        const v3Data = {!! json_encode(array_column($graph_data2, 'v3_loss')) !!};

        const ctx = document.getElementById('childVoltageChart').getContext('2d');

        const voltageChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'V1',
                        data: v1Data,
                        backgroundColor: 'rgba(255, 99, 132, 0.7)'
                    },
                    {
                        label: 'V2',
                        data: v2Data,
                        backgroundColor: 'rgba(54, 162, 235, 0.7)'
                    },
                    {
                        label: 'V3',
                        data: v3Data,
                        backgroundColor: 'rgba(75, 192, 192, 0.7)'
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    title: {
                        display: true,
                        text: 'Technical Loss'
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Voltage (V)'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Device ID'
                        }
                    }
                }
            }
        });
    </script>

@endif
@endpush

@endsection
