@extends('layouts.app')

@section('center')
<link rel="stylesheet" href="{{asset('assets')}}/vendor/morris/morris.css" />
<style>
.morris-hover {
    background-color: #ffffff !important; /* White background */
    border: 1px solid #ddd; /* Optional: Add border to make it visible */
	color: #000000 !important;
}

.morris-hover .morris-hover-point {
    color: #000000 !important; /* Optional: Change the text color */
}

</style>
<div class="row gutters">
<div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
	<!-- <p>Default select box</p> -->
	<select class="form-control selectpicker filterTime">
		<option value="lh" selected>Last Hour</option>
		<option value="l24h">Last 24Hr</option>
		<option value="lw" >Last Week</option>
		<option value="lm">Last Month</option>
		<!-- <option value="c">Custom</option> -->

	</select>
	<br/>
</div>

<!-- <div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
	<select class="form-control selectpicker">
		<option>Last Hour</option>


	</select>
	<br/>
</div>


<div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
	<select class="form-control selectpicker">
		<option>Last Hour</option>


	</select>
	<br/>
</div> -->

<div class="col-xl-3 col-lg col-md-3 col-sm-3 col-12 ">
	<!-- <p>Default select box</p> -->
	<button type="button" class="btn btn-primary generate">Generate</button>
	<br/>
</div>
</div>
<div class="row gutters">

						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">Current</div>
								</div>
								<div class="card-body">
									<div id="dayData" class="chart-height"></div>
								</div>
							</div>
						</div>

						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">Voltage</div>
								</div>
								<div class="card-body">
									<div id="dayData2" class="chart-height"></div>
								</div>
							</div>
						</div>
						<!-- <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">Active Energy</div>
								</div>
								<div class="card-body">
									<div id="morrisBarChart1" class="chart-height"></div>
								</div>
							</div>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">MDI</div>
								</div>
								<div class="card-body">
									<div id="morrisBarChart2" class="chart-height"></div>
								</div>
							</div>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
							<div class="card">
								<div class="card-header">
									<div class="card-title">Reactive Energy</div>
								</div>
								<div class="card-body">
									<div id="morrisBarChart3" class="chart-height"></div>
								</div>
							</div>
						</div> -->
					</div>
				@push('scripts')

				<script src="{{asset('assets')}}/vendor/morris/raphael-min.js"></script>
				<script src="{{asset('assets')}}/vendor/morris/morris.min.js"></script>
				<!-- <script src="asset('assets')/vendor/morris/custom/areaChart.js"></script> -->
				<!-- <script src="asset('assets')/vendor/morris/custom/xLabelsDiagonally.js"></script> -->
				<!-- <script src="asset('assets')/vendor/morris/custom/barColors.js"></script> -->
				<!-- <script src="asset('assets')/vendor/morris/custom/barNoAxis.js"></script> -->
				<!-- <script src="asset('assets')/vendor/morris/custom/dayData.js"></script> -->
				{{--<script src="asset('assets')/vendor/morris/custom/donutColors.js"></script>--}}
				{{--<script src="asset('assets')/vendor/morris/custom/donutFormatter.js"></script>--}}
				<!-- <script src="asset('assets')/vendor/morris/custom/morrisBarChart.js"></script> -->
				<!-- <script src="{{asset('assets')}}/vendor/morris/custom/negativeValues.js"></script> -->
				<!-- <script src="{{asset('assets')}}/vendor/morris/custom/stackedBarChart.js"></script> -->

				<script>
					$(document).ready(function() {

						main_function_of_graph();


						function main_function_of_graph()
							{
								var ft=$('.filterTime').val();
								$.ajax({
									url: '{{ url("item-graph-data") }}/{{$data->global_device_id}}/'+''+ft,
									method: 'GET', // HTTP method
									dataType: 'json', // Expected data type
									async: false, // This makes the call synchronous
									success: function(response) {
										generate_line_graph(response);
										generate_line_graph2(response);
										// generate_bar_graph1(response);
										// generate_bar_graph2(response);
										// generate_bar_graph3(response);
										// Handle the response data
										// $('#result').html('<p>' + response.message + '</p>');
									},
									error: function(xhr) {
										// Handle errors
										$('#result').html('<p>Error occurred: ' + xhr.statusText + '</p>');
								}
							});

							}

							function generate_line_graph(result)
							{
								//
								$('#dayData').empty();
								var day_data=[];
								result.data.forEach(element => {
								day_data.push({"period": element.server_date_time, "phase_a": parseFloat(element.ca), "phase_b" : parseFloat(element.cb),'phase_c':parseFloat(element.cc) });
								});
								console.log(day_data);

											Morris.Line({
												element: 'dayData',
												data: day_data,
												xkey: 'period',
												ykeys: ['phase_a', 'phase_b','phase_c'], // Updated to match the data fields
        										labels: ['Phase A', 'Phase B','Phase C'],
												resize: true,
												hideHover: "auto",
												gridLineColor: "#f5f1f100",
												pointFillColors:['#ffffff'],
												pointStrokeColors: ['#ff5661'],
												lineColors:['#0066ff', '#e83e8c', '#2b2f82'],
											});
							}

							function generate_line_graph2(result)
							{
								$('#dayData2').empty();
								//
								var day_data=[];
								result.data.forEach(element => {
								day_data.push({"period": element.server_date_time, "voltage_phase_a": element.va, "voltage_phase_b" : element.vb,'voltage_phase_c':element.vc });
								});
								console.log(day_data);

											Morris.Line({
												element: 'dayData2',
												data: day_data,
												xkey: 'period',
												ykeys: ['voltage_phase_a', 'voltage_phase_b','voltage_phase_c'], // Updated to match the data fields
        										labels: ['Voltage A', 'Voltage B','Voltage C'],
												resize: true,
												hideHover: "auto",
												gridLineColor: "#f5f1f100",
												pointFillColors:['#ffffff'],
												pointStrokeColors: ['#ff5661'],
												lineColors:['#0066ff', '#e83e8c', '#2b2f82'],
											});
							}


							function generate_bar_graph1(result)
							{
								$('#morrisBarChart1').empty();
								var day_data=[];
								result.data.forEach(element => {
								day_data.push({"x": element.server_date_time, "active_energy_pos_t1": element.active_energy_pos_t1, "active_energy_pos_t2" : element.active_energy_pos_t2,'active_energy_pos_t3':element.active_energy_pos_t3 });
								});

								Morris.Bar({
												element: 'morrisBarChart1',
												data:day_data,
												xkey: 'x',
												ykeys: ['active_energy_pos_t1', 'active_energy_pos_t2', 'active_energy_pos_t3'],
												labels: ['T1', 'T2', 'T3'],
												resize: true,
												hideHover: "auto",
												gridLineColor: "#e4e6f2",
												barColors:['#0066ff', '#e83e8c', '#2b2f82', '#ffc107'],
											});
							}



							function generate_bar_graph2(result)
							{
								$('#morrisBarChart2').empty();
								var day_data=[];
								result.data.forEach(element => {
								day_data.push({"x": element.server_date_time, "active_mdi_pos_t1": element.active_mdi_pos_t1, "active_mdi_pos_t2" : element.active_mdi_pos_t2,'active_mdi_pos_t3':element.active_mdi_pos_t3 });
								});

								Morris.Bar({
												element: 'morrisBarChart2',
												data:day_data,
												xkey: 'x',
												ykeys: ['active_mdi_pos_t1', 'active_mdi_pos_t2', 'active_mdi_pos_t3'],
												labels: ['T1', 'T2', 'T3'],
												resize: true,
												hideHover: "auto",
												gridLineColor: "#e4e6f2",
												barColors:['#0066ff', '#e83e8c', '#2b2f82', '#ffc107'],
											});
							}


							function generate_bar_graph3(result)
							{
								$('#morrisBarChart3').empty();
								var day_data=[];
								result.data.forEach(element => {
								day_data.push({"x": element.server_date_time, "reactive_energy_pos_t1": element.reactive_energy_pos_t1, "reactive_energy_pos_t2" : element.reactive_energy_pos_t2,'reactive_energy_pos_t3':element.reactive_energy_pos_t3 });
								});

								Morris.Bar({
												element: 'morrisBarChart3',
												data:day_data,
												xkey: 'x',
												ykeys: ['reactive_energy_pos_t1', 'reactive_energy_pos_t2', 'reactive_energy_pos_t3'],
												labels: ['T1', 'T2', 'T3'],
												resize: true,
												hideHover: "auto",
												gridLineColor: "#e4e6f2",
												barColors:['#0066ff', '#e83e8c', '#2b2f82', '#ffc107'],
											});
							}


						$('.generate').click(function() {


							main_function_of_graph();






						});
					});
				</script>
				@endpush



@endsection
