<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{env('APP_NAME')}} Device Simulator</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .device {
            margin: 20px 0;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }
        .status {
            display: inline-block;
            width: 60px;
            text-align: center;
            font-weight: bold;
        }
        .icon {
            width: 120px;
            height: 120px;
            margin-right: 10px;
            transition: opacity 0.3s ease;
        }
        .Metericon {
            width: 200px;
            height: 200px;
            margin-right: 10px;
            transition: opacity 0.3s ease;
        }
        #logs {
            margin-top: 20px;
        }
        #logs div {
            margin-bottom: 5px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        table td {
            border: 1px solid gray;
            padding: 10px;
            text-align: center;
        }
        .meter-status {
            font-size: 1.5rem;
            font-weight: bold;
        }
        .meter-on {
            color: white;
            background-color: green;
        }
        .meter-off {
            color: white;
            background-color: red;
        }
        .red {
            background-color:red;
            color:white;
        }
        .blue {
            background-color:blue;
            color:white;
        }
        .yellow {
            background-color:yellow;
            color:black;
        }
    </style>
</head>
<body>

<div class="container">
    <h1 class="text-center my-4">{{env('APP_NAME')}} Device Test</h1>

    <!-- Input for Global Device ID -->
    <div class="form-group">
        <label for="deviceID">Enter Device ID:</label>
        <input type="text" id="deviceID" class="form-control" placeholder="Enter global_device_id and press Enter">
    </div>

    <div class="device">
        <div class="row">
            <div class="col-md-4">
                <img id="meterIcon" class="Metericon" src="{{asset('assets')}}/img/meter_off.png" alt="Meter">
                <h2 class="meter-status" id="meterStatus" style="margin-top: 10px;">Status: <span class="meter-off">OFF</span></h2>
            </div>
            <div class="col-md-8">
                <table>
                    <tr>
                        <td></td>
                        <td class="red"><strong>Red</strong></td>
                        <td class="blue"> <strong>Blue</strong></td>
                        <td class="yellow"><strong>Yellow</strong></td>
                    </tr>
                    <tr>
                        <td><strong>Voltage</strong></td>
                        <td class="red"><span id="currentC1">0</span></td>
                        <td class="blue"><span id="currentC2">0</span></td>
                        <td class="yellow"><span id="currentC3">0</span></td>
                    </tr>
                    <tr>
                        <td><strong>Current</strong></td>
                        <td class="red"><span id="currenti1">0</span></td>
                        <td class="blue"><span id="currenti2">0</span></td>
                        <td class="yellow"><span id="currenti3">0</span></td>
                    </tr>
                    <tr>
                        <td><strong>Power Factor</strong></td>
                        <td class="red"><span id="currentpf1">0</span></td>
                        <td class="blue"><span id="currentpf2">0</span></td>
                        <td class="yellow"><span id="currentpf3">0</span></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <!-- Text Input for Command and Send Button -->
    <div class="form-group my-4">
        <label for="commandInput">Enter Command:</label>
        <input type="text" id="commandInput" class="form-control" placeholder="Enter command and press Enter">
        <button id="btnSendCommand" class="btn btn-primary mt-2">Send Command</button>
    </div>

    <div>
        <h2>Command Logs</h2>
        <pre style="border:1px solid blue; padding: 5px;font-size:10px;" id='logs'></pre>
    </div>
</div>

<script>
    var connection=0;    
    let socket;
    let gid = 'TR01'; // Default device ID
    let isMeterOn = false; // Flag to control current generation
    let commandLogs = []; // Array to hold last 10 commands

    // Event listener for Enter key to set the global_device_id and start WebSocket
    document.getElementById('deviceID').addEventListener('keydown', function(event) {
        if (event.key === 'Enter') {
            gid = this.value;
            startWebSocket(gid);
            //get_info();
        }
    });

    // Function to start WebSocket connection
    function startWebSocket(device_id) {
        const server = "{{env('WEBSOCKET_SERVER')}}";
        const port = "{{env('WEBSOCKET_PORT')}}";
        socket = new WebSocket(`${server}:${port}?gid=${device_id}`);

        socket.onopen = () => {
            if (socket.readyState === WebSocket.OPEN) {
                connection=1;
                console.log('Connected to WebSocket server');
            } else {
                connection=0;
                console.log('WebSocket not open');
            }
        };

        socket.onmessage = (event) => {
            const message = event.data.trim();
            console.log(message);
            updateCommandLogs(message, 'green');
            handleDeviceMessage(message);
        };

        socket.onerror = (error) => {
            console.error('WebSocket error:', error);
        };

        socket.onclose = (event) => {
            connection=0;
            console.log('WebSocket closed: ', event);
        };
    }

    function getCurrentDateTime() {
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0'); // Months are zero-based
    const day = String(now.getDate()).padStart(2, '0');
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');

    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
}

    // Function to handle device message
    function handleDeviceMessage(message) {
        const data = JSON.parse(message);
        changeMeterStatus(data);
    }

    // Function to generate and send dynamic currents
    function generateDynamicCurrents() {
        if (!isMeterOn) return;

        const v1 = parseFloat((Math.random() * 10).toFixed(2));
        const v2 = parseFloat((Math.random() * 10).toFixed(2));
        const v3 = parseFloat((Math.random() * 10).toFixed(2));

        const i1 = parseFloat((Math.random() * 10).toFixed(2));
        const i2 = parseFloat((Math.random() * 10).toFixed(2));
        const i3 = parseFloat((Math.random() * 10).toFixed(2));

        const pf1 = parseFloat((Math.random() ).toFixed(2));
        const pf2 = parseFloat((Math.random() ).toFixed(2));
        const pf3 = parseFloat((Math.random() ).toFixed(2));

        const kwhp1 = 0.8;
        const kwhp2 = 0.7;
        const kwhp3 = 0.5;

        const kwho1 = 0.5;
        const kwho2 = 0.6;
        const kwho3 = 0.7;


        const rkwhp1 = 0;
        const rkwhp2 = 0;
        const rkwhp3 = 0;

        const rkwho1 = 0;
        const rkwho2 = 0;
        const rkwho3 = 0;



        const kvh_red = (((v1*i1)/1000).toFixed(2));
        const kvh_blue = (((v2*i2)/1000).toFixed(2));
        const kvh_yellow = (((v3*i3)/1000).toFixed(2));
        let isRv=0;
        let isPk=0;

        let dtime = getCurrentDateTime();

        document.getElementById('currentC1').textContent = v1;
        document.getElementById('currentC2').textContent = v2;
        document.getElementById('currentC3').textContent = v3;

        document.getElementById('currenti1').textContent = i1;
        document.getElementById('currenti2').textContent = i2;
        document.getElementById('currenti3').textContent = i3;

        document.getElementById('currentpf1').textContent = pf1;
        document.getElementById('currentpf2').textContent = pf2;
        document.getElementById('currentpf3').textContent = pf3;
     
        const data = {
            gid: gid,
            a:'instantaneous',
            at: 'post_data',
            d: { v1, v2, v3, i1, i2, i3, pf1, pf2, pf3,dtime,

                kwhp1,
                kwhp2 ,
                kwhp3 ,
                kwho1 ,
                kwho2 ,
                kwho3 ,
                rkwhp1 ,
                rkwhp2 ,
                rkwhp3 ,
                rkwho1 ,
                rkwho2 ,
                rkwho3 ,
                isPk,
                isRv
            }
        };

        if (socket.readyState === WebSocket.OPEN) {
            updateCommandLogs(JSON.stringify(data));
            socket.send(JSON.stringify(data));
            console.log('Sent readings:', data);
        } else {
            console.log('WebSocket is not open. Cannot send data.');
        }
    }

    // Function to change meter status
    function changeMeterStatus(data) {
        const meterIcon = document.getElementById("meterIcon");
        const meterStatusText = document.getElementById('meterStatus');
        if (data.d.auxr_status === 1) {
            connection=1;
            meterIcon.src = "{{ asset('assets') }}/img/meter_on.gif";
            isMeterOn = true;
            meterStatusText.innerHTML = 'Status: <span class="meter-on">ON</span>';
        } else if (data.d.auxr_status === 0) {
            connection=0;
            meterIcon.src = "{{ asset('assets') }}/img/meter_off.png";
            isMeterOn = false;
            meterStatusText.innerHTML = 'Status: <span class="meter-off">OFF</span>';
        }
    }

    function updateCommandLogs(command, color='black') {
        const logsDiv = document.getElementById('logs');
        const logEntry = document.createElement('div');
        logEntry.innerHTML = `[${new Date().toLocaleTimeString()}]: ${command}`;
        logEntry.style.color = color;
        logsDiv.prepend(logEntry);
        while (logsDiv.children.length > 15) {
            logsDiv.removeChild(logsDiv.lastChild);
        }
    }

    // Periodically generate dynamic currents every second
    setInterval(generateDynamicCurrents, 10000);

    // Button event for sending custom command
    document.getElementById('btnSendCommand').addEventListener('click', function() {
        const commandInput = document.getElementById('commandInput').value;
        sendCommand(commandInput);
    });

    function sendCommand(command) {
        // console.log('Sending command:', command);
        // if (connection) {
            if (socket.readyState === WebSocket.OPEN) {
                console.log('Sent command:', command);
                updateCommandLogs(JSON.stringify(command));
                socket.send(JSON.stringify(JSON.parse(command)));
            // } else {
                // console.log('WebSocket is not open. Cannot send command.');
            // }
        }
    }

   

</script>

</body>
</html>
