@extends('layouts.app')

@section('center')
    <style>
        .success {
            border-top: 5px solid green !important;
        }
        .gray {
            border-top: 5px solid gray !important;
        }
        .warning {
            border-top: 5px solid yellow !important;
        }
        .info {
            border-top: 5px solid blue !important;
        }
    </style>
    <div class="row gutters mb-3 align-items-end">
        <div class="col-md-6">
            <h4 class="mb-2"> Unresponsive Devices Report</h4>
        </div>
        <div class="col-md-6 text-end">
            <form method="GET" action="{{ route('unresponsiveDevices') }}">
                <div class="input-group">
                    <input type="text" class="form-control" name="search" placeholder="Search by Global Device ID..." value="{{ Request::input('search') }}">
                    <span class="input-group-btn ms-1">
                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Search">
                        <i class="icon-search nav-icon" aria-hidden="true"></i>
                    </button>
                    <a href="{{ route('unresponsiveDevices') }}" class="btn btn-danger" data-toggle="tooltip" title="Clear Search">
                        <i class="icon-close nav-icon" aria-hidden="true"></i>
                    </a>
                </span>
                </div>
            </form>
        </div>
    </div>


    <div class="row gutters">
        <div class="col-12">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Global Device ID</th>
                    <th>Last Communication</th>
                    <th>Latitude</th>
                    <th>Longitude</th>
                    <th>Installed On</th>
                </tr>
                </thead>
                <tbody>
                @php
                    use Carbon\Carbon;
                @endphp

                @foreach($devices as $device)
                    @php
                        $rawTime = $device->server_time_update_our_value;
                    @endphp

                    @if(empty($rawTime) || Carbon::parse($rawTime)->lt(Carbon::now()->subDay()))
                        @php
                            $time = !empty($rawTime) ? Carbon::parse($rawTime) : null;
                            $daysAgo = $time ? $time->diffInDays(Carbon::now()) : null;
                        @endphp
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $device->global_device_id }}</td>
                            <td>
                                @if(empty($rawTime))
                                    <span class="text-danger">Not found communication time</span>
                                @else
                                    {{ $time->format('d-m-Y H:i:s') }}
                                    <small class="text-muted">({{ $daysAgo }} day{{ $daysAgo > 1 ? 's' : '' }} ago)</small>
                                @endif
                            </td>
                            <td>{{ $device->latitude }}</td>
                            <td>{{ $device->longitude }}</td>
                            <td>{{ $device->installed_on }}</td>
                        </tr>
                    @endif
                @endforeach

                @if($devices->isEmpty())
                    <tr>
                        <td colspan="6" class="text-center text-muted">No unresponsive devices found.</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection
