@extends('layouts.app')

@section('center')
    <style>

        .success{
            border-top: 5px solid green !important;
            /* color:white; */
        }

        .gray{
            border-top: 5px solid gray !important;
            /* color:white; */
        }
        .warning{
            border-top: 5px solid yellow !important;
            /* color:white; */
        }
        .info{
            border-top: 5px solid blue !important;
            /* color:white; */
        }

    </style>
    <div class="d-flex flex-wrap justify-content-between align-items-end mb-3">
        <div><h4 class="mb-2"> Devices Distance</h4></div>
        <div class="d-flex align-items-end gap-2">
            <form method="GET" action="{{ route('deviceDistanceReport') }}">
                <div class="input-group">
                    <input type="text" class="form-control w-90" name="search" placeholder="Search by Device ID..." value="{{ Request::input('search') }}">
                    <span class="input-group-btn ms-1">
                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Search">
                        <i class="icon-search nav-icon" aria-hidden="true"></i>
                    </button>
                    <a href="{{ route('deviceDistanceReport') }}" class="btn btn-danger" data-toggle="tooltip" title="Clear Search">
                        <i class="icon-close nav-icon" aria-hidden="true"></i>
                    </a>
                </span>
                </div>
            </form>
            <a id="exportBtn" href="#" class="btn btn-success ml-1">
                <i class="icon-arrow-down-circle"></i> Export to Excel  </a>
        </div>
    </div>
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            @php
                function haversineDistance($lat1, $lon1, $lat2, $lon2, $earthRadius = 6371) {
                    $latFrom = deg2rad($lat1);
                    $lonFrom = deg2rad($lon1);
                    $latTo = deg2rad($lat2);
                    $lonTo = deg2rad($lon2);

                    $latDelta = $latTo - $latFrom;
                    $lonDelta = $lonTo - $lonFrom;

                    $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                        cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
                    return $earthRadius * $angle;
                }

                $previousDevice = null;
                $totalDistance = 0;
                $firstpooldistance = null;
                $i = 1;
            @endphp

            <table class="table table-bordered" id="table">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Global Device ID</th>
                    <th>Type</th>
                    <th>Latitude</th>
                    <th>Longitude</th>
                    <th>Distance (km)</th>
                </tr>
                </thead>

                <tbody>

                {{--transformers--}}
                @foreach($devices as $device)
                    @php
                        $previousDevice = null;
                    @endphp

                    <tr class="device-row">
                        <td>{{ $i++ }}</td>
                        <td><b>{{ $device->global_device_id }}</b></td>
                        <td>{{ $device->installed_on }}</td>
                        <td>{{ $device->latitude }}</td>
                        <td>{{ $device->longitude }}</td>
                        <td>N/A</td>
                    </tr>
                    {{--Pools--}}
                    @foreach($device->children as $child)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>&nbsp;&nbsp;&nbsp;↳ {{ $child->global_device_id }}</td>
                            <td>{{ $child->installed_on }}</td>
                            <td>{{ $child->latitude }}</td>
                            <td>{{ $child->longitude }}</td>
                            <td>
                                @if($previousDevice)
                                    @php
                                        $distance = haversineDistance(
                                            $previousDevice->latitude,
                                            $previousDevice->longitude,
                                            $child->latitude,
                                            $child->longitude
                                        );
                                        $totalDistance += $distance;
                                    @endphp

                                    @if($distance < 1)
                                        {{ number_format($distance * 1000, 0) }} m
                                    @else
                                        {{ number_format($distance, 2) }} km
                                    @endif
                                @else
                                    @php
                                        $firstpooldistance = haversineDistance(
                                            $device->latitude,
                                            $device->longitude,
                                            $child->latitude,
                                            $child->longitude
                                        );

                        $totalDistance += $firstpooldistance;
                                    @endphp

                                    @if($firstpooldistance < 1)
                                        {{ number_format($firstpooldistance * 1000, 0) }} m
                                    @else
                                        {{ number_format($firstpooldistance, 2) }} km
                                    @endif
                                @endif
                            </td>
                        </tr>
                        @php $previousDevice = $child; @endphp
                    @endforeach

                    <tr style="background-color: #f0f0f0;">
                        <td colspan="5" class="text-right">
                            <strong>Total Distance ({{ $device->global_device_id }})</strong>
                        </td>
                        <td ><strong>{{ number_format($totalDistance, 2) }} km</strong></td>
                    </tr>
                @endforeach
                </tbody>

            </table>



        </div>
    </div>


    </div>
    @push('scripts')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
        <script>
                          //  export using jquery
                document.getElementById('exportBtn').addEventListener('click', function () {
                let table = document.querySelector('table'); // gets the first <table>
                let wb = XLSX.utils.table_to_book(table, { sheet: "Devices Distance" });
                XLSX.writeFile(wb, 'devices_distance_report.xlsx');
            });
        </script>

    @endpush
@endsection()
