<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{env('APP_NAME')}}</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  
  <style>
    body {
      background-color: #f0f4f8;
    }

    .logo-container {
      background: linear-gradient(to right,rgb(237, 240, 244), #1e3283);
      padding: 10px;
      padding-left: 40px;
    }

    .logo-container img {
      max-height: 60px;
    }

    .card {
      border: none;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .form-control {
      border-radius: 5px;
    }

    .btn-primary {
      background-color: #0d6efd;
      border: none;
      border-radius: 5px;
    }

    .btn-primary:hover {
      background-color: #0b5ed7;
    }

    .table thead {
      background-color: #0d6efd;
      color: white;
    }
    table td:nth-child(2) {
    border-left: 2px dashed gray !important;
    padding-left: 10px !important; /* Optional: Remove extra padding if needed */
    margin-left: 5px !important;
  }
  table td:nth-child(1) {
    padding-right: 5px !important; /* Optional: Remove extra padding if needed */
  }
    
  </style>
</head>
<body>
  <!-- Logo Header -->
  <div class="logo-container mb-1">
    <img src="https://apms.cisnr.com/assets/img/cisnr.png" alt="Company Logo" />
  </div>
  <div class=" mb-2 px-4">
    <a class="btn  @if(request()->is('reading'))  btn-primary  @else  btn-outline-primary @endif" aria-current="page" id="showVoltageForm" href="{{url('reading')}}">Voltages Reading</a>
    <a class="btn @if(request()->is('kwh-reading'))  btn-primary  @else  btn-outline-primary @endif" href="{{url('kwh-reading')}}" id="showKwhForm">kWh Reading</a>
  </div>

  <div class="container-fluid px-4">
    <div class="row g-4">
      <!-- Left Column: Input Form -->
      <div class="col-md-4">
       <!-- Form Card -->
<!-- Form Card -->
<!-- Form Card -->
<!-- Form Card -->
<div class="card p-4">
@if(session('success'))
    <div class="alert alert-success mb-4" role="alert">
        {{ session('success') }}
    </div>
@endif
  <!-- <h5 class="card-title mb-1 text-primary">Enter Readings</h5> -->
   
  <form id="dataForm" method="post" action="{{url('reading')}}">
	@csrf
    <div class="mb-3 d-flex align-items-center">
      <label for="v1" class="me-3 mb-0" style="width: 60px;">GID</label>
	  <select class="form-control selectpicker" data-live-search="true" class="form-control " name="DeviceId" id="GID">
						<option value=''>Select Device ID</option>
						@foreach($tr_data as $k => $row)
						<option value="{{$row->global_device_id}}" >{{$row->global_device_id}}</option>
						@endforeach

					</select>
    </div>

	<div class="mb-1 d-flex align-items-center">
      <label for="v1" class="me-3 mb-0" style="width: 60px;">Date</label>
      <input type="date"  class="form-control" id="readingDate" name="readingDate">
    </div>
    <hr/>
    <table>
      <tr>
        <td class="text-center">
            <b>PESCO </b>
        </td>
        <td  class="text-center">
            <b>CISNR</b> 
        </td>
      <tr>
        <td><div class="mb-1 d-flex align-items-center">
      <label for="v1" class="me-3 mb-0" style="width: 30px;">V1</label>
      <input type="number" step="any" class="form-control" id="v1" name="pv1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="v2" class="me-3 mb-0" style="width: 30px;">V2</label>
      <input type="number" step="any" class="form-control" id="v2" name="pv2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="v3" class="me-3 mb-0" style="width: 30px;">V3</label>
      <input type="number" step="any" class="form-control" id="v3" name="pv3">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i1" class="me-3 mb-0" style="width: 30px;">I1</label>
      <input type="number" step="any" class="form-control" id="i1" name="pi1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i2" class="me-3 mb-0" style="width: 30px;">I2</label>
      <input type="number" step="any" class="form-control" id="i2" name="pi2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i3" class="me-3 mb-0" style="width: 30px;">I3</label>
      <input type="number" step="any" class="form-control" id="i3" name="pi3">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf1" class="me-3 mb-0" style="width: 30px;">PF1</label>
      <input type="number" step="any" class="form-control" id="pf1" name="ppf1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf2" class="me-3 mb-0" style="width: 30px;">PF2</label>
      <input type="number" step="any" class="form-control" id="pf2" name="ppf2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf3" class="me-3 mb-0" style="width: 30px;">PF3</label>
      <input type="number" step="any" class="form-control" id="pf3" name="ppf3">
    </div>
  </td>
        <td>
        <div class="mb-1 d-flex align-items-center">
      <label for="v1" class="me-3 mb-0" style="width: 30px;">V1</label>
      <input type="number" step="any" class="form-control" id="v1" name="cv1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="v2" class="me-3 mb-0" style="width: 30px;">V2</label>
      <input type="number" step="any" class="form-control" id="v2" name="cv2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="v3" class="me-3 mb-0" style="width: 30px;">V3</label>
      <input type="number" step="any" class="form-control" id="v3" name="cv3">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i1" class="me-3 mb-0" style="width: 30px;">I1</label>
      <input type="number" step="any" class="form-control" id="i1" name="ci1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i2" class="me-3 mb-0" style="width: 30px;">I2</label>
      <input type="number" step="any" class="form-control" id="i2" name="ci2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="i3" class="me-3 mb-0" style="width: 30px;">I3</label>
      <input type="number" step="any" class="form-control" id="i3" name="ci3">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf1" class="me-3 mb-0" style="width: 30px;">PF1</label>
      <input type="number" step="any" class="form-control" id="pf1" name="cpf1">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf2" class="me-3 mb-0" style="width: 30px;">PF2</label>
      <input type="number" step="any" class="form-control" id="pf2" name="cpf2">
    </div>

    <div class="mb-1 d-flex align-items-center">
      <label for="pf3" class="me-3 mb-0" style="width: 30px;">PF3</label>
      <input type="number" step="any" class="form-control" id="pf3" name="cpf3">
    </div>
        </td>
      </tr>
    </table>

	  

    <button type="submit" class="btn btn-primary mt-3">Add Readings</button>
  </form>
</div>




      </div>

      <!-- Right Column: Record Table -->
      
    </div>
  </div>
  <script src="https://apms.cisnr.com/assets/js/jquery.min.js"></script>
  
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
  <script>
	$(document).ready(function(){
		flatpickr("#readingDate", {
      dateFormat: "d-m-Y"  // This sets the format to Day-Month-Year
    });
	
	 $('#GID').select2({
  placeholder: 'Select Global Device ID'
});
    
});
  </script>
</body>
</html>
