@extends('layouts.app')

@section('center')
    <style>
        .wb {
            border-left: 1px solid white !important;
        }

        .bb {
            border-left: 1px solid lightgray !important;
        }
    </style>
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.css"/>
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.date.css"/>
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/bs-select/bs-select.css"/>

    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <form action="{{route('apmsrawpanel')}}">
                <div class="row gutters">
                    <div class="col-xl-2 col-lg-2 col-md-2 col-sm-2">

                        <div class="form-group">
                            <label class="label">Device ID</label>
                            <select class="form-control selectpicker" data-live-search="true"
                                    class="form-control DeviceId " name="DeviceId" required>
                                <option value=''>Select Device ID</option>
                                @foreach($tr_data as $k => $row)
                                    <option value="{{$row->global_device_id}}" @isset($_GET["DeviceId"])
                                        @if($_GET["DeviceId"]==$row->global_device_id)
                                            {{'selected'}}
                                            @endif
                                        @endisset>{{$row->global_device_id}}</option>
                                @endforeach

                            </select>
                        </div>


                    </div>


                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3">

                        <div class="form-group">
                            <label class="label">From Date</label>
                            {{--					<input type="text" class="form-control datepicker" required name="from" placeholder="From"--}}
                            <input type="datetime-local" class="form-control" required name="from" placeholder="From"
                                   @isset($_GET["from"])
                                       value="{{$_GET['from']}}"
                                @endisset >
                        </div>

                    </div>

                    <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3">

                        <div class="form-group">
                            <label class="label">To Date</label>
                            {{--					<input type="text" class="form-control datepicker" required name="to" placeholder="To"--}}
                            <input type="datetime-local" class="form-control" required name="to" placeholder="To"
                                   @isset($_GET["to"])
                                       value="{{$_GET['to']}}"
                                @endisset >
                        </div>

                    </div>

                    <div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
                        <div class="form-group">
                            <label class="label">&nbsp;</label>
                            <button type="submit" class="form-control btn btn-primary generate">Generate</button>
                        </div>

                    </div>
                </div>
            </form>
        </div>


        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-2 col-12">
            <div class="table-container">
                <div class="table-responsive" style="max-height: 800px; overflow-y: auto;">
                    <table class="table m-0 table-hover" style="font-size: 10px !important;">
                        <thead style="position: sticky; top: 0;  z-index: 1;">
                        <tr>
                            <th rowspan="2" class="text-center" style="text-align: center;">Time</th>
                            <th rowspan="2">GlobalID</th>
                            <th rowspan="2">Timing</th>
                            <th colspan="3" class="wb text-center">Voltages</th>
                            <th colspan="3" class="wb text-center">Currents</th>
                            <th colspan="3" class="wb text-center">Power Factors</th>
                            <th colspan="6" class="wb text-center">Energy (kWh)</th>
                            <!-- <th colspan="6" class="wb text-center">Energy (rkWh)</th> -->
                        </tr>
                        <tr>
                            <!-- Voltages -->
                            <th class="wb">v1</th>
                            <th>v2</th>
                            <th>v3</th>
                            <!-- Currents -->
                            <th class="wb">i1</th>
                            <th>i2</th>
                            <th>i3</th>
                            <!-- Power Factors -->
                            <th class="wb">pf1</th>
                            <th>pf2</th>
                            <th>pf3</th>
                            <!-- Energy (kWh) -->
                            <th class="wb">kwho1</th>
                            <th>kwho2</th>
                            <th>kwho3</th>
                            <th>kwhp1</th>
                            <th>kwhp2</th>
                            <th>kwhp3</th>
                            <!-- Reactive Energy (rkWh) -->
                            <!-- <th class="wb">rkwho1</th>
                            <th>rkwho2</th>
                            <th>rkwho3</th>
                            <th>rkwhp1</th>
                            <th>rkwhp2</th>
                            <th>rkwhp3</th>
                        </tr> -->
                        </thead>
                        <tbody class="recent-record-row">
                        @if($data && (!$data->isEmpty()))
                            @foreach($data as $row)

                                <tr>
                                    <td>{{appDate($row->packet_date_time)}}</td>
                                    <td @if($row->dmdt_phase==1)
                                        {{'class="bg-success"'}}
                                        @endif> {{$row->moduleid}}</td>
                                                        <td>{{appDate($row->server_date_time)}}</td>

                                    <td class="bb">{{$row->v_red}}</td>
                                    <td>{{$row->v_yellow}}</td>
                                    <td>{{$row->v_blue}}</td>
                                    <!-- Currents -->
                                    <td class="bb">{{$row->i_red}}</td>
                                    <td>{{$row->i_yellow}}</td>
                                    <td>{{$row->i_blue}}</td>
                                    <!-- Power Factors -->
                                    <td class="bb">{{$row->pf_red}}</td>
                                    <td>{{$row->pf_yellow}}</td>
                                    <td>{{$row->pf_blue}}</td>
                                    <!-- Energy (kWh) -->
                                    <td class="bb">{{$row->kwh_offpeak_red}}</td>
                                    <td>{{$row->kwh_offpeak_yellow}}</td>
                                    <td>{{$row->kwh_offpeak_blue}}</td>
                                           <td class="bb">{{$row->kwh_peak_red}}</td>
                                    <td>{{$row->kwh_peak_yellow}}</td>
                                    <td>{{$row->kwh_peak_blue}}</td>
                          
                      
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="25" class="text-danger">Record Not Found</td>
                            </tr>
                        @endif
                        </tbody>
                    </table>


                </div>
                <div class="d-flex  mt-3">
                    {{ $data->appends(request()->query())->links('pagination::bootstrap-4') }} <!-- You can change the pagination view style -->
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{asset('assets')}}/vendor/datepicker/js/picker.js"></script>
        <script src="{{asset('assets')}}/vendor/datepicker/js/picker.date.js"></script>
        <script src="{{asset('assets')}}/vendor/datepicker/js/custom-picker.js"></script>
        <script src="{{asset('assets')}}/vendor/bs-select/bs-select.min.js"></script>
        <script src="{{asset('assets')}}/js/main.js"></script>
        <script>

        </script>
    @endpush

@endsection
