@extends('layouts.app')

@section('center')
<style>

	.success{
		border-top: 5px solid green !important;
		/* color:white; */
	}

	.gray{
		border-top: 5px solid gray !important;
		/* color:white; */
	}
	.warning{
		border-top: 5px solid yellow !important;
		/* color:white; */
	}
	.info{
		border-top: 5px solid blue !important;
		/* color:white; */
	}

</style>
<div class="row gutters mb-1">
<div class="col-md-2">
          <form method="GET" action="{{ route('data-list-tabular') }}">
              <div class="input-group">
                <input type="text" class="form-control" name="search" placeholder="Search..." value="{{ Request::input('search') }}">
                <span class="input-group-btn">
                  <button type="submit" class="btn btn-primary" data-toggle="tooltip" data-original-title="Search"><i class="icon-search nav-icon" aria-hidden="true"></i></button>
                  <a href="{{ route('data-list-tabular') }}" class="btn btn-danger" data-toggle="tooltip" data-original-title="Clear Search"><i class="icon-close nav-icon" aria-hidden="true"></i></a>
                </span>
              </div>
          </form>
          </div>
</div>
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
			<table class="table table-hover table-bordered">
									<thead>
										<tr>
											 <td>Device ID </td>
{{--											 <td> MSN</td>--}}
{{--											 <td> SIM No</td>--}}
											 <td> Capacity (kva)</td>
											 <td> Mode</td>
											 <td> Type</td>
{{--											 <td> Category</td>--}}
											 <td> installed On</td>
											 <td>Peak Unit </td>
											 <td>Offpeak Unit </td>
											 <td>Switch Status</td>
											 <td> Action</td>

										</tr>
									</thead>
						@foreach($data as $k =>$row)






										<tr>

											<td>  {{$row->global_device_id}}</td>

{{--											<td>  {{$row->msn}}</td>--}}
{{--											<td>  {{$row->sim_number}}</td>--}}
											<td>  {{$row->kva}}</td>
											<td>  {{($row->dmdt_bidirectional_device) ? 'Gross Meter' :'Net Meter' }} </td>

											<td>  {{$row->dmdt_phase}} Phase</td>
{{--											<td>  {{$row->category}}</td>--}}
											<td>  {{$row->installed_on}}</td>
											<td>  {{$row->peak}}</td>
											<td>  {{$row->offpeak}}</td>

											<td>  @if($row->auxr_status)
												 <span class="badge badge-success"> On</span>
												 @else
													<span class="badge badge-danger"> OFF</span>
													@endif
											</td>

                                            <td>
                                                <div class="d-flex flex-wrap gap-2">

                                                    {{-- Real-time Logs --}}
                                                    <a href="{{ route('item-real-time-data', $row->global_device_id) }}" class="btn btn-info px-2 py-1">
                                                        Real Time Logs
                                                    </a>

                                                    {{-- AUX Relay Switch --}}
                                                    @if($row->auxr_status == 1)
                                                        <a href="{{ route('item-switch', $row->global_device_id) }}" class="btn btn-danger px-3 ml-1">
                                                            Switch Off
                                                        </a>
                                                    @else
                                                        <a href="{{ route('item-switch', $row->global_device_id) }}" class="btn btn-success px-3 ml-1" tad-tr-id="{{ $row->global_device_id }}">
                                                            Switch On
                                                        </a>
                                                    @endif

                                                    {{-- View Config --}}
                                                    <a href="#" data-g-id="{{ $row->global_device_id }}" class="btn btn-secondary px-3 ml-1 get_config">
                                                        View Config
                                                    </a>

                                                    {{-- Edit --}}
                                                    <a href="{{ route('editTransformerForm', $row->global_device_id) }}" class="btn btn-info px-3 ml-1">
                                                        Edit
                                                    </a>

                                                    {{-- Delete --}}
                                                    <a href="{{ route('item-data-delete', $row->global_device_id) }}" class="btn btn-danger px-3 ml-1">
                                                        Delete
                                                    </a>

                                                </div>
                                            </td>

                                        </tr>

				@endforeach
				</table>
    <!-- Pagination -->
    <div class="d-flex justify-content-center mt-3">
        {!! $data->appends(request()->input())->links('pagination::bootstrap-4') !!}
    </div>

				</div>

				<!-- Modal -->
					<div class="modal fade" id="deviceModal" tabindex="-1" aria-labelledby="deviceModalLabel" aria-hidden="true">
					<div class="modal-dialog modal-lg">
						<div class="modal-content">
						<div class="modal-header">
							<h5 class="modal-title" id="deviceModalLabel">Device Configuration</h5>
                            <button type="button" class="btn-close-custom" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
						<div class="modal-body">
						<div id="deviceDataFlex" class="d-flex flex-wrap gap-3">
						<!-- Dynamic content will be inserted here using Flexbox -->
						</div>
						</div>
						</div>
					</div>
					</div>


					@push('scripts')
					<script>

$(document).ready(function() {
    $(document).on('click', '.get_config', function() {
        var id = $(this).data('g-id');

        $.ajax({
            url: "{{ url('get-cofiguration') }}/" + id,
            type: "GET",
            dataType: "json",
            // success: function(response) {
            //     console.log("Device Data:", response);
            //
            //     // Create dynamic content using Flexbox
            //     var deviceDataHtml = '';
            //     for (var key in response.data) {
            //         if (response.data.hasOwnProperty(key)) {
            //             // Create a card (flex item) for each key-value pair
            //             deviceDataHtml += `
            //                 <div class="card p-2" style="width: 200px;">
            //                     <div class="card-body">
            //                         <strong>${key}</strong>: ${response[key]}
            //                     </div>
            //                 </div>
            //             `;
            //         }
            //     }
            //
            //     // Insert the generated HTML into the flex container
            //     $('#deviceDataFlex').html(deviceDataHtml);
            //
            //     // Show the modal
            //     var myModal = new bootstrap.Modal(document.getElementById('deviceModal'));
            //     myModal.show();
            // },
            success: function(response) {
                console.log("Device Data:", response);

                var deviceDataHtml = '';

                if (!response.data || Object.keys(response.data).length === 0) {
                    // No data found
                    deviceDataHtml = `
            <div class="w-100 text-center" role="alert">
                No data found.
            </div>
        `;
                } else {
                    // Loop through and display each key-value pair
                    for (var key in response.data) {
                        if (response.data.hasOwnProperty(key)) {
                            deviceDataHtml += `
                    <div class="card p-2" style="width: 200px;">
                        <div class="card-body">
                            <strong>${key}</strong>: ${response.data[key]}
                        </div>
                    </div>
                `;
                        }
                    }
                }

                // Insert the generated HTML into the flex container
                $('#deviceDataFlex').html(deviceDataHtml);

                // Show the modal
                var myModal = new bootstrap.Modal(document.getElementById('deviceModal'));
                myModal.show();
            },


            error: function(xhr) {
                console.error("Error fetching data:", xhr);
            }
        });
    });
});

// close buttons has been updated for modal
document.addEventListener("DOMContentLoaded", function () {
    const closeBtn = document.querySelector(".btn-close-custom");
    const modal = document.getElementById("deviceModal");

    closeBtn.addEventListener("click", function () {
        // Hide modal
        modal.classList.remove("show");
        modal.style.display = "none";
        modal.setAttribute("aria-hidden", "true");

        // Remove backdrop if exists
        const backdrop = document.querySelector(".modal-backdrop");
        if (backdrop) {
            backdrop.remove();
        }

        // Remove 'modal-open' from body (restores scroll)
        document.body.classList.remove("modal-open");
        document.body.style = "";
    });
});


					</script>


                    @endpush
@endsection()
