@extends('layouts.app')

@section('center')
<style> 

	.success{
		border-top: 5px solid green !important;
		/* color:white; */
	}

	.gray{
		border-top: 5px solid gray !important;
		/* color:white; */
	}
	.warning{
		border-top: 5px solid yellow !important;
		/* color:white; */
	}
	.info{
		border-top: 5px solid blue !important;
		/* color:white; */
	}


</style>
<div class="row gutters">
				@foreach($data as $k =>$row)
				@php
				
					
						$ctime = new DateTime(); // Current date and time
						$dtime = new DateTime($row->datetime); // Specific DateTime
						
						$interval = $ctime->diff($dtime);
						$minutes = ($interval->days * 24 * 60) + ($interval->h * 60) + $interval->i;
						
						if($minutes>=5)
						{
							$color = "info";
							$state = "Offline"; 
						}
						else{
							if (($row->v1 > 0 && $row->v1 <= 100) && ($row->v2 > 0 && $row->v2 <= 100) && ($row->v3 > 0 && $row->v3 <= 100))
							{
								$color = "secondary"; 
								$state = "Link Down";
							}
							else if (($row->v1 > 100 && $row->v1 <= 150) && ($row->v2 > 100 && $row->v2 <= 150) && ($row->v3 > 100 && $row->v3 <= 150))
							{
								$color = "warning";
								$state = "Over Voltage";
							}
							else{
								$color = "success";
								$state = "On";
							}
							
                        }
					
				@endphp
						<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2 col-12">
							<figure class="user-card {{$color}}" >
								<figcaption>
									<!-- <img src="img/user11.png" alt="Royal Hospitals Admin Template" class="profile"> -->
									<h5>{{round((($row->c1*$row->v1)/1000)+(($row->c2*$row->v2)/1000)+(($row->c3*$row->v3)/1000),2)}} KVA  <span class="badge badge-{{$color}}"> {{$state}}</span></h5>
									<!-- <hr/> -->
									<!-- <h5>Staus: </h5> -->
									{{--<h6 class="designation">Status :  <span class="badge badge-{{$color}}"> {{$state}}</span> <br/> </h6>--}}
									<!-- <p>Doctors are licensed health professionals who maintain and restore human health through the practice of medicine.</p> -->
									<p class="timing">{{$row->datetime}}</p>
									<table class="table table-hover table-bordered"> 
										<tr> <td><b>Device ID:  {{$row->trid}} </b></td></tr>
										<tr> 
										@if($row->status==1)
											<td>Switch Status:  <span class="badge badge-success"> On</span></td>
										@else
										<td>Switch Status:  <span class="badge badge-danger"> Off</span></td>
										@endif	
										</tr>
										<tr> 
											<td>Current 1:  {{$row->c1}}</td>
										</tr>
										<tr> 
											<td>Current 2:  {{$row->c2}}</td>
										</tr>
										<tr> 
											<td>Current 3:  {{$row->c3}}</td>
										</tr>
										<tr> 
											<td>Voltage 1:  {{$row->v1}}</td>
										</tr>

										<tr> 
											<td>Voltage 2:  {{$row->v2}}</td>
										</tr>

										<tr> 
											<td>Voltage 3:  {{$row->v3}}</td>
										</tr>
										

										<tr> 
											<td>Power Factor 1:  {{$row->pf1}}</td>
										</tr>

										<tr> 
											<td>Power Factor 2:  {{$row->pf1}}</td>
										</tr>
										<tr> 
											<td>Power Factor 3:  {{$row->pf1}}</td>
										</tr>
									</table>
									<!-- <div class="doctors-list">
										Dr. John Willams
										<a href="#">Dr. K Sam Kumar</a>
										<a href="#">Dr. N Preethish Kumar</a>
										<a href="#">Dr. G Chandrashekar</a>
									</div> -->

									<div class="clearfix">
										<a href="{{route('item-data',$row->trid)}}" class="btn btn-{{$color}}">
											View Details
										</a>
										@if($row->status==1)
										<a href="{{route('item-switch',$row->trid)}}" class="btn btn-danger">
											Switch Off
										</a>
										@else

										<a href="{{route('item-switch',$row->trid)}}" class="btn btn-success " tad-tr-id="{{$row->trid}}">
											Switch On
										</a>
										@endif
									</div>
								</figcaption>
							</figure>
						</div>
				@endforeach		
					</div>
					@push('scripts')
					@endpush			
@endsection()