@extends('layouts.app')

@section('center')
<style>
    /* Customize map container */
    #map {
        height: 800px;
        width: 100%;
        border-radius: 10px; /* Rounded corners for aesthetics */
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1); /* Light shadow for a more modern look */
    }

    /* Optional: Make the map container have a smooth transition on hover */
    #map:hover {
        transition: transform 0.3s ease-in-out;
        transform: scale(1.02);
    }

</style>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>

<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <div id="map"></div> <!-- The map container -->
    </div>
</div>

@push('scripts')
{{--<script>--}}
{{--    // Step 1: Load and filter locations with valid coordinates (non-null, non-zero)--}}
{{--    var locations = @json($data).filter(function(location) {--}}
{{--        return location.latitude && location.longitude &&--}}
{{--               location.latitude != 0 && location.longitude != 0;--}}
{{--    });--}}

{{--    if (locations.length > 0) {--}}
{{--        // Step 2: Initialize the map with a default center (use the first valid location)--}}
{{--        var map = L.map('map');--}}

{{--        // Step 3: Add a nice tile layer for the map background (better visuals)--}}
{{--        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {--}}
{{--            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',--}}
{{--            maxZoom: 30,--}}
{{--            subdomains: ['a', 'b', 'c'],--}}
{{--        }).addTo(map);--}}

{{--        // Step 4: Create a list to store all the marker bounds--}}
{{--        var bounds = [];--}}

{{--        // Step 5: Loop through locations and add individual markers to the map--}}
{{--        locations.forEach(function(location) {--}}
{{--            var marker = L.marker([location.latitude, location.longitude]).addTo(map)--}}
{{--                .bindPopup(--}}
{{--                    `<b>Device ID: ${location.global_device_id}</b><br>--}}
{{--                    Latitude: ${location.latitude}<br>--}}
{{--                    Longitude: ${location.longitude}`--}}
{{--                );--}}

{{--            // Add the marker position to the bounds list--}}
{{--            bounds.push([location.latitude, location.longitude]);--}}
{{--        });--}}

{{--        // Step 6: Adjust map bounds to fit all markers--}}
{{--        map.fitBounds(bounds);--}}
{{--    } else {--}}
{{--        alert('No valid location data available.');--}}
{{--    }--}}
{{--</script>--}}

<script>
    var locations = @json($data).filter(function(location) {
        return location.latitude && location.longitude &&
            location.latitude != 0 && location.longitude != 0;
    });

    if (locations.length > 0) {
        var map = L.map('map');

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
            maxZoom: 30,
            subdomains: ['a', 'b', 'c'],
        }).addTo(map);

        var bounds = [];

        locations.forEach(function(location) {
            var marker = L.marker([location.latitude, location.longitude]).addTo(map);

            // Create a popup instance manually
            var popup = L.popup({
                autoClose: false,   // Don't close other popups
                closeOnClick: false // Don't close when clicking on another marker
            }).setContent(
                `<b>Device ID: ${location.global_device_id}</b><br>
                Latitude: ${location.latitude}<br>
                Longitude: ${location.longitude}`
            );

            // Show popup when marker is clicked
            marker.on('click', function () {
                popup.setLatLng(marker.getLatLng()).openOn(map);
            });

            bounds.push([location.latitude, location.longitude]);
        });

        map.fitBounds(bounds);
    } else {
        alert('No valid location data available.');
    }
</script>



@endpush

@endsection
