@extends('layouts.app')

@section('center')

<style>
  #tree {
    max-width: 600px;
    margin: 20px auto;
    border: 1px solid #ccc;
    padding: 10px;
    background: #fafafa;
    border-radius: 4px;
    font-family: Arial, sans-serif;
  }
</style>

<link href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/jquery.fancytree/dist/skin-win8/ui.fancytree.min.css" rel="stylesheet" />


<div class="row gutters">
  <div class="col-12">
    <div id="tree"></div>
  </div>
</div>

@push('scripts')
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- jQuery UI (required by FancyTree) -->
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

<!-- FancyTree CSS -->

<!-- FancyTree JS -->
<script src="https://cdn.jsdelivr.net/npm/jquery.fancytree/dist/jquery.fancytree-all.min.js"></script>
<script>
  const rawData = @json($data['tree']);

  function convertNode(node) {
    return {
      title: node.global_device_id,
      key: node.id.toString(),
      folder: node.children && node.children.length > 0,
      children: node.children ? node.children.map(convertNode) : []
    };
  }

  const fancyTreeData = rawData.map(convertNode);

  $(function() {
    $("#tree").fancytree({
      source: fancyTreeData,
      click: function(event, data) {
        const target = event.originalEvent.target;
        // Redirect ONLY if clicked on the node text, not the toggle icon
        if ($(target).hasClass("fancytree-title")) {
          window.location.href = `/item-real-time-data/${data.node.title}`;
        }
        // Else, clicking toggle icon expands/collapses node automatically
      }
    });
  });
</script>
@endpush

@endsection
