@extends('layouts.app')

@section('center')

<link rel="stylesheet" href="{{ asset('assets/vendor/bs-select/bs-select.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/vendor/datepicker/css/classic.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/vendor/datepicker/css/classic.date.css') }}" />

<div class="row gutters">
    <div class="col-xl-12">
        <form action="{{ route('deviceGraphs') }}">
            <div class="row gutters">
                <div class="col-xl-3">
                    <div class="form-group">
                        <label class="label">Device ID</label>
                        <select class="form-control selectpicker" data-live-search="true" name="DeviceId">
                            <option value=''>Select Device ID</option>
                            @foreach($tr_data as $row)
                                <option value="{{ $row->global_device_id }}"
                                    {{ request('DeviceId') == $row->global_device_id ? 'selected' : '' }}>
                                    {{ $row->global_device_id }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-xl-3">
                    <div class="form-group">
                        <label class="label">Time Range</label>
                        <select name="range" class="form-control selectpicker">
                            <option value="last_hour" {{ request('range') == 'last_hour' ? 'selected' : '' }}>Last Hour</option>
                            <option value="last_day" {{ request('range') == 'last_day' ? 'selected' : '' }}>Last 24 Hours</option>
                            <option value="last_week" {{ request('range') == 'last_week' ? 'selected' : '' }}>Last 7 Days</option>
                            <option value="last_month" {{ request('range') == 'last_month' ? 'selected' : '' }}>Last 30 Days</option>
                            <option value="last_year" {{ request('range') == 'last_year' ? 'selected' : '' }}>Last Year</option>
                        </select>
                    </div>
                </div>

                <div class="col-xl-2">
                    <div class="form-group">
                        <label class="label">&nbsp;</label>
                        <button type="submit" class="form-control btn btn-primary">Generate</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

@if(!empty($graph_data) && count($graph_data))
<div class="row mt-4">
    <div class="col-md-6 mb-4">
        <div style="height: 400px;">
            <canvas id="voltageChart"></canvas>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div style="height: 400px;">
            <canvas id="currentChart"></canvas>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <div style="height: 400px;">
            <canvas id="nclChart"></canvas>
        </div>
    </div>

    <div class="col-md-6 mb-4">
        <h6 class="text-center">Neutral Current Peaks (NC > 10)</h6>
        <div style="height: 400px;">
            <canvas id="nclHighChart"></canvas>
        </div>
    </div>
</div>
@endif

@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@latest"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-zoom@2.0.1/dist/chartjs-plugin-zoom.min.js"></script>
<script src="{{ asset('assets/vendor/bs-select/bs-select.min.js') }}"></script>

<script>
const labels = [
    @foreach ($graph_data as $data)
        '{{ \Carbon\Carbon::parse($data->stime)->toDateTimeString() }}',
    @endforeach
];

const colors = ['rgba(214,30,24,0.6)', 'rgba(228,231,29,0.6)', 'rgba(33,142,206,0.6)'];

const createChart = (id, datasets) => {
    const ctx = document.getElementById(id).getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            scales: {
                x: {
                    type: 'time',
                    time: {
                        unit: '{{
                            request('range') === "last_month" ? "week" :
                            (request('range') === "last_week" ? "day" :
                            (request('range') === "last_day" ? "hour" : "minute"))
                        }}',
                        tooltipFormat: 'PPpp'
                    },
                    title: {
                        display: true,
                        text: 'Time'
                    }
                },
                y: {
                    beginAtZero: true
                }
            },
            plugins: {
                zoom: {
                    pan: {
                        enabled: true,
                        mode: 'x',
                        threshold: 5
                    },
                    zoom: {
                        wheel: {
                            enabled: true
                        },
                        pinch: {
                            enabled: true
                        },
                        mode: 'x'
                    }
                },
                legend: {
                    display: true
                }
            }
        }
    });
};

createChart('voltageChart', [
    { label: 'V1', data: [@foreach($graph_data as $d) {{ $d->v1 }}, @endforeach], borderColor: colors[0], fill: false },
    { label: 'V2', data: [@foreach($graph_data as $d) {{ $d->v2 }}, @endforeach], borderColor: colors[1], fill: false },
    { label: 'V3', data: [@foreach($graph_data as $d) {{ $d->v3 }}, @endforeach], borderColor: colors[2], fill: false }
]);

createChart('currentChart', [
    { label: 'I1', data: [@foreach($graph_data as $d) {{ $d->i1 }}, @endforeach], borderColor: colors[0], fill: false },
    { label: 'I2', data: [@foreach($graph_data as $d) {{ $d->i2 }}, @endforeach], borderColor: colors[1], fill: false },
    { label: 'I3', data: [@foreach($graph_data as $d) {{ $d->i3 }}, @endforeach], borderColor: colors[2], fill: false }
]);

createChart('nclChart', [
    { label: 'NC', data: [@foreach($graph_data as $d) {{ $d->ncl }}, @endforeach], borderColor: 'rgba(128, 0, 128, 0.6)', fill: false }
]);

// Filter for NC > 10
const highNcLabels = [];
const highNcValues = [];

@foreach ($graph_data as $d)
    @if ($d->ncl > 10)
        highNcLabels.push('{{ \Carbon\Carbon::parse($d->stime)->toDateTimeString() }}');
        highNcValues.push({{ $d->ncl }});
    @endif
@endforeach

// Create NC > 10 chart
const ctxHighNc = document.getElementById('nclHighChart').getContext('2d');
new Chart(ctxHighNc, {
    type: 'line',
    data: {
        labels: highNcLabels,
        datasets: [{
            label: 'NC > 10',
            data: highNcValues,
            borderColor: 'rgba(255, 99, 132, 0.8)',
            fill: false
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        interaction: {
            mode: 'index',
            intersect: false
        },
        scales: {
            x: {
                type: 'time',
                time: {
                    unit: '{{
                        request('range') === "last_month" ? "week" :
                        (request('range') === "last_week" ? "day" :
                        (request('range') === "last_day" ? "hour" : "minute"))
                    }}',
                    tooltipFormat: 'PPpp'
                },
                title: {
                    display: true,
                    text: 'Time'
                }
            },
            y: {
                beginAtZero: true
            }
        },
        plugins: {
            zoom: {
                pan: {
                    enabled: true,
                    mode: 'x',
                    threshold: 5
                },
                zoom: {
                    wheel: {
                        enabled: true
                    },
                    pinch: {
                        enabled: true
                    },
                    mode: 'x'
                }
            },
            legend: {
                display: true
            }
        }
    }
});
</script>
@endpush
