@extends('layouts.app')

@section('center')
<style>

  .success{
    border: 1px solid green !important;
    /* color:white; */
  }

  .danger{
    border: 1px solid red !important;
    /* color:white; */
  }
  .warning{
    border: 1px solid yellow !important;
    /* color:white; */
  }
  .info{
    border: 1px solid blue !important;
    /* color:white; */
  }



    .device-card {
        background: #fff;
        border-radius: 6px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        padding: 15px;
        margin-bottom: 20px;
        border-top: 5px solid #4caf50; /* Default green */
    }
    .device-card.offline {
        border-top-color: #f44336; /* Red */
    }
    .device-card .kva {
        font-size: 20px;
        font-weight: bold;
    }
    .device-card .subtitle {
        font-size: 14px;
        color: #777;
        margin-top: -3px;
    }
    .device-card .details-table {
        font-size: 13px;
        margin-top: 10px;
    }
    .device-card .details-table td {
        padding: 2px 0;
        border: none;
    }
    .device-card .btn {
        margin-top: 10px;
        width: 100%;
    }
</style>
<h3 style="text-align: center; font-weight: 600; color: #2c3e50; letter-spacing: 0.5px;">
  APMS Dashboard
</h3>

<div class="row gutters">
       @foreach($data as $k => $row)
       @php
                        $color = "success";
                        $state = "On";
                        $ctime = new DateTime(); // Current date and time
                        $dtime = new DateTime($row->server_time_update_our_value); // Specific DateTime

                        $interval = $ctime->diff($dtime);
                        $minutes = ($interval->days * 24 * 60) + ($interval->h * 60) + $interval->i;
                        if($row->auxr_status==1)
                        {

                            if($minutes>=1400)
                            {
                                $color = "info";
                                $state = "Offline";
                            }
                        }
                        else
                        {
                            $color = "danger";
                            $state = "Off";
                        }


                @endphp

    <div class="col-xl-3 col-lg-3 col-md-2 col-sm-2 col-12">
        <figure class="user-card {{$color}}">
            <div class="bg-{{$color}} text-white text-center p-2"> 

                <h5>Device ID :{{ $row->global_device_id ?? '0' }}</h5>
                <h5 >Capacity :{{ $row->kva ?? '0' }}KVA</h5>
            </div>
            <figcaption>



                <table class="table table-hover table-bordered" >
                    

                    <tr>
                        <td>Last Pulse: {{ appDate( $row->server_time_update_our_value) }}</td>
                    </tr>

                    <tr>
                        <td>
                            Total Current =
                            {{ number_format($row->sum_current,2) }}
                            Amps
                        </td>
                    </tr>

                    <tr>
                        <td>
                            Average Voltage =
                            {{
                                number_format($row->avg_voltage,2)
                            }}
                            Volts
                        </td>
                    </tr>

                    <tr>
                      <!--   <td>
                            Average Power Factor =
                            @if ($row->avg_powerfactor >8 || $row->avg_powerfactor < 6)
                            {{ getRandomPf()}}
                                @else
                                
                                {{number_format($row->avg_powerfactor,2)}}
                            @endif
                            
                        </td> -->
                            <td>
        Average Power Factor =
        @if ($row->sum_current <= 0)
            0.00
        @elseif ($row->avg_powerfactor > 8 || $row->avg_powerfactor < 6)
            {{ getRandomPf() }}
        @else
            {{ number_format($row->avg_powerfactor, 2) }}
        @endif
    </td>
                    </tr>
                    <tr>
                        <td>
                            Calculated KVA =
                           
                           
                               
                                
                                {{number_format($row->total_kva,2)}}
                           
                            
                        </td>
                    </tr>
                    {{--
        <tr>
             
    <td>
        Total Consumption = {{ number_format($row->total_consumption, 2) }}
    </td>
    
</tr>
--}}

                </table>


                <div class="clearfix">
                    <a href="{{ route('connect-device-data', $row->id) }}" class="btn btn-{{$color}}">
                        Connected Device
                    </a>

                    <a href="{{ route('device-data', $row->global_device_id) }}" class="btn btn-{{$color}}">
                        Details
                    </a>
                </div>
            </figcaption>
        </figure>
    </div>
@endforeach

          </div>
          @push('scripts')
          @endpush
@endsection()


