@extends('layouts.app')

@section('center')
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.css" />
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/datepicker/css/classic.date.css" />
    <link rel="stylesheet" href="{{asset('assets')}}/vendor/bs-select/bs-select.css" />
    <!-- <div class="row gutters">

    </div>	 -->

    <div class="content-wrapper">


        <div class="row justify-content-center gutters">
            <div class="col-xl-7 col-lg-7 col-md-9 col-sm-10">
                <form action="{{route('add-user')}}" method="post">
                    @csrf
                    <div class="card m-0">
                        <div class="card-header">
                            <div class="card-title">Add User</div>
                            <!-- <div class="card-sub-title">How can we help you? A placeholder for small description.</div> -->
                        </div>
                        <div class="card-body">



                            <div class="form-group row gutters">
                                <label for="inputName" class="col-sm-3 col-form-label text-right">Name </label>
                                <div class="col-sm-4">
                                    <input type="text" name = "name" class="form-control" id="inputName" required >
                                </div>
                            </div>

                            <div class="form-group row gutters">
                                <label for="inputName" class="col-sm-3 col-form-label text-right">Email</label>
                                <div class="col-sm-4">
                                    <input type="text" name = "email" class="form-control" id="inputName" required >
                                </div>
                            </div>

                            <div class="form-group row gutters">
                                <label for="inputSubject" class="col-sm-3 col-form-label text-right">Password</label>
                                <div class="col-sm-4">
                                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="form-group row gutters">
                                <label for="inputSubject" class="col-sm-3 col-form-label text-right">confirm password</label>
                                <div class="col-sm-4">
                                    <input type="text" class="form-control" name = "password_confirmation"  id="inputSubject" required>
                                </div>
                            </div>


                            <div class="form-group row gutters">
                                <label for="inputSubject" class="col-sm-3 col-form-label text-right">Status</label>
                                <div class="col-sm-4">
                                    <select name="status" class="form-control" required>
                                        <option value="1"> Active </option>
                                        <option value="0"> De-active </option>
                                    </select>
                                </div>
                            </div>

                            @if(auth()->user()->ugroups=='admin')

                                <div class="form-group row gutters" style="display: none">
                                    <label for="inputSubject" class="col-sm-3 col-form-label text-right">Company</label>
                                    <div class="col-sm-4">
                                        <select name="company" class="form-control" required>
                                            @foreach($company as $row)
                                                <option value="{{$row->id}}"> {{$row->title.' / '.$row->address.' / '.$row->email}} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            @endif

                            <div class="form-group row gutters" style="display: none">
                                <label for="inputSubject" class="col-sm-3 col-form-label text-right">Access Type</label>
                                <div class="col-sm-4">
                                    <input type="checkbox" name="phase1" value="1"> Phase1 Meter <br/>
                                    <input type="checkbox" name="phase3" value="3"> Phase3 Meter

                                </div>
                            </div>
                            <button type="submit" id="submit"  class="btn btn-primary float-right">Submit Form</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>


    </div>


    @push('scripts')
        <script src="{{asset('assets')}}/vendor/datepicker/js/picker.js"></script>
        <!-- <script src="{{asset('assets')}}/vendor/datepicker/js/picker.date.js"></script> -->
        <!-- <script src="{{asset('assets')}}/vendor/datepicker/js/custom-picker.js"></script> -->
        <script src="{{asset('assets')}}/vendor/bs-select/bs-select.min.js"></script>
        <script src="{{asset('assets')}}/js/main.js"></script>


    @endpush
@endsection
