@extends('layouts.app')

@section('center')
<link rel="stylesheet" href="{{asset('assets')}}/vendor/morris/morris.css" />
<style>
.morris-hover {
    background-color: #ffffff !important; /* White background */
    border: 1px solid #ddd; /* Optional: Add border to make it visible */
    color: #000000 !important;
}
.morris-hover .morris-hover-point {
    color: #000000 !important; /* Optional: Change the text color */
}
</style>

<div class="row gutters">
    <div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
        <input type="text" class="form-control" readonly value="{{$data->global_device_id}}">
        <br/>
    </div>
    <div class="col-xl-3 col-lg col-md-3 col-sm-3 col-12 ">
        <br/>
    </div>
</div>

<div class="row gutters">
		
			<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
				<div class="card">
					<div class="card-header">
						<div class="card-title">Current</div>
					</div>
					<div class="card-body">
						<div id="dayData" class="chart-height"></div>
					</div>
				</div>
			</div>

			<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
				<div class="card">
					<div class="card-header">
						<div class="card-title">Voltage</div>
					</div>
					<div class="card-body">
						<div id="dayData2" class="chart-height"></div>
					</div>
				</div>
			</div>
		
	</div>
	<div class="row">	
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
		<div >
			<h2>Device Logs</h2>
			<pre style="border:1px solid blue; padding: 5px;font-size:10px;" id='logs'>
			
			</pre>
		</div>
	</div>
</div>

@push('scripts')
<script src="{{asset('assets')}}/vendor/morris/raphael-min.js"></script>
<script src="{{asset('assets')}}/vendor/morris/morris.min.js"></script>

<script>
    $(document).ready(function() {
       let currentData = [];
        let voltageData = [];
        let graph_data= @json($graph_data);

        $.each(graph_data, function(index, item) {
       
            const newPoint1 = { 
                period: item.dtime, 
                phase_a: parseFloat(item.i1), 
                phase_b: parseFloat(item.i2), 
                phase_c: parseFloat(item.i3) 
            };

            currentData.push(newPoint1);

            const newPoint2 = { 
                period: item.dtime, 
                voltage_phase_a: item.v1, 
                voltage_phase_b: item.v2, 
                voltage_phase_c: item.v3 
            };

            voltageData.push(newPoint2); 

    });
       redrawCurrentGraph();
       redrawVoltageGraph();
        const deviceId = "{{ 'server_'.$data->global_device_id }}"; // Use the device ID
        const server = "{{env('WEBSOCKET_SERVER')}}";
        const port = "{{env('WEBSOCKET_PORT')}}";
        const sec_token = "{{env('YOUR_SERVER_SECRET_FOR_SOCKET_CONNECTION')}}";
        
        const socket = new WebSocket(`${server}:${port}?server_token=${sec_token}&gid=${deviceId}`);

        // Initialize data arrays for the graphs
       



        socket.onopen = function() {
            console.log('Connected to WebSocket server');
        };

        socket.onmessage = function(event) {
            const data = JSON.parse(event.data);
            console.log(data);
			updateCommandLogs(JSON.stringify(data));

            if (data.at === 'post_data' && data.a === 'instantaneous') {
                // Update graphs with the received data
                updateCurrentGraph(data.d);
                updateVoltageGraph(data.d);
            }
        };

        socket.onclose = function() {
            console.log('Disconnected from WebSocket server.');
        };

        socket.onerror = function(error) {
            console.error('WebSocket Error: ', error);
        };

        // Function to update the current graph
        function updateCurrentGraph(data) {
            const newPoint = { 
                period: data.dtime, 
                phase_a: parseFloat(data.i1), 
                phase_b: parseFloat(data.i2), 
                phase_c: parseFloat(data.i3) 
            };

            currentData.push(newPoint); // Add new point to the data array
			// Keep only the latest 20 records
			if (currentData.length > 20) {
					currentData.shift(); // Remove the oldest entry
				}

            // Redraw the graph with the accumulated data
            redrawCurrentGraph();
        }

        // Function to update the voltage graph
        function updateVoltageGraph(data) {
            const newPoint = { 
                period: data.dtime, 
                voltage_phase_a: data.v1, 
                voltage_phase_b: data.v2, 
                voltage_phase_c: data.v3 
            };

            voltageData.push(newPoint); // Add new point to the data array
			// Keep only the latest 20 records
			if (voltageData.length > 20) {
					voltageData.shift(); // Remove the oldest entry
				}
            // Redraw the graph with the accumulated data
            redrawVoltageGraph();
        }

        // Function to redraw the current graph
        function redrawCurrentGraph() {
            $('#dayData').empty(); // Clear the previous graph
            Morris.Line({
                element: 'dayData',
                data: currentData,
                xkey: 'period',
                ykeys: ['phase_a', 'phase_b', 'phase_c'],
                labels: ['Phase A', 'Phase B', 'Phase C'],
                resize: true,
                hideHover: "auto",
                gridLineColor: "#f5f1f100",
                pointFillColors: ['#ffffff'],
                pointStrokeColors: ['#ff5661'],
                lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
            });
        }

        // Function to redraw the voltage graph
        function redrawVoltageGraph() {
            $('#dayData2').empty(); // Clear the previous graph
            Morris.Line({
                element: 'dayData2',
                data: voltageData,
                xkey: 'period',
                ykeys: ['voltage_phase_a', 'voltage_phase_b', 'voltage_phase_c'],
                labels: ['Voltage A', 'Voltage B', 'Voltage C'],
                resize: true,
                hideHover: "auto",
                gridLineColor: "#f5f1f100",
                pointFillColors: ['#ffffff'],
                pointStrokeColors: ['#ff5661'],
                lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
            });
        }
    });

	function updateCommandLogs(command, color='black') {
            const logsDiv = document.getElementById('logs');
            
            // Create a new log entry with the specified color
            const logEntry = document.createElement('div');
            logEntry.innerHTML = `<b>[${new Date().toLocaleTimeString()}]:</b> ${command}`;
            // logEntry.style.backgroundColor = color; // Set the background color
            logEntry.style.color = color;  // Set the color for the log entry
			logEntry.style.marginBottom = '10px'; // Add margin bottom for spacing
			logEntry.style.borderBottom = '1px dotted #ccc'; // Add a dotted line

            // Add the new command to the logs
            logsDiv.prepend(logEntry); // Add to the top of the logs

            // Keep only the last 10 commands
            while (logsDiv.children.length > 15) {
                logsDiv.removeChild(logsDiv.lastChild);
            }
        }
</script>

@endpush

@endsection
