@extends('layouts.app')

@section('center')
    <style>

        .success{
            border-top: 5px solid green !important;
            /* color:white; */
        }

        .gray{
            border-top: 5px solid gray !important;
            /* color:white; */
        }
        .warning{
            border-top: 5px solid yellow !important;
            /* color:white; */
        }
        .info{
            border-top: 5px solid blue !important;
            /* color:white; */
        }

    </style>
    <div class="d-flex flex-wrap justify-content-between align-items-end mb-3" >
        <div><h4 class="mb-2"> Neutral Current Losses Graph</h4></div>
        <div class="d-flex align-items-end gap-2" >
            <form method="GET" action="{{ route('neutralLosses') }}" style="display: none">
                <div class="input-group">
                    <input type="text" class="form-control w-90" name="search" placeholder="Search by Device ID..." value="{{ Request::input('search') }}">
                    <span class="input-group-btn ms-1">
                    <button type="submit" class="btn btn-primary" data-toggle="tooltip" title="Search">
                        <i class="icon-search nav-icon" aria-hidden="true"></i>
                    </button>
                    <a href="{{ route('neutralLosses') }}" class="btn btn-danger" data-toggle="tooltip" title="Clear Search">
                        <i class="icon-close nav-icon" aria-hidden="true"></i>
                    </a>
                </span>
                </div>
            </form>
            <a id="exportBtn" href="#" class="btn btn-success ml-1" style="display: none">
                <i class="icon-arrow-down-circle"></i> Export to Excel  </a>
        </div>
    </div>
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            @php
                function haversineDistance($lat1, $lon1, $lat2, $lon2, $earthRadius = 6371) {
                    $latFrom = deg2rad($lat1);
                    $lonFrom = deg2rad($lon1);
                    $latTo = deg2rad($lat2);
                    $lonTo = deg2rad($lon2);

                    $latDelta = $latTo - $latFrom;
                    $lonDelta = $lonTo - $lonFrom;

                    $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                        cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
                    return $earthRadius * $angle;
                }

                $previousDevice = null;
                $totalDistance = 0;
               $firstpooldistance = null;
                $i = 1;
                                                                    $graphData = [];

            @endphp

            <table class="table table-bordered" id="table" style="display: none">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Global Device ID</th>
                    {{--                    <th>Type</th>--}}
                    <th>Latitude</th>
                    <th>Longitude</th>
                    <th>Distance</th>
                    <th>ANT Condt Resist</th>
                    <th>WASP Condt Resist</th>
                    <th>A NCl</th>
                    <th>W NCl</th>
                </tr>
                </thead>

                <tbody>
                {{--transformers--}}
                @foreach($devices as $device)
                    @php
                        $previousDevice = null;

                    @endphp

                    @foreach($device->children as $child)


                        <tr style="display: none">
                            {{--                            <td>{{ $i++ }}</td>--}}
                            <td>&nbsp;&nbsp;&nbsp;↳ {{ $child->global_device_id }}</td>
                            <td>{{ $child->installed_on }}</td>
                            <td>{{ $child->latitude }}</td>
                            <td>{{ $child->longitude }}</td>
                            <td>

                                @if($previousDevice)
                                    @php
                                        $distance = haversineDistance(
                                            $previousDevice->latitude,
                                            $previousDevice->longitude,
                                            $child->latitude,
                                            $child->longitude
                                        );
                                        $totalDistance += $distance;
                                    @endphp

                                    @if($distance < 1)
                                        {{ number_format($distance * 1000, 0) }} m
                                    @else
                                        {{ number_format($distance, 2) }} km
                                    @endif
                                @else
                                    @php
                                        $firstpooldistance = haversineDistance(
                                            $device->latitude,
                                            $device->longitude,
                                            $child->latitude,
                                            $child->longitude
                                        );
                         $totalDistance += $firstpooldistance;

                                    @endphp

                                    @if($firstpooldistance < 1)
                                        {{ number_format($firstpooldistance * 1000, 0) }} m
                                    @else
                                        {{ number_format($firstpooldistance, 2) }} km
                                    @endif
                                @endif

                            </td>
                        </tr>
                        @php $previousDevice = $child; @endphp
                    @endforeach

                    <tr>
                        <td>{{ $i++ }}</td>
                        <td><b>{{ $device->global_device_id }}</b></td>
                        <td>{{ $device->latitude }}</td>
                        <td>{{ $device->longitude }}</td>
                        <td><strong>{{ number_format($totalDistance, 2) }} km</strong></td>

                        @php
                            // Number of conductors
                            $nc = $device->nc;

                            // --------------------------
                            // ANT Conductor Calculation
                            // --------------------------
                            $area_ant = 54.6 * pow(10, -6);         // 54.6 mm² → m²
                            $resistivity_ant = 3.2 * pow(10, -8);   // Ω·m for ANT

                            $r_ant = $resistivity_ant * ($totalDistance * 1000 / $area_ant); // Resistance
                            $ncl_ant = pow($nc, 2) * $r_ant;                                  // NCL = NC² × R

                            // --------------------------
                            // WASP Conductor Calculation
                            // --------------------------
                            $area_wasp = 100 * pow(10, -6);         // 100 mm² → m²
                            $resistivity_wasp = 3.1 * pow(10, -8);  // Ω·m for WASP

                            $r_wasp = $resistivity_wasp * ($totalDistance * 1000 / $area_wasp); // Resistance
                            $ncl_wasp = pow($nc, 2) * $r_wasp;                                   // NCL = NC² × R

    $graphData[$device->global_device_id] = [
        'ant_ncl' => round($ncl_ant, 3),
        'wasp_ncl' => round($ncl_wasp, 3),
    ];


                        @endphp

                        {{-- Resistance and NCL display --}}
                        <td><strong>{{ number_format($r_ant, 3) }}</strong></td>     {{-- ANT Resistance --}}
                        <td><strong>{{ number_format($r_wasp, 3) }}</strong></td>    {{-- WASP Resistance --}}

                        <td id="ant_ncl_{{ $device->global_device_id }}"> <strong>{{ number_format($ncl_ant, 3) }}</strong></td>   {{-- ANT NCL --}}

                        <td id="wasp_ncl_{{ $device->global_device_id }}"> <strong>{{ number_format($ncl_wasp, 3) }}</strong> </td>  {{-- WASP NCL --}}

                    </tr>

                @endforeach
                </tbody>

            </table>



        </div>
    </div>

    @php
        $deviceLabels = array_keys($graphData);

        $antNclValues = array_column($graphData, 'ant_ncl');
        $waspNclValues = array_column($graphData, 'wasp_ncl');
    @endphp

    <div class="col-md-12 mb-4 mt-5">
        <h4 class="text-center">ANT Neutral Current Loss (NCL)</h4>
        <div style="height: 400px;">
            <canvas id="antNclChart"></canvas>
        </div>
    </div>

{{--    <div class="col-md-12 mb-4 mt-5">--}}
{{--        <h4 class="text-center">WASP Neutral Current Loss (NCL)</h4>--}}
{{--        <div style="height: 400px;">--}}
{{--            <canvas id="waspNclChart"></canvas>--}}
{{--        </div>--}}
{{--    </div>--}}



    @push('scripts')
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@latest"></script>
        <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-zoom@2.0.1/dist/chartjs-plugin-zoom.min.js"></script>
        <script src="{{ asset('assets/vendor/bs-select/bs-select.min.js') }}"></script>
        <script>
            const labels = @json($deviceLabels);
            const antData = @json($antNclValues);
            const waspData = @json($waspNclValues);

            // ANT NCL Chart
            new Chart(document.getElementById('antNclChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'ANT NCL',
                        data: antData,
                        backgroundColor: 'rgba(54, 162, 235, 0.6)'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    indexAxis: 'y',
                    scales: {
                        x: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Neutral Current Loss'
                            }
                        },
                        y: {
                            title: {
                                display: true,
                                text: 'Device ID'
                            },
                            ticks: {
                                autoSkip: false,
                                maxRotation: 0,
                                minRotation: 0
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top'
                        }
                    }
                }
            });

            // WASP NCL Chart
            new Chart(document.getElementById('waspNclChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'WASP NCL',
                        data: waspData,
                        backgroundColor: 'rgba(255, 99, 132, 0.6)'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    indexAxis: 'y',
                    scales: {
                        x: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Neutral Current Loss'
                            }
                        },
                        y: {
                            title: {
                                display: true,
                                text: 'Device ID'
                            },
                            ticks: {
                                autoSkip: false,
                                maxRotation: 0,
                                minRotation: 0
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top'
                        }
                    }
                }
            });

        </script>

    @endpush
@endsection()
