@extends('layouts.app')

@section('center')
    <style>
        .success {
            background-color: #e6f4ea !important; /* Soft green e6f4ea*/
            border-top: 4px solid #9e9e9e !important;
            color: #1b5e20;
        }

        .gray {
            background-color: #f4f4f4 !important; /* Light gray  f4f4f4*/
            border-top: 4px solid #9e9e9e !important;
            color: #333;
        }

        .warning {
            background-color: #fff9e6 !important; /* Soft yellow fff9e6 */
            border-top: 4px solid #9e9e9e !important;
            color: #795548;
        }

        .info {
            /*background-color: #aae7db !important; !* Soft blue e7f3fe*!*/
            border-top: 4px solid #9e9e9e !important;
            color: #0d47a1;
        }

        /* Optional: make the icon column bold and spaced */
        .device-row td:first-child {
            font-weight: bold;
        }
    </style>


    <div class="d-flex flex-wrap justify-content-between align-items-end mb-3">
        <div>
            <h4 class="mb-0">Devices list</h4>
        </div>
        <div class="d-flex align-items-end gap-2">
            <form method="GET" action="{{ route('deviceListReport') }}" class="d-flex">
                <div class="input-group" style="min-width: 300px;">
                    <input type="text" id="searchInput" name="search" class="form-control"
                           placeholder="Search by Global Device ID...">
                    <button type="button" class="btn btn-primary ms-1" onclick="clearSearch()">
                        <i class="icon-close nav-icon" aria-hidden="true"></i>
                    </button>
                </div>
            </form>
            <a id="exportBtn" href="#" class="btn btn-success ml-1">
                <i class="icon-arrow-down-circle"></i> Export to Excel
            </a>
        </div>
    </div>

    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <table class="table table-hover table-bordered" id="table">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Global Device ID</th>
                    <th>Installed On</th>
                    <th>Mode</th>
                    <th>Meter Type</th>
                    <th>Meter Category</th>
                </tr>
                </thead>
                <tbody>
                @php
                    $i = 1;

                    function renderDeviceRow($device, $level = 0, $prefix = '') {
                        global $i;

                        // Adjusted indent for visual clarity
                        $indent = str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $device->installed_on === 'connection' ? 4 : $level);

                        $icon = match($device->installed_on) {
                        'transformer' => 'icon-zap',              // 🟢 represents electronic device
                         'pole' => 'icon-anchor',                 // 🟠 stable, grounded icon (closest visual match to pole)
                         'connection' => 'icon-cpu',              // 🔌 electrical connection
                        default => 'icon-flickr'         // ⚠️ default warning
                    };


                        $colorClass = match($device->installed_on) {
                            'transformer' => '#0d47a1', //info - blue
                            'pole' => '#1b5e20',
                            'connection' => '#000000',  //  green// same for all connections
                            default => 'warning'
                        };

                        $boldOpen = $device->installed_on === 'transformer' ? '<b>' : '';
                        $boldClose = $device->installed_on === 'transformer' ? '</b>' : '';

                        echo "<tr class='device-row'>";
                        echo "<td>" . $i++ . "</td>";
                        echo "<td style='color:{$colorClass}'>{$indent}{$prefix} {$boldOpen}<i class='{$icon}'></i>  {$device->global_device_id}{$boldClose} </td>";
                        echo "<td>{$device->installed_on}</td>";
                        echo "<td>" . ($device->dmdt_bidirectional_device ? 'Gross Meter' : 'Net Meter') . "</td>";
                        echo "<td>" . ($device->dmdt_phase) . " Phase</td>";
                        echo "<td>" . ($device->category) . "</td>";
                        echo "</tr>";

                        if ($device->children && $device->children->count()) {
                            // 1. Show connections first (with deep indent)
                            foreach ($device->children->where('installed_on', 'connection') as $child) {
                                renderDeviceRow($child, $level, '');  // fixed level for all connections
                            }

                            // 2. Then poles and other devices (recursive)
                            foreach ($device->children->where('installed_on', '!=', 'connection') as $child) {
                                renderDeviceRow($child, $level + 1, '↳');
                            }
                        }
                    }
                @endphp




                @foreach ($devices as $device)
                    @php renderDeviceRow($device); @endphp
                @endforeach
                </tbody>
            </table>
        </div>
    </div>

    @push('scripts')
        <script>
            document.getElementById('searchInput').addEventListener('keyup', function () {
                let filter = this.value.toLowerCase();
                let rows = document.querySelectorAll('.device-row');

                rows.forEach(function (row) {
                    let text = row.textContent.toLowerCase();
                    row.style.display = text.includes(filter) ? '' : 'none';
                });
            });

            function clearSearch() {
                document.getElementById('searchInput').value = '';
                document.querySelectorAll('.device-row').forEach(row => row.style.display = '');
            }
        </script>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
        <script>
            document.getElementById('exportBtn').addEventListener('click', function () {
                let table = document.querySelector('table');
                let wb = XLSX.utils.table_to_book(table, {sheet: "Devices Distance"});
                XLSX.writeFile(wb, 'devices_distance_report.xlsx');
            });
        </script>
    @endpush
@endsection
