@extends('layouts.app')

@section('center')


<!-- JS & CSS for jsTree -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jstree/3.3.12/themes/default/style.min.css" />

<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <form action="{{route('technicalReportForm')}}">
            <div class="row gutters">
			<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2">
			<!-- <label class="label">Total Technical Loss </label> -->
			</div>
				
            </div>
        </form>
    </div>
                 
	
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6 mt-5">
    <div class="mb-5">
        <h5>KWHP Difference (Daily)</h5>
        <canvas id="kwhpChart" height="100"></canvas>
    </div>
    </div>
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6 mt-5">
    <div class="mb-5">
        <h5>KWHO Difference (Daily)</h5>
        <canvas id="kwhoChart" height="100"></canvas>
    </div>
    </div>

<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6 mt-5">
  <div class="container">
    <h4>Voltage Comparison (PVx vs CVx)</h4>
    <canvas id="voltageChart" height="100"></canvas>
  </div>
</div>

<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-6 mt-5">
  <div class="container">
    <h4>Current Comparison (PIx vs CIx)</h4>
    <canvas id="currentChart" height="100"></canvas>
  </div>
</div>


@push('scripts')


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
        const kwhp = @json($kwhpDiffs);
    const kwho = @json($kwhoDiffs);

    const kwhpLabels = kwhp.map(d => d.rdate);
    const kwhpCisnr = kwhp.map(d => d.cisnr_diff);
    const kwhpPesco = kwhp.map(d => d.pesco_diff);

    const kwhoLabels = kwho.map(d => d.rdate);
    const kwhoCisnr = kwho.map(d => d.cisnr_diff);
    const kwhoPesco = kwho.map(d => d.pesco_diff);

    new Chart(document.getElementById('kwhpChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: kwhpLabels,
            datasets: [
                {
                    label: 'CISNR Δ KWHP',
                    data: kwhpCisnr,
                    borderColor: '#007bff',
                    fill: false
                },
                {
                    label: 'PESCO Δ KWHP',
                    data: kwhpPesco,
                    borderColor: '#ffc107',
                    borderDash: [5, 5],
                    fill: false
                }
            ]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'KWHP Daily Differences'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    new Chart(document.getElementById('kwhoChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: kwhoLabels,
            datasets: [
                {
                    label: 'CISNR Δ KWHO',
                    data: kwhoCisnr,
                    borderColor: '#28a745',
                    fill: false
                },
                {
                    label: 'PESCO Δ KWHO',
                    data: kwhoPesco,
                    borderColor: '#dc3545',
                    borderDash: [5, 5],
                    fill: false
                }
            ]
        },
        options: {
            plugins: {
                title: {
                    display: true,
                    text: 'KWHO Daily Differences'
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });


    // Voltage & Current Readings
    const rLabels = @json($readings->pluck('rdate')->map(fn($d) => \Carbon\Carbon::parse($d)->format('d-m-Y')));

    const pv1 = @json($readings->pluck('pv1'));
    const pv2 = @json($readings->pluck('pv2'));
    const pv3 = @json($readings->pluck('pv3'));
    const cv1 = @json($readings->pluck('cv1'));
    const cv2 = @json($readings->pluck('cv2'));
    const cv3 = @json($readings->pluck('cv3'));

    const pi1 = @json($readings->pluck('pi1'));
    const pi2 = @json($readings->pluck('pi2'));
    const pi3 = @json($readings->pluck('pi3'));
    const ci1 = @json($readings->pluck('ci1'));
    const ci2 = @json($readings->pluck('ci2'));
    const ci3 = @json($readings->pluck('ci3'));

    const voltageChart = new Chart(document.getElementById('voltageChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: rLabels,
            datasets: [
                {
                    label: 'PV1',
                    data: pv1,
                    borderColor: '#007bff',
                    fill: false
                },
                {
                    label: 'CV1',
                    data: cv1,
                    borderColor: '#6c757d',
                    fill: false
                },
                {
                    label: 'PV2',
                    data: pv2,
                    borderColor: '#17a2b8',
                    fill: false
                },
                {
                    label: 'CV2',
                    data: cv2,
                    borderColor: '#adb5bd',
                    fill: false
                },
                {
                    label: 'PV3',
                    data: pv3,
                    borderColor: '#28a745',
                    fill: false
                },
                {
                    label: 'CV3',
                    data: cv3,
                    borderColor: '#ced4da',
                    fill: false
                }
            ]
        }
    });

    const currentChart = new Chart(document.getElementById('currentChart').getContext('2d'), {
        type: 'line',
        data: {
            labels: rLabels,
            datasets: [
                {
                    label: 'PI1',
                    data: pi1,
                    borderColor: '#ff6384',
                    fill: false
                },
                {
                    label: 'CI1',
                    data: ci1,
                    borderColor: '#e0a800',
                    fill: false
                },
                {
                    label: 'PI2',
                    data: pi2,
                    borderColor: '#36a2eb',
                    fill: false
                },
                {
                    label: 'CI2',
                    data: ci2,
                    borderColor: '#ffc107',
                    fill: false
                },
                {
                    label: 'PI3',
                    data: pi3,
                    borderColor: '#4bc0c0',
                    fill: false
                },
                {
                    label: 'CI3',
                    data: ci3,
                    borderColor: '#fd7e14',
                    fill: false
                }
            ]
        }
    });
</script>


@endpush

@endsection
