@extends('layouts.app')

@section('center')
<style>

	.success{
		border-top: 5px solid green !important;
		/* color:white; */
	}

	.gray{
		border-top: 5px solid gray !important;
		/* color:white; */
	}
	.warning{
		border-top: 5px solid yellow !important;
		/* color:white; */
	}
	.info{
		border-top: 5px solid blue !important;
		/* color:white; */
	}


</style>
<div class="row gutters">
<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
	<div id="device-list">

	</div>
				</div>
					</div>
		@push('scripts')
			<script>
					$(document).ready(function() {
						const deviceId = "{{ 'server_7575' }}"; // Use the device ID
						const server = "{{env('WEBSOCKET_SERVER')}}";
						const port = "{{env('WEBSOCKET_PORT')}}";
						const sec_token = "{{env('YOUR_SERVER_SECRET_FOR_SOCKET_CONNECTION')}}";
						
						const socket = new WebSocket(`${server}:${port}?server_token=${sec_token}&gid=${deviceId}&admin=true`);

						socket.onopen = function() {
							console.log('Connected to WebSocket server');
						};

						socket.onmessage = function(event) {
							console.log(event.data);
								const data = JSON.parse(event.data);  // The list of connected devices
								updateDeviceList(data.d);  // Update the device list in the UI
							};

						socket.onclose = function() {
							console.log('Disconnected from WebSocket server.');
						};

						socket.onerror = function(error) {
							console.error('WebSocket Error: ', error);
						};

						function updateDeviceList(devices) {
							const deviceList = document.getElementById('device-list');
							deviceList.innerHTML = '';  // Clear the list

							// Populate the list with the current connected devices
							devices.forEach(device => {
								const li = document.createElement('li');
								li.textContent = `${device} is connected`;
								deviceList.appendChild(li);
							});
						}

					
					});

   
			</script>
		@endpush
@endsection()
