<!doctype html>
<html lang="en">

<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<!-- <meta name="author" content="ParkerThemes"> -->
		<!-- <link rel="shortcut icon" href="img/fav.png" /> -->

		<!-- Title -->
		<title>{{env('APP_NAME')}}</title>


		<!-- *************
			************ Common Css Files *************
			************ -->
		<!-- Bootstrap css -->
		<link rel="stylesheet" href="{{asset('assets/css')}}/bootstrap.min.css">

		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('assets/fonts')}}/style.css">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.css">

		<!-- Main css -->
		<link rel="stylesheet" href="{{asset('assets/css')}}/main.css">


		<!-- *************
			************ Vendor Css Files *************
		************ -->
		<style>

		.container-fluid{
			padding-right: 8px;
			padding-left: 8px;
		}

		.logout-container {
				position: absolute;
				top: 20px;
				right: 20px;
			}

			/* .logout-btn {
				background-color: #f8f9fa;
				color: #333;
				padding: 10px 20px;
				border-radius: 5px;
				font-size: 16px;
				text-decoration: none;
			} */

			/* .logout-btn:hover {
				background-color: #007bff;
				color: white;
			} */

			.top-banner img {
					width: 100%;
					height: 100Px;
					display: block;
					/* object-fit: cover; */
				}
				.top-banner {
					max-height: 100px; /* Adjust this value as needed */
					/* overflow: hidden; */
				}


		</style>

	</head>
	<body>

		<!-- Loading starts -->
		<div id="loading-wrapper">
			<div class="spinner-border" role="status">
				<span class="sr-only">Loading...</span>
			</div>
		</div>

		<div class="top-banner">
			<img src="{{ asset('assets/img/banner.jpg') }}" alt="Top Banner" style="height: 100px; width: 100%; ">
		
		</div>

		<!-- Loading ends -->


		<!-- *************
			************ Header section start *************
		************* -->




		<!-- *************
			************ Header section end *************
		************* -->


		<div class="container-fluid" style="padding: 0px !important;">



			<!-- Navigation start -->
			<nav class="navbar navbar-expand-lg custom-navbar">
				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#royalHospitalsNavbar" aria-controls="royalHospitalsNavbar" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon">
						<i></i>
						<i></i>
						<i></i>
					</span>
				</button>
				<div class="collapse navbar-collapse" id="royalHospitalsNavbar">
					<ul class="navbar-nav">
						<li class="nav-item">
							<a class="nav-link" href="{{route('home')}}">
								<i class="icon-devices_other nav-icon"></i>
								Dashboard
							</a>
						</li>
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-event_note nav-icon"></i>
								Meter
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">
								@if(auth()->user()->ugroups=='admin')
								<li>
									<a class="dropdown-item" href="{{route('addTransformerForm')}}"> Add Meter</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('addTransformerThresholdForm')}}">  Tripping Setting </a>
								</li>
								@endif

								<li>
									<a class="dropdown-item" href="{{route('data-list')}}">  List</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('data-list-tabular')}}">  List(Tabular)</a>
								</li>

								@if(auth()->user()->ugroups=='admin')
								<li>
									<a class="dropdown-item" href="{{route('data-list-connection')}}">Connection Status</a>
								</li>
								<li>
									<a class="dropdown-item" href="{{route('reading-list')}}"> Voltages Reading </a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('kwh-reading-list')}}"> KWH Reading</a>
								</li>
								@endif



								<!-- <li>
									<a class="dropdown-item" href="hospital-reviews.html">Hospital Reviews</a>
								</li> -->

							</ul>
						</li>
						@if(auth()->user()->ugroups=='admin')
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-users nav-icon"></i>
								User
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">
								<li>
									<a class="dropdown-item" href="{{route('add-user-form')}}">Add User</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('user-list')}}">User List</a>
								</li>
							</ul>
						</li>
						@endif

                        <li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-book-open nav-icon"></i>
								Logs
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">

								<li>
									<a class="dropdown-item" href="{{route('currentLog')}}">Current Logs</a>
								</li>
								

								<li>
									<a class="dropdown-item" href="{{route('kwhLog')}}">KWH Logs</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('thdlog')}}">THD Logs</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('kvaLog')}}">KVA Logs</a>
								</li>


								<li>
									<a class="dropdown-item" href="{{route('mdiLog')}}">MDI Logs</a>
								</li>
                                <li>
                                    <a class="dropdown-item" href="{{route('extraLog')}}">Extra Logs</a>
                                </li>
								<!-- <li>
									<a class="dropdown-item" href="hospital-reviews.html">Hospital Reviews</a>
								</li> -->

							</ul>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="{{route('alert')}}">
								<i class="icon-alert-triangle nav-icon"></i>
								Alert
							</a>
						</li>

						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-users nav-icon"></i>
								Graphs
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">
								<li>
									<a class="dropdown-item" href="{{route('technicalReportForm')}}">Technical Loss </a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('commercialReportForm')}}">Commercial Loss</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('deviceGraphs')}}">Meter Analytics</a>
								</li>
								<li>
									<a class="dropdown-item" href="{{route('deviceTree')}}">Meter Hierarchy Graph</a>
								</li>

								<li>
									<a class="dropdown-item" href="{{route('timeDomainGraph')}}">Time Domain Graph</a>
								</li>

                                <li>
                                    <a class="dropdown-item" href="{{route('data-list-map')}}"> Devices Map</a>

                                </li>
                             <li>
                                    <a class="dropdown-item" href="{{route('neutralCurrentLossGraph')}}"> Neutral Current Losses</a>

                                </li>

							</ul>
						</li>

						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-users nav-icon"></i>
								Reports
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">
								<li>
									<a class="dropdown-item" href="{{route('deviceListReport')}}">Device List </a>
								</li>
                                <li>
                                    <a class="dropdown-item" href="{{route('deviceDistanceReport')}}">Devices Distance </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{route('unresponsiveDevices')}}"> Unresponsive Devices </a>
                                </li>

                                <li>
                                    <a class="dropdown-item" href="{{route('neutralLosses')}}"> Neutral Current Losses </a>
                                </li>
							</ul>
						</li>


						@if(auth()->user()->ugroups=='admin')
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle" href="#" id="doctoRs" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-book-open nav-icon"></i>
								Development Logs
							</a>
							<ul class="dropdown-menu" aria-labelledby="doctoRs">
								<li>
									<a class="dropdown-item" href="{{route('errorLog')}}">Error Logs</a>
								</li>
							</ul>
						</li>


						<li class="nav-item">
							<a class="nav-link" href="{{route('rawpanel')}}">
								<i class=" nav-icon icon-view_headline"></i>
								Raw Panel
							</a>
						</li>
						<li class="nav-item">
							<a class="nav-link" href="{{route('apmsrawpanel')}}">
								<i class=" nav-icon icon-view_headline"></i>
								APMS Logs
							</a>
						</li>
						@endif
						{{--
						<li class="nav-item dropdown">
							<a class="nav-link dropdown-toggle active-page" href="#" id="pagesDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<i class="icon-book-open nav-icon"></i>
								Settings
							</a>
							<ul class="dropdown-menu" aria-labelledby="pagesDropdown">
								<li>
									<a class="dropdown-item" href="{{route('transformerSwitching')}}">Switching </a>
								</li>
								<!-- <li>
									<a class="dropdown-item" href="invoice.html">Invoice</a>
								</li> -->

							</ul>
						</li>
						--}}



					</ul>
				</div>
			</nav>
			<div class="logout-container">
					<!-- <a class="badge badge-pill badge-danger" title="logout" href="{{ route('logout') }}"
					onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
						<i class="icon-power_settings_new nav-icon"></i>
					</a>
					<form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
						@csrf
					</form> -->

					<!-- <div class="col-xl-8 col-lg-8 col-md-8 col-sm-8 col-8"> -->

						<!-- Header actions start -->
						<ul class="header-actions">


						<li class="dropdown">
								<a href="#" id="userSettings" class="user-settings" data-toggle="dropdown" aria-haspopup="true">
									<span class="user-name">{{auth()->user()->name}}</span>
									<span class="avatar">{{substr(auth()->user()->name, 0, 2);}}<span class="status busy"></span></span>
								</a>
								<div class="dropdown-menu dropdown-menu-right" aria-labelledby="userSettings">
									<div class="header-profile-actions">
										<div class="header-user-profile">
											{{--<div class="header-user">
												<img src="{{asset('assets')}}/img/user11.png" alt="Royal Hospitals Admin Template" />
											</div>
											--}}
											<h5>{{auth()->user()->name}} ({{ session('company_id') }})</h5>
											<p>Admin</p>
										</div>
										{{--
										<a href="#"><i class="icon-user1"></i> My Profile</a>
										<a href="#"><i class="icon-settings1"></i> Account Settings</a>
										<a href="#"><i class="icon-activity"></i> Activity Logs</a>
										--}}
										<a href="#"  onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"><i class="icon-log-out1"></i> Sign Out</a>

										<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                        @csrf
                                    </form>
									</div>
								</div>
							</li>
						</ul>
						<!-- Header actions end -->

					<!-- </div> -->
				</div>
			<!-- Navigation end -->


			<!-- *************
				************ Main container start *************
			************* -->
			<div class="main-container">


				<!-- Page header start -->
				<!-- <div class="page-header">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"></li>
						 <li class="breadcrumb-item active"></li>
					</ol>
					<div class="site-award">
						<img src="{{asset('assets')}}/img/award.svg" alt="Award"> APMS
					</div>
				</div> -->
				<!-- Page header end -->


				<!-- Content wrapper start -->
				<div class="content-wrapper">

				@yield('center')

				</div>
				<!-- Content wrapper end -->


			</div>
			<!-- *************
				************ Main container end *************
			************* -->

			<!-- <footer class="main-footer">© APMS 2024</footer> -->

		</div>

		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('assets')}}/js/jquery.min.js"></script>
		<script src="{{asset('assets')}}/js/bootstrap.bundle.min.js"></script>
		<script src="{{asset('assets')}}/js/moment.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js"></script>


		<!-- *************
			************ Vendor Js Files *************
		************* -->
		@stack('scripts')
		<!-- Main Js Required -->
		<script src="{{asset('assets')}}/js/main.js"></script>
		<script>
			$(document).ready(function(){

				function message(type,message_text)
				{
					if(type=='error')
					toastr.error(message_text);
					else if(type=='success')
					toastr.success(message_text);
				}

				toastr.options.closeButton = true;
				toastr.options.timeOut = 5000;
				@if(session()->has('success'))
				toastr.success("{{ session('success') }}");
				@endif
				@if(session()->has('error'))
				toastr.error("{{ session('error') }}");
				@endif
				@if(session()->has('info'))
				toastr.info("{{ session('info') }}");
				@endif
			})	;
		</script>

	</body>

<!-- Mirrored from www.bootstrapget.com/demos/themeforest/royal-hospitals-admin-templates/demos/design-option-1/default-layout.html by HTTrack Website Copier/3.x [XR&CO'2014], Wed, 31 Jul 2024 07:29:12 GMT -->
</html>
