<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{env('APP_NAME')}}</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
  
  <style>
    body {
      background-color: #f0f4f8;
    }

    .logo-container {
      background: linear-gradient(to right,rgb(237, 240, 244), #1e3283);
      padding: 10px;
      padding-left: 40px;
    }

    .logo-container img {
      max-height: 60px;
    }

    .card {
      border: none;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .form-control {
      border-radius: 5px;
    }

    .btn-primary {
      background-color: #0d6efd;
      border: none;
      border-radius: 5px;
    }

    .btn-primary:hover {
      background-color: #0b5ed7;
    }

    .table thead {
      background-color: #0d6efd;
      color: white;
    }
  </style>
</head>
<body>
  <!-- Logo Header -->
  <div class="logo-container mb-1">
    <img src="https://apms.cisnr.com/assets/img/cisnr.png" alt="Company Logo" />
  </div>
  <div class=" mb-2 px-4">
    <a class="btn  @if(request()->is('reading'))  btn-primary  @else  btn-outline-primary @endif" aria-current="page" id="showVoltageForm" href="{{url('reading')}}">Voltages Reading</a>
    <a class="btn @if(request()->is('kwh-reading'))  btn-primary  @else  btn-outline-primary @endif" href="{{url('kwh-reading')}}" id="showKwhForm">kWh Reading</a>
  </div>

  <div class="container-fluid px-4">
    <div class="row g-4">
      <!-- Left Column: Input Form -->
      <div class="col-md-4">
       <!-- Form Card -->
<!-- Form Card -->
<!-- Form Card -->
<!-- Form Card -->
<div class="card p-4">
@if(session('success'))
    <div class="alert alert-success mb-4" role="alert">
        {{ session('success') }}
    </div>
@endif
  <!-- <h5 class="card-title mb-1 text-primary">Enter Readings</h5> -->
   
  <form id="dataForm" method="post" action="{{ url('kwh-reading') }}" enctype="multipart/form-data">
    @csrf
    <div class="mb-3 d-flex align-items-center">
        <label for="DeviceId" class="me-3 mb-0" > GID </label>
        <select class="form-control selectpicker" data-live-search="true" name="DeviceId" id="GID">
            <option value="">Select Device ID</option>
            @foreach($tr_data as $row)
                <option value="{{ $row->global_device_id }}">{{ $row->global_device_id }} </option>
            @endforeach
        </select>
    </div>

    <div class="mb-3 d-flex align-items-center">
        <label for="readingDate" class="me-3 mb-0" >Date</label>
        <input type="date" class="form-control" id="readingDate" name="readingDate">
    </div>

    <hr/>
    <p> <b>Pesco Reading</b></p>

    <div class="mb-1 d-flex align-items-center">
        <label for="kwho1" class="me-3 mb-0" style="width: 220px;"> T.kWh Offpeak</label>
        <input type="number" step="any" class="form-control" id="pesco_total_kwho" name="pesco_total_kwho">
    </div>

    <div class="mb-1 d-flex align-items-center">
        <label for="kwho2" class="me-3 mb-0" style="width: 220px;">T.kWh Peak</label>
        <input type="number" step="any" class="form-control" id="pesco_total_kwhp" name="pesco_total_kwhp">
    </div>

    <div class="mb-3">
  <label for="pesco_images" class="form-label">Upload Image(s)</label>
  <input type="file" class="form-control" id="pesco_images" name="pesco_images[]" accept="image/*" multiple>
  <div id="pesco_preview" class="mt-2 d-flex flex-wrap gap-2"></div>
</div>

    <hr/>

    <p><b> Cisnr Reading </b></p>

    <div class="mb-1 d-flex align-items-center">
        <label for="kwho1" class="me-3 mb-0" style="width: 220px;"> T.kWh Offpeak</label>
        <input type="number" step="any" class="form-control" id="total_kwho" name="total_kwho">
    </div>

    <div class="mb-1 d-flex align-items-center">
        <label for="kwho2" class="me-3 mb-0" style="width: 220px;">T.kWh Peak</label>
        <input type="number" step="any" class="form-control" id="total_kwhp" name="total_kwhp">
    </div>

    <div class="mb-3">
  <label for="cisnr_images" class="form-label">Upload Image(s)</label>
  <input type="file" class="form-control" id="cisnr_images" name="cisnr_images[]" accept="image/*" multiple>
  <div id="cisnr_preview" class="mt-2 d-flex flex-wrap gap-2"></div>
</div>


    
    <!-- </div> -->

    <button type="submit" class="btn btn-primary mt-3">Add Readings</button>
</form>

</div>




      </div>

      <!-- Right Column: Record Table -->
      
    </div>
  </div>
  <script src="https://apms.cisnr.com/assets/js/jquery.min.js"></script>
  
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
  <script>
	$(document).ready(function(){
		flatpickr("#readingDate", {
      dateFormat: "d-m-Y"  // This sets the format to Day-Month-Year
    });
	
	 $('#GID').select2({
  placeholder: 'Select Global Device ID'
});


function previewImages(input, previewContainerId) {
  const previewContainer = document.getElementById(previewContainerId);
  previewContainer.innerHTML = '';
  if (input.files) {
    Array.from(input.files).forEach(file => {
      const reader = new FileReader();
      reader.onload = function(e) {
        const img = document.createElement("img");
        img.src = e.target.result;
        img.className = "img-thumbnail";
        img.style.height = "100px";
        previewContainer.appendChild(img);
      };
      reader.readAsDataURL(file);
    });
  }
}

document.getElementById('pesco_images').addEventListener('change', function() {
  previewImages(this, 'pesco_preview');
});

document.getElementById('cisnr_images').addEventListener('change', function() {
  previewImages(this, 'cisnr_preview');
});
    
});
  </script>
</body>
</html>
