<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You for Your Interaction</title>
    <style>
        /* Add your custom styles here */
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            margin-top: 20px;
        }

        h1 {
            color: #333;
            text-align: center;
        }

        p {
            color: #555;
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        ul li {
            color: #555;
        }

        .logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .thank-you-message {
            text-align: center;
            margin-top: 20px;
        }

        .signature {
            text-align: left;
            margin-top: 40px;
            color: #777;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="https://upticker-dashboard.vercel.app/static/media/upticker-icon.26d1e1cf94d5debd370b.png" alt="Company Logo" width="150">
        </div>

     
        
        <p>Dear {{ $mailData['name'] }},</p>

        <div>
            <p>Thank you for registering with UpTicker! We're excited to have you on board. Here's a quick overview of the tasks you've selected:</p>

            <ul>
                @foreach($mailData['tasks'] as $taks)
                  <li>{{ $taks }}</li>
                @endforeach
            </ul>
        </div>

        <div>
            <p><strong>Your Aim:</strong></p>
            <p>Press the ‘Complete’ button for each task and strive to reach 100% productivity every day. 🌟</p>
            <p>To help you get started, we've created a video demonstrating how the app works. You can watch it below </p>
             <a href="https://youtube.com/shorts/TwtcdeOdyk4?si=y1gtYK2DIrsxRckW" target="_blank">Watch Here</a>
            <p>We’re in Beta Mode:</p>
            <p>As we continue to develop UpTicker, your feedback is invaluable. Please feel free to reply to this email or use the ‘Feedback’ button in the app’s menu to share your thoughts, suggestions, or any quirks you encounter.</p>
            <p>Thank you for joining us on this journey toward peak performance!</p>
        </div>

        <div class="signature">
            <p>Best regards,</p>
            <p>
                <span>Shaz </span><br> 
                <span>CEO/Founder</span><br>
                <span>UpTicker</span>
            </p>
        </div>
    </div>
</body>
</html>
