@extends('layouts.app')

@section('center')
<link rel="stylesheet" href="{{asset('assets')}}/vendor/morris/morris.css" />
<style>
.morris-hover {
    background-color: #ffffff !important; /* White background */
    border: 1px solid #ddd; /* Optional: Add border to make it visible */
    color: #000000 !important;
}
.morris-hover .morris-hover-point {
    color: #000000 !important; /* Optional: Change the text color */
}
</style>

<div class="row gutters">
    <div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
        <input type="text" class="form-control" readonly value="{{$data->global_device_id}}">
        <br/>
    </div>
    <div class="col-xl-3 col-lg col-md-3 col-sm-3 col-12 ">
        <br/>
    </div>
</div>

<div class="row gutters">
		
			<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
				<div class="card">
					<div class="card-header">
						<div class="card-title">Current</div>
					</div>
					<div class="card-body">
						<div id="dayData" class="chart-height"></div>
					</div>
				</div>
			</div>

			<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
				<div class="card">
					<div class="card-header">
						<div class="card-title">Voltage</div>
					</div>
					<div class="card-body">
						<div id="dayData2" class="chart-height"></div>
					</div>
				</div>
			</div>
		
	</div>
    <div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">KVA</div>
            </div>
            <div class="card-body">
                <div id="dayDataKVA" class="chart-height"></div>
            </div>
        </div>
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">KWH</div>
            </div>
            <div class="card-body">
                <div id="dayDataKWH" class="chart-height"></div>
            </div>
        </div>
    </div>

</div>



@push('scripts')
<script src="{{asset('assets')}}/vendor/morris/raphael-min.js"></script>
<script src="{{asset('assets')}}/vendor/morris/morris.min.js"></script>

<script>
    $(document).ready(function() {
       let currentData = [];
        let voltageData = [];
        let graph_data= @json($graph_data);

        $.each(graph_data, function(index, item) {
       
            const newPoint1 = { 
                period: item.dtime, 
                phase_a: parseFloat(item.i1), 
                phase_b: parseFloat(item.i2), 
                phase_c: parseFloat(item.i3) 
            };

            currentData.push(newPoint1);

            const newPoint2 = { 
                period: item.dtime, 
                voltage_phase_a: item.v1, 
                voltage_phase_b: item.v2, 
                voltage_phase_c: item.v3 
            };

            voltageData.push(newPoint2); 

    });
       

        

      

        // Function to redraw the current graph
        function redrawCurrentGraph() {
            $('#dayData').empty(); // Clear the previous graph
            Morris.Line({
                element: 'dayData',
                data: currentData,
                xkey: 'period',
                ykeys: ['phase_a', 'phase_b', 'phase_c'],
                labels: ['Phase A', 'Phase B', 'Phase C'],
                resize: true,
                hideHover: "auto",
                gridLineColor: "#f5f1f100",
                pointFillColors: ['#ffffff'],
                pointStrokeColors: ['#ff5661'],
                lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
            });
        }

        // Function to redraw the voltage graph
        function redrawVoltageGraph() {
            $('#dayData2').empty(); // Clear the previous graph
            Morris.Line({
                element: 'dayData2',
                data: voltageData,
                xkey: 'period',
                ykeys: ['voltage_phase_a', 'voltage_phase_b', 'voltage_phase_c'],
                labels: ['Voltage A', 'Voltage B', 'Voltage C'],
                resize: true,
                hideHover: "auto",
                gridLineColor: "#f5f1f100",
                pointFillColors: ['#ffffff'],
                pointStrokeColors: ['#ff5661'],
                lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
            });
        }
        redrawCurrentGraph();
        redrawVoltageGraph();
 


    //

    let kvaData = [];
let kwhData = [];

$.each(graph_data, function(index, item) {
    let v1 = parseFloat(item.v1) || 0;
    let v2 = parseFloat(item.v2) || 0;
    let v3 = parseFloat(item.v3) || 0;

    let i1 = parseFloat(item.i1) || 0;
    let i2 = parseFloat(item.i2) || 0;
    let i3 = parseFloat(item.i3) || 0;

    let pf1 = parseFloat(item.pf1) || 0;
    let pf2 = parseFloat(item.pf2) || 0;
    let pf3 = parseFloat(item.pf3) || 0;

    // ✅ kVA = (V × I) / 1000
    kvaData.push({
        period: item.dtime,
        kva1: (v1 * i1) / 1000,
        kva2: (v2 * i2) / 1000,
        kva3: (v3 * i3) / 1000
    });

    // ✅ kWH = kVA × PF
    kwhData.push({
        period: item.dtime,
        kwh1: ((v1 * i1) / 1000) * pf1,
        kwh2: ((v2 * i2) / 1000) * pf2,
        kwh3: ((v3 * i3) / 1000) * pf3
    });
});

function redrawKvaGraph() {
    $('#dayDataKVA').empty();
    Morris.Line({
        element: 'dayDataKVA',
        data: kvaData,
        xkey: 'period',
        ykeys: ['kva1', 'kva2', 'kva3'],
        labels: ['Line 1', 'Line 2', 'Line 3'],
        resize: true,
        hideHover: "auto",
        gridLineColor: "#f5f1f100",
        pointFillColors: ['#ffffff'],
        pointStrokeColors: ['#ff5661'],
        lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
    });
}

function redrawKwhGraph() {
    $('#dayDataKWH').empty();
    Morris.Line({
        element: 'dayDataKWH',
        data: kwhData,
        xkey: 'period',
        ykeys: ['kwh1', 'kwh2', 'kwh3'],
        labels: ['Line 1', 'Line 2', 'Line 3'],
        resize: true,
        hideHover: "auto",
        gridLineColor: "#f5f1f100",
        pointFillColors: ['#ffffff'],
        pointStrokeColors: ['#ff5661'],
        lineColors: ['#0066ff', '#e83e8c', '#2b2f82'],
    });
}

redrawCurrentGraph();
redrawVoltageGraph();
redrawKvaGraph();
redrawKwhGraph();

   });
	
</script>

@endpush

@endsection
