<?php

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

if (!function_exists('switchTenantDatabase')) {
    /**
     * Switch the Laravel database connection dynamically to tenant DB.
     *
     * @param string $companyId
     * @throws Exception
     */
    function switchTenantDatabase(string $companyId)
    {
        $companies = config('tenants.companies');

        if (!isset($companies[$companyId])) {
            throw new Exception("Tenant [$companyId] config not found.");
        }

        $tenantConfig = $companies[$companyId];

        Config::set('database.connections.tenant', $tenantConfig);

        DB::setDefaultConnection('tenant');
    }
}

function result($status = 1, $message = '', $data = [], $statusCode = 200, $transactionid = '123456789')
{
    $response = [
        'status' => $status,
        'transactionid' => $transactionid,
        'message' => $message,
        'data' => $data,
    ];


    return response()->json($response, $statusCode);
}

function pr($data)
{
    echo "<pre>";
    print_r($data);
    echo "</pre>";
    die;

}

function numberf($number)
{
    $num2 = 0;
    if ($number) {
        if (is_numeric($number)) {
            $num2 = $number;
        } else {
            $num2 = (float)$number;
        }
        $formattedNumber = (gettype($num2) == 'integer') ? $num2 : round($num2, 2);
        return $formattedNumber;
    } else
        return $num2;
}

function socket_data($data)
{
    $message = [
        'gid' => $data['gid'],
        'at' => $data['at'],   //'order', 'data','alert'
        'a' => isset($data['a']) ? $data['a'] : '',
        'd' => isset($data['d']) ? $data['d'] : ''
    ];


    return $message;
}

function appDate($date)
{

    return date('d-m-Y H:i:s', strtotime($date));
}

function dbDate($date)
{

    return date('Y-m-d H:i:s', strtotime($date));
}

function getRandomPf()
{
    $random = mt_rand(60, 80) / 100;
    return number_format($random, 2);
}


