<?php

// require __DIR__ . '/../../vendor/autoload.php';

// use Ratchet\WebSocket\WsServer;
// use Ratchet\Http\HttpServer;
// use Ratchet\WebSocket\WebSocketServer;
// use Ratchet\Server\IoServer;
// use App\WebSocket\Chat;

// $chat = new Chat();

// $server = IoServer::factory(
//     new HttpServer(
//         new WsServer($chat)
//     ),
//     8080
// );

// $host = gethostname(); // Get the hostname of the server
// $ip = gethostbyname($host); // Resolve the IP address of the hostname
// echo "WebSocket server running at ws://{$ip}:8080\n";

// $server->run();

// Include the Composer autoload file to load dependencies
require __DIR__.'/../../vendor/autoload.php'; // Adjust the path based on your directory structure

use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use App\WebSocket\Chat;

// Bootstrap the Laravel application
$app = require_once __DIR__.'/../../bootstrap/app.php'; // Adjust the path to the Laravel app bootstrap
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

// Define the port where your WebSocket server will listen
//$port = env('WEBSOCKET_PORT', 8080);  // You can change this to any other available port

// Create the WebSocket server
$server = IoServer::factory(
    new HttpServer(
        new WsServer(
            new Chat()
        )
    ),
    9000, // Use the $port variable here. 8080 is just for online server proxy
    '0.0.0.0' // for online server setup proxy
);

// Output message indicating the server is running and the port
echo "WebSocket Server is running on ws://127.0.0.1:9000\n";

// Run the WebSocket server
$server->run();
