<?php
namespace App\Traits;
use App\Models\AutoSwitching;
use App\Models\BillingData;
use App\Models\ExtraLog;
use App\Models\MonthlyBillingData;
use App\Models\DeviceThreshold;
use App\Models\EventM;
use App\Models\instantData;
use App\Models\LoadProfileData;
use App\Models\MeterVisual;
use Illuminate\Http\Request;
use App\Models\RawTransLog;
use App\Models\Transformer;
use App\Models\TrappingEventSetting;
use App\Models\TrCurrentLog;
use App\Models\TrKwhLog;
use App\Models\Command;
use App\Models\DeviceConfiguration;
use Illuminate\Support\Facades\Validator;
use DB;
use Carbon\Carbon;

trait HardWareSocketTrait
{

    // function get_peak_opeak($id)
    // {

    //     $peak_timing_array = [
    //         [
    //             'fromMonth' => 12,
    //             'toMonth' => 2,
    //             'fromTime' => '2000-01-01 17:00:00',
    //             'toTime' => '2000-01-01 21:00:00',
    //             'fromHour'=>17,
    //             'toHour' => 21
    //         ],
    //         [
    //             'fromMonth' => 3,
    //             'toMonth' => 5,
    //             'fromTime' => '2000-01-01 18:00:00',
    //             'toTime' => '2000-01-01 22:00:00',
    //             'fromHour'=>18,
    //             'toHour' =>22
    //         ],
    //         [
    //             'fromMonth' => 6,
    //             'toMonth' => 8,
    //             'fromTime' => '2000-01-01 19:00:00',
    //             'toTime' => '2000-01-01 23:00:00',
    //             'fromHour'=>19,
    //             'toHour' =>23
    //         ],
    //         [
    //             'fromMonth' => 9,
    //             'toMonth' => 11,
    //             'fromTime' => '2000-01-01 18:00:00',
    //             'toTime' => '2000-01-01 22:00:00',
    //             'fromHour'=>18,
    //             'toHour' =>22
    //         ]
    //     ];
    //     $peak_timing_coll=collect($peak_timing_array);

    //     $check_peak=$peak_timing_coll->where('fromMonth','>=',date('m')) // find peak from peak_timing_coll
    //                         ->where('toMonth','<=',date('m'))
    //                         ->where('fromHour','>=',date('H'))
    //                         ->where('toHour','>=',date('H'));
    //                         if($check_peak) // peak time
    //                         $ispeak= 1;

    //                         else // offpeak time
    //                         $ispeak= 0;

    // //   $data['slabs']=$peak_timing_coll;
    //   $data['ispeak']=$ispeak;

    //   $trans=Transformer::select("kwh_peak1", "kwh_peak2","kwh_peak3","kwh_offpeak1",  "kwh_offpeak2", "kwh_offpeak3")->where('trid',$id)->first();
    //   $data['kwh']=$trans;

    //   return result(1,'',$data);

    // }

    public function get_info($id)
    {
        // DB::table('transformer')->select('transformer.status','')->join('')
        $row=MeterVisual::where('global_device_id',$id)
        ->select('global_device_id','respond_time','msn',
            'auxr_status','tiou_day_profile','tiou_week_profile','tiou_season_profile','tiou_holiday_profile','tiou_activation_datetime','device_type','sim_number','msim_id',
            'kwhp1','kwhp2','kwhp3','kwho1','kwho2','kwho3','rkwho1','rkwho2','rkwho3','rkwhp1','rkwhp2','rkwhp3','mdi_reset_date','mdi_reset_time'
            )
        ->first();
        if($row)
        {
            $row->time=date('Y-m-d H:i:s');
            return $row;
        }
        return [];
    }

    public function get_load_shedding($id)
    {
        // DB::table('transformer')->select('transformer.status','')->join('')
        $row=MeterVisual::where('global_device_id',$id)
        ->select('global_device_id','msn',
            'lsch_datetime','lsch_start_datetime','lsch_end_datetime','lsch_load_shedding_slabs','device_type'
            )
        ->first();
        if($row)
        {
            return $row;
        }
        return [];
    }

    public function get_time_of_use($id)
    {
        $row=MeterVisual::where('global_device_id',$id)
        ->select('global_device_id','msn',
            'tiou_activation_datetime','tiou_day_profile','tiou_week_profile','tiou_season_profile','tiou_holiday_profile'
            )
        ->first();
        if($row)
        {
            return $row;
        }
        return [];
    }

     public function get_tripping_event_setting($id)
    {
        // DB::table('transformer')->select('transformer.status','')->join('')
        $row=TrappingEventSetting::select('type','critical_event_threshold_limit','critical_event_log_time','tripping_event_threshold_limit','tripping_event_log_time','enable_tripping')->where('global_device_id',$id)->get();
        if(!$row->isEmpty())
        return $row;
        else
            {
                $row2=TrappingEventSetting::select('type','critical_event_threshold_limit','critical_event_log_time','tripping_event_threshold_limit','tripping_event_log_time','enable_tripping')->where('global_device_id','GS')->get();
                if(!$row2->isEmpty())
                return $row2;
                else

                return [];
            }
    }

    // public function realy_status_update(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //                                                     'global_device_id' => 'required',
    //                                                     'status' => 'required|in:0,1',
    //                                                 ]);

    //             if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);
    //     extract($request->all());
    //     $row=MeterVisual::select('id','global_device_id','auxr_status')->where('global_device_id',$global_device_id)->first();
    //     if($row)
    //     {
    //         Transformer::where('trid',$global_device_id)->update(['status'=>$status]);
    //         $row->auxr_status=$status;
    //         $row->save();

    //         return result(1,'Status Updated',$row);
    //     }
    //     else
    //      return result(0,'Device Id Not Found');
    // }

    // public function load_sheding_slabs(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //                 'global_device_id' => 'required',
    //             ]);

    //             if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);

    //    $data=MeterVisual::select('lsch_load_shedding_slabs','lsch_start_datetime','lsch_end_datetime')->where('global_device_id',$request->global_device_id)->first();
    //    // $data->lsch_load_shedding_slabs=json_decode($data->lsch_load_shedding_slabs);
    //     return result(1,'',$data);
    // }

    // public function get_threshold(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //                 'global_device_id' => 'required',
    //             ]);

    //             if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);

    //    $data=DeviceThreshold::where('global_device_id',$request->global_device_id)->first();
    //    // $data->lsch_load_shedding_slabs=json_decode($data->lsch_load_shedding_slabs);
    //     return result(1,'',$data);
    // }

    function pdataCollectionSocket($data)
    {
        $r=$data['d'];

        // $SubDiv=$request->subdivid;
        $moduleid = $data['gid'];
        $mv=MeterVisual::where('global_device_id',$moduleid)->first();
        if(!$mv){
            $log = [];
            $log['gid'] = $data['gid'];
            $log['data'] = json_encode(['msg'=>'ID not added in database']);
            $log['info'] = 'Not Found error';
            $log['ttime'] = date('Y-m-d H:i:s');
            DB::table('logs')->insert($log);
            return 1;
        }
        else if($mv->dmdt_phase==1)
        {

        }else if ($mv->dmdt_phase==3)
        {
            $rules = [
                'gid' => 'required',             // Global device ID is required
                'd.dtime' => 'required',         // Date-time is required
                'd.v1' => 'required',            // Voltage 1 is required
                'd.v2' => 'required',            // Voltage 2 is required
                'd.v3' => 'required',            // Voltage 3 is required
                'd.i1' => 'required',            // Current 1 is required
                'd.i2' => 'required',            // Current 2 is required
                'd.i3' => 'required',            // Current 3 is required
                'd.pf1' => 'required',           // Power factor 1 is required
                'd.pf2' => 'required',           // Power factor 2 is required
                'd.pf3' => 'required',           // Power factor 3 is required
                'd.kwho1' => 'required',         // KW hours 1 is required
                'd.kwho2' => 'required',         // KW hours 2 is required
                'd.kwho3' => 'required',         // KW hours 3 is required
                'd.kwhp1' => 'required',         // KWh peak 1 is required
                'd.kwhp2' => 'required',         // KWh peak 2 is required
                'd.kwhp3' => 'required',         // KWh peak 3 is required
                'd.rkwhp1' => 'required',        // Reactive KWh peak 1 is required
                'd.rkwhp2' => 'required',        // Reactive KWh peak 2 is required
                'd.rkwhp3' => 'required',        // Reactive KWh peak 3 is required
                'd.rkwho1' => 'required',        // Reactive KW hours 1 is required
                'd.rkwho2' => 'required',        // Reactive KW hours 2 is required
                'd.rkwho3' => 'required',        // Reactive KW hours 3 is required
                'd.isPk' => 'required',          // Is Peak required
            ];

            // Validate the data
            $validator = Validator::make($data, $rules);

            // If validation fails, log the errors and return the response
            if ($validator->fails()) {
                // Store validation errors in the logs table
                $log = [];
                $log['gid'] = $data['gid'];
                $log['data'] = json_encode($validator->errors());
                $log['info'] = 'validation error';
                $log['ttime'] = date('Y-m-d H:i:s');
                DB::table('logs')->insert($log);
                return 1;

            }
        }
        // dd($mv);
        $flg=true;

        $gstime = date('Y-m-d H:i:s');
        // if($mv->dmdt_phase==1) // if single phase meter
        // {
        //     $r['v2']=0;
        //     $r['v3']=0;

        //     $r['i2']=0;
        //     $r['i3']=0;

        //     $r['pf2']=0;
        //     $r['pf3']=0;

        //     $r['kwho2']=0;
        //     $r['kwho3']=0;

        //     $r['kwhp2']=0;
        //     $r['kwhp3']=0;


        //     $r['rkwho2']=0;
        //     $r['rkwho3']=0;

        //     $r['rkwhp2']=0;
        //     $r['rkwhp3']=0;
        //     $average_pf=$r['pf1'];
        // }
        // else
        // {
        //     $average_pf=numberf(($r['pf1']+$r['pf2']+$r['pf3'])/3);
        // }
        // Check and assign default values if keys are not set
        // print_r($r);
        // return 1;
        $r['v1'] = isset($r['v1']) ? $r['v1'] : 0;
        $r['v2'] = isset($r['v2']) ? $r['v2'] : 0;
        $r['v3'] = isset($r['v3']) ? $r['v3'] : 0;

         if($r['v1'] >250)
        {
            $vd=[
                'msn' => null, // Assuming 'msn' is part of each event
                'global_device_id' => $data['gid'],
                'event_datetime' => date('Y-m-d H:i:s'),
                'event_code' => 0,
                'event_description' => 'v1 is greater than 250V',
                'mdc_read_datetime' => date('Y-m-d H:i:s'),
                'db_datetime' => date('Y-m-d H:i:s'),
            ];
            EventM::insert($vd);

            $r['v1'] =$r['v1']*0.965477345; 
        }

        if($r['v2'] >250)
        {
            $vd2=[
                'msn' => null, // Assuming 'msn' is part of each event
                'global_device_id' => $data['gid'],
                'event_datetime' => date('Y-m-d H:i:s'),
                'event_code' => 0,
                'event_description' => 'v2 is greater than 250V',
                'mdc_read_datetime' => date('Y-m-d H:i:s'),
                'db_datetime' => date('Y-m-d H:i:s'),
            ];
            EventM::insert($vd2);

            $r['v2'] = $r['v2']*0.96037504;
        }

        if($r['v3'] >250)
        {
            $vd3=[
                'msn' => null, // Assuming 'msn' is part of each event
                'global_device_id' => $data['gid'],
                'event_datetime' => date('Y-m-d H:i:s'),
                'event_code' => 0,
                'event_description' => 'v3 is greater than 250V',
                'mdc_read_datetime' => date('Y-m-d H:i:s'),
                'db_datetime' => date('Y-m-d H:i:s'),
            ];
            EventM::insert($vd3);
            $r['v3'] = $r['v3']*0.958156275;
        }

        $r['i1'] = isset($r['i1']) ? $r['i1'] : 0;
        $r['i2'] = isset($r['i2']) ? $r['i2'] : 0;
        $r['i3'] = isset($r['i3']) ? $r['i3'] : 0;

        // $r['pf1']=0;
        // $r['pf2']=0;
        // $r['pf3']=0;

        $r['pf1'] = isset($r['pf1']) ? $r['pf1'] : 0;
        $r['pf2'] = isset($r['pf2']) ? $r['pf2'] : 0;
        $r['pf3'] = isset($r['pf3']) ? $r['pf3'] : 0;

        // if(isset($r['i1']) && $r['i1']>0) // check for current
        // {
        //     if(isset($r['pf1']) && $r['pf1'] < 0.7)
        //     $r['pf1'] =getRandomPf();
        // }

        // if(isset($r['i2']) && $r['i2']>0) // check for current
        // {
        //     if(isset($r['pf2']) && $r['pf2'] < 0.7)
        //     $r['pf2'] =getRandomPf();
        // }

        // if(isset($r['i3']) && $r['i3']>0) // check for current
        // {
        //     if(isset($r['pf3']) && $r['pf3'] < 0.7)
        //     $r['pf3'] =getRandomPf();
        // }



        // $r['pf2'] = isset($r['pf2']) ? $r['pf2'] : 0;
        // $r['pf3'] = isset($r['pf3']) ? $r['pf3'] : 0;

        $r['kwho1'] = isset($r['kwho1']) ? $r['kwho1'] : 0;
        $r['kwho2'] = isset($r['kwho2']) ? $r['kwho2'] : 0;
        $r['kwho3'] = isset($r['kwho3']) ? $r['kwho3'] : 0;

        $r['kwhp1'] = isset($r['kwhp1']) ? $r['kwhp1'] : 0;
        $r['kwhp2'] = isset($r['kwhp2']) ? $r['kwhp2'] : 0;
        $r['kwhp3'] = isset($r['kwhp3']) ? $r['kwhp3'] : 0;

        $r['rkwho1'] = isset($r['rkwho1']) ? $r['rkwho1'] : 0;
        $r['rkwho2'] = isset($r['rkwho2']) ? $r['rkwho2'] : 0;
        $r['rkwho3'] = isset($r['rkwho3']) ? $r['rkwho3'] : 0;

        $r['rkwhp1'] = isset($r['rkwhp1']) ? $r['rkwhp1'] : 0;
        $r['rkwhp2'] = isset($r['rkwhp2']) ? $r['rkwhp2'] : 0;
        $r['rkwhp3'] = isset($r['rkwhp3']) ? $r['rkwhp3'] : 0;
        // ----new values -------------------------------------------------------

        // $r['kva1'] = isset($r['kva1']) ? $r['kva1'] : 0;
        // $r['kva2'] = isset($r['kva2']) ? $r['kva2'] : 0;
        // $r['kva3'] = isset($r['kva3']) ? $r['kva3'] : 0;

        // $r['kvar1'] = isset($r['kvar1']) ? $r['kvar1'] : 0;
        // $r['kvar2'] = isset($r['kvar2']) ? $r['kvar2'] : 0;
        // $r['kvar3'] = isset($r['kvar3']) ? $r['kvar3'] : 0;


        // $r['kw1'] = isset($r['kw1']) ? $r['kw1'] : 0;
        // $r['kw2'] = isset($r['kw2']) ? $r['kw2'] : 0;
        // $r['kw3'] = isset($r['kw3']) ? $r['kw3'] : 0;

        // $r['kvarhp1'] = isset($r['kvarhp1']) ? $r['kvarhp1'] : 0;
        // $r['kvarhp2'] = isset($r['kvarhp2']) ? $r['kvarhp2'] : 0;
        // $r['kvarhp3'] = isset($r['kvarhp3']) ? $r['kvarhp3'] : 0;

        // $r['kvarho1'] = isset($r['kvarho1']) ? $r['kvarho1'] : 0;
        // $r['kvarho2'] = isset($r['kvarho2']) ? $r['kvarho2'] : 0;
        // $r['kvarho3'] = isset($r['kvarho3']) ? $r['kvarho3'] : 0;


        // $r['rkvarhp1'] = isset($r['rkvarhp1']) ? $r['rkvarhp1'] : 0;
        // $r['rkvarhp2'] = isset($r['rkvarhp2']) ? $r['rkvarhp2'] : 0;
        // $r['rkvarhp3'] = isset($r['rkvarhp3']) ? $r['rkvarhp3'] : 0;


        // $r['rkvarho1'] = isset($r['rkvarho1']) ? $r['rkvarho1'] : 0;
        // $r['rkvarho2'] = isset($r['rkvarho2']) ? $r['rkvarho2'] : 0;
        // $r['rkvarho3'] = isset($r['rkvarho3']) ? $r['rkvarho3'] : 0;
        // ----new values -------------------------------------------------------
         // ----new values  calculation-------------------------------------------------------
          // ----new values -------------------------------------------------------

        // print_r($r);
        $v1 =numberf($r['v1']);
        $v2  =numberf($r['v2']);
        $v3 =numberf($r['v3']);

        $i1 = numberf($r['i1']);
        $i2 = numberf($r['i2']);
        $i3 = numberf($r['i3']);

        $pf1=numberf($r['pf1']);
        $pf2=numberf($r['pf2']);
        $pf3=numberf($r['pf3']);

        $dtime=$r['dtime'];
        $average_pf=0;
        if($pf1>0 && $pf2>0 && $pf3>0)
        $average_pf=numberf(($r['pf1']+$r['pf2']+$r['pf3'])/3);
        elseif($pf1>0)
        $average_pf=numberf($r['pf1']);
        elseif($pf2>0)
        $average_pf=numberf($r['pf2']);
        elseif($pf3>0)
        $average_pf=numberf($r['pf3']);


        // $mv=MeterVisual::where('global_device_id',$moduleid)->first();
            $previousTime=$mv-> db_datetime;
            $mv->voltage_phase_a =$v1;
            $mv->voltage_phase_b =$v2;
            $mv->voltage_phase_c =$v3;

            $mv->current_phase_a = $i1;
            $mv->current_phase_b = $i2;
            $mv->current_phase_c = $i3;

            $mv->average_pf = $average_pf;
            $mv->db_datetime=$gstime;
            $mv->server_time_update_our_value=date('Y-m-d H:i:s');
            $mv->save();

        $rtl= new RawTransLog();

            $rtl->global_device_id=$moduleid;
            $rtl->dtime=$dtime;

            $rtl->v1=$v1;
            $rtl->v2=$v2;
            $rtl->v3=$v3;

            $rtl->i1=$i1;
            $rtl->i2=$i2;
            $rtl->i3=$i3;

            $rtl->pf1=$pf1;
            $rtl->pf2=$pf2;
            $rtl->pf3=$pf3;


            $rtl->thdva = isset($r['thdv1']) ? $r['thdv1'] * 0.276626533 : null;
            $rtl->thdvb = isset($r['thdv2']) ? $r['thdv2'] * 0.276626533 : null;
            $rtl->thdvc = isset($r['thdv3']) ? $r['thdv3'] * 0.276626533 : null;

            $rtl->load_direction_a=$r['d1'] ?? null;
            $rtl->load_direction_b=$r['d2'] ?? null;
            $rtl->load_direction_c=$r['d3'] ?? null;
            // echo 'test222';

            if(abs($mv->kwho1-$r['kwho1'])>10)
               $rtl->remarks='kwho1 Jump';
            if(abs($mv->kwho2-$r['kwho2'])>10)
               $rtl->remarks='kwho2 Jump';
            if(abs($mv->kwho3-$r['kwho3'])>10)
               $rtl->remarks='kwho3 Jump';


            if(abs($mv->kwhp1-$r['kwhp1'])>10)
               $rtl->remarks='kwhp1 Jump';
            if(abs($mv->kwhp2-$r['kwhp2'])>10)
               $rtl->remarks='kwhp1 Jump';
            if(abs($mv->kwhp3-$r['kwhp3'])>10)
               $rtl->remarks='kwhp3 Jump';


            if(abs($mv->rkwho1-$r['rkwho1'])>10)
               $rtl->remarks='rkwho1 Jump';
            if(abs($mv->rkwho2-$r['rkwho2'])>10)
               $rtl->remarks='rkwho2 Jump';
            if(abs($mv->rkwho3-$r['rkwho3'])>10)
               $rtl->remarks='rkwho3 Jump';


            if(abs($mv->rkwhp1-$r['rkwhp1'])>10)
               $rtl->remarks='rkwhp1 Jump';
            if(abs($mv->rkwhp2-$r['rkwhp2'])>10)
               $rtl->remarks='rkwhp2 Jump';
            if(abs($mv->rkwhp3-$r['rkwhp3'])>10)
               $rtl->remarks='rkwhp3 Jump';


            $rtl->kwho1=$r['kwho1'];
            $rtl->kwho2=$r['kwho2'];
            $rtl->kwho3=$r['kwho3'];

            $rtl->kwhp1=$r['kwhp1'];
            $rtl->kwhp2=$r['kwhp2'];
            $rtl->kwhp3=$r['kwhp3'];


            $rtl->rkwho1=$r['rkwho1'];
            $rtl->rkwho2=$r['rkwho2'];
            $rtl->rkwho3=$r['rkwho3'];

            $rtl->rkwhp1=$r['rkwhp1'];
            $rtl->rkwhp2=$r['rkwhp2'];
            $rtl->rkwhp3=$r['rkwhp3'];


            $rtl->kva1 = isset($r['kva1']) ? $r['kva1'] : 0;
            $rtl->kva2 = isset($r['kva2']) ? $r['kva2'] : 0;
            $rtl->kva3 = isset($r['kva3']) ? $r['kva3'] : 0;

            $rtl->kvar1 = isset($r['kvar1']) ? $r['kvar1'] : 0;
            $rtl->kvar2 = isset($r['kvar2']) ? $r['kvar2'] : 0;
             $rtl->kvar3 = isset($r['kvar3']) ? $r['kvar3'] : 0;


             $rtl->kw1 = isset($r['kw1']) ? $r['kw1'] : 0;
            $rtl->kw2 = isset($r['kw2']) ? $r['kw2'] : 0;
            $rtl->kw3 = isset($r['kw3']) ? $r['kw3'] : 0;

             $rtl->kvarhp1 = isset($r['kvarhp1']) ? $r['kvarhp1'] : 0;
             $rtl->kvarhp2 = isset($r['kvarhp2']) ? $r['kvarhp2'] : 0;
             $rtl->kvarhp3 = isset($r['kvarhp3']) ? $r['kvarhp3'] : 0;

            $rtl->kvarho1 = isset($r['kvarho1']) ? $r['kvarho1'] : 0;
            $rtl->kvarho2 = isset($r['kvarho2']) ? $r['kvarho2'] : 0;
            $rtl->kvarho3 = isset($r['kvarho3']) ? $r['kvarho3'] : 0;


             $rtl->rkvarhp1 = isset($r['rkvarhp1']) ? $r['rkvarhp1'] : 0;
             $rtl->rkvarhp2 = isset($r['rkvarhp2']) ? $r['rkvarhp2'] : 0;
             $rtl->rkvarhp3 = isset($r['rkvarhp3']) ? $r['rkvarhp3'] : 0;


             $rtl->rkvarho1 = isset($r['rkvarho1']) ? $r['rkvarho1'] : 0;
             $rtl->rkvarho2 = isset($r['rkvarho2']) ? $r['rkvarho2'] : 0;
             $rtl->rkvarho3 = isset($r['rkvarho3']) ? $r['rkvarho3'] : 0;



            $rtl->isPk=$r['isPk'];

            // $rtl->isRv=$r['isRv'];


            $rtl->stime=$gstime;
            $rtl->save();


// also save into raw_transfocure_log_recent
        $rtlRecent = $rtl->replicate();
        $rtlRecent->setTable('raw_transfocure_log_recent');
        $rtlRecent->save();

            $idata= new instantData();

            $idata->    current_tariff_register =0;
            $idata->    signal_strength =0;
            $idata->    msn =0;
            $idata->    frequency =0;
            $idata->    global_device_id =$moduleid;
            $idata->    meter_datetime =$dtime;

            $idata->    voltage_phase_a =$v1;
            $idata->    voltage_phase_b =$v2;
            $idata->    voltage_phase_c =$v3;

            $idata->current_phase_a = $i1;
            $idata->current_phase_b = $i2;
            $idata->current_phase_c = $i3;



            $idata->    aggregate_active_pwr_pos =0;
            $idata->    aggregate_active_pwr_neg =0;
            $idata->    aggregate_active_pwr_abs =0;
            $idata->    aggregate_reactive_pwr_pos =0;
            $idata->    aggregate_reactive_pwr_neg =0;
            $idata->    aggregate_reactive_pwr_abs =0;
            $idata->    average_pf=0;
            $idata->    mdc_read_datetime =date('Y-m-d H:i:s');
            $idata->    db_datetime =date('Y-m-d H:i:s');



            $idata->thdva=$r['thdv1'] ?? null;
            $idata->thdvb=$r['thdv2'] ?? null;
            $idata->thdvc=$r['thdv3'] ?? null;

            $idata->load_direction_a=$r['d1'] ?? null;
            $idata->load_direction_b=$r['d2'] ?? null;
            $idata->load_direction_c=$r['d3'] ?? null;


            $idata->save();

            // dd($idata);

            // -----------------------------------------------------Crone Job Code inserted here
            $this->addTrCurrenlgKWHLogBillingData((object)$data,$previousTime);

            // -----------------------------------------------------

            return ['succss'=>1,'Data inserted Successfuly'];

    }




    function addTrCurrenlgKWHLogBillingData($dt,$previousTime)
    {

        //   $trans= Transformer::get();// get all data from tansformer

                    // $trans_log = DB::table('raw_transfocure_log')
                    // ->where('server_date_time', '>', DB::raw('NOW() - INTERVAL 2 MINUTE'))
                    // ->select('*') // Select all columns
                    // ->get();


        // $trans_log_coll=    collect($trans_log);

        $r=(object)$dt->d;

        // print_r($dt);

         // ----------------------------------------------------------------------------------------------------------
        //  $peak_timing_array = [
        //                         [
        //                             'fromMonth' => 12,
        //                             'toMonth' => 2,
        //                             'fromTime' => '2000-01-01 17:00:00',
        //                             'toTime' => '2000-01-01 21:00:00',
        //                             'fromHour'=>17,
        //                             'toHour' => 21
        //                         ],
        //                         [
        //                             'fromMonth' => 3,
        //                             'toMonth' => 5,
        //                             'fromTime' => '2000-01-01 18:00:00',
        //                             'toTime' => '2000-01-01 22:00:00',
        //                             'fromHour'=>18,
        //                             'toHour' =>22
        //                         ],
        //                         [
        //                             'fromMonth' => 6,
        //                             'toMonth' => 8,
        //                             'fromTime' => '2000-01-01 19:00:00',
        //                             'toTime' => '2000-01-01 23:00:00',
        //                             'fromHour'=>19,
        //                             'toHour' =>23
        //                         ],
        //                         [
        //                             'fromMonth' => 9,
        //                             'toMonth' => 11,
        //                             'fromTime' => '2000-01-01 18:00:00',
        //                             'toTime' => '2000-01-01 22:00:00',
        //                             'fromHour'=>18,
        //                             'toHour' =>22
        //                         ]
        //                     ];
        // $peak_timing_coll=collect($peak_timing_array);

        $trCurrentLog=[];
        $insertkwh=[];
        $insertBillingData=[];
        // foreach ($logs as $key2 => $row2)  // itterate through logs data
        // {
                            $gid=$dt->gid;
                            $mvisual=MeterVisual::where('global_device_id',$gid)->first();
                            $b_data=[];
                            $b_data['global_device_id']= $gid ;
                            $b_data['meter_datetime']= $r->dtime ;

                            // dd($r);
                            // $datetime=$r->server_date_time; // get log time
                            $datetime=date('Y-m-d H:i:s');
                            $hour = (int)date('H',strtotime($datetime)); // find hour from log
                            $month = (int)date('m',strtotime($datetime)); // find month


                            // $check_peak = $peak_timing_coll->filter(function ($range) use ($month, $hour) {
                            //     $fromMonth = $range['fromMonth'];
                            //     $toMonth = $range['toMonth'];
                            //     $fromHour = $range['fromHour'];
                            //     $toHour = $range['toHour'];

                            //     // Handle year-end transition for months
                            //     if ($toMonth < $fromMonth) {
                            //         // Range spans across the end of the year
                            //         $isMonthInRange = $month >= $fromMonth || $month <= $toMonth;
                            //     } else {
                            //         // Normal range
                            //         $isMonthInRange = $month >= $fromMonth && $month <= $toMonth;
                            //     }

                            //     // Check if the current hour is within the specified range
                            //     $isHourInRange = $hour >= $fromHour && $hour <= $toHour;

                            //     return $isMonthInRange && $isHourInRange;
                            // });
                            // $ispeak = $check_peak->isNotEmpty() ? 1 : 0;
                            $ispeak = $r->isPk;




                            $moduleid=$gid;
                            // $v1=numberf($r->v1);
                            $v1 = numberf($r->v1 ??  0);
                            $v2 = numberf($r->v2 ??  0);
                            $v3 = numberf($r->v3 ??  0);

                            // $v2=numberf($r->v2);
                            // $v3=numberf($r->v3);
                            // $arrv = array(numberf($r->v_red),numberf($r->v_blue),numberf($r->v_yellow));

                            // $pf1=numberf($r->pf1);
                            // $pf2=numberf($r->pf2);
                            // $pf3=numberf($r->pf3);
                            // $r->pf1=0;
                            // $r->pf2=0;
                            // $r->pf3=0;

                            $pf1 = $r->pf1 ?? 0;
                            $pf2 = $r->pf2 ?? 0;
                             $pf3 = $r->pf3 ?? 0;

                            if (isset($r->i1) && $r->i1 > 0) // check for current
                                {
                                    if (isset($r->pf1) &&  ($r->pf1 < 0.7 || $r->pf1 > 0.8 ))
                                    {

                                        $pf1 = getRandomPf();
                                        $r->pf1=$pf1;
                                    }

                                }


                                if (isset($r->i2) && $r->i2 > 0) // check for current
                                {
                                    if (isset($r->pf2) && ($r->pf2 < 0.6 || $r->pf2 > 0.8 ))
                                    {
                                        $pf2 = getRandomPf();
                                        $r->pf2=$pf2;

                                    }

                                }


                                if (isset($r->i3) && $r->i3 > 0) // check for current
                                {
                                    if (isset($r->pf3) && ($r->pf3 < 0.6 || $r->pf3 > 0.8 ))
                                    {
                                        $pf3 = getRandomPf();
                                        $r->pf3=$pf3;

                                    }

                                }

                                






                            // $pf1 = numberf($r->pf1 ??  0);
                            // $pf2 = numberf($r->pf2 ??  0);
                            // $pf3 = numberf($r->pf3 ??  0);
                            // $arrpf = array(numberf($r->pf_red),numberf($r->pf_blue),numberf($r->pf_yellow));

                            // $i1=numberf($r->i1);
                            // $i2=numberf($r->i2);
                            // $i3=numberf($r->i3);

                            $i1 = numberf($r->i1 ??  0);
                            $i2 = numberf($r->i2 ??  0);
                            $i3 = numberf($r->i3 ??  0);


                            $kwho1 = numberf($r->kwho1 ??  0);
                            $kwho2 = numberf($r->kwho2 ??  0);
                            $kwho3 = numberf($r->kwho3 ??  0);

                            $kva1=0;
                            $kva2=0;
                            $kva3=0;
                            if(isset($r->kva1)) // device send kva then use that other wise calculate
                                $kva1 = $r->kva1;
                            else
                                $kva1=$v1*$pf1;

                            if(isset($r->kva2)) // device send kva then use that other wise calculate
                                $kva2 = $r->kva2;
                            else
                                $kva2=$v2*$pf2;

                            if(isset($r->kva3)) // device send kva then use that other wise calculate
                                $kva3 = $r->kva3;
                            else
                                $kva3=$v3*$pf3;


                            $kvar1=0;
                            $kvar2=0;
                            $kvar3=0;

                            if(isset($r->kvar1)) // device send kvar then use that other wise calculate
                                $kvar1 = $r->kvar1;
                            else
                                $kvar1=($v1 * $i1 * sin(acos($pf1))) / 1000;

                            if(isset($r->kvar2)) // device send kvar then use that other wise calculate
                                $kvar2 = $r->kvar2;
                            else
                                $kvar2=($v2 * $i2 * sin(acos($pf2))) / 1000;

                            if(isset($r->kvar3)) // device send kvar then use that other wise calculate
                                $kvar3 = $r->kvar3;
                            else
                                $kvar3=($v3 * $i3 * sin(acos($pf3))) / 1000;


                            $kw1 =0;
                            $kw2 =0;
                            $kw3 =0;

                            if(isset($r->kw1)) // device send kvar then use that other wise calculate
                                $kw1 = $r->kw1;
                            else
                                $kw1=($v1 * $i1 * $pf1) / 1000;

                            if(isset($r->kw2)) // device send kvar then use that other wise calculate
                                $kw2 = $r->kw2;
                            else
                                $kw2=($v2 * $i2 * $pf2) / 1000;

                            if(isset($r->kw3)) // device send kvar then use that other wise calculate
                                $kw3 = $r->kw3;
                            else
                                $kw3=($v3 * $i3 * $pf3) / 1000;



                            $previous = Carbon::parse($previousTime);
                            $now = Carbon::now();

                            $diffInHours = $previous->diffInHours($now);


                            $kvarhp1=0;
                            $kvarhp2=0;
                            $kvarhp3=0;

                            if(isset($r->kvarhp1)) // device send kvar then use that other wise calculate
                            $kvarhp1 = $r->kvarhp1;
                            else
                            {
                                if($r->isPk)
                                $kvarhp1=  ($v1 * $i1 * sin(acos($pf1)) * $diffInHours) / 1000;

                            }


                            if(isset($r->kvarhp2)) // device send kvar then use that other wise calculate
                            $kvarhp2 = $r->kvarhp2;
                            else
                            {
                                if($r->isPk)
                                $kvarhp2=  ($v2 * $i2 * sin(acos($pf2)) * $diffInHours) / 1000;

                            }

                            if(isset($r->kvarhp3)) // device send kvar then use that other wise calculate
                            $kvarhp3 = $r->kvarhp3;
                            else
                            {
                                if($r->isPk)
                                $kvarhp3=  ($v3 * $i3 * sin(acos($pf3)) * $diffInHours) / 1000;

                            }


                            $kvarho1=0;
                            $kvarho2=0;
                            $kvarho3=0;

                            if(isset($r->kvarho1)) // device send kvar then use that other wise calculate
                            $kvarho1 = $r->kvarho1;
                            else
                            {
                                if(!$r->isPk)
                                $kvarho1=  ($v1 * $i1 * sin(acos($pf1)) * $diffInHours) / 1000;

                            }


                            if(isset($r->kvarho2)) // device send kvar then use that other wise calculate
                            $kvarho2 = $r->kvarho2;
                            else
                            {
                                if(!$r->isPk)
                                $kvarho2=  ($v2 * $i2 * sin(acos($pf2)) * $diffInHours) / 1000;

                            }

                            if(isset($r->kvarho3)) // device send kvar then use that other wise calculate
                            $kvarho3 = $r->kvarho3;
                            else
                            {
                                if(!$r->isPk)
                                $kvarho3=  ($v3 * $i3 * sin(acos($pf3)) * $diffInHours) / 1000;

                            }




                            $rkvarhp1 = isset($r->rkvarhp1) ? $r->rkvarhp1 : 0;
                            $rkvarhp2 = isset($r->rkvarhp2) ? $r->rkvarhp2 : 0;
                            $rkvarhp3 = isset($r->rkvarhp3) ? $r->rkvarhp3 : 0;


                            $rkvarho1 = isset($r->rkvarho1) ? $r->rkvarho1 : 0;
                            $rkvarho2 = isset($r->rkvarho2) ? $r->rkvarho2 : 0;
                            $rkvarho3 = isset($r->rkvarho3) ? $r->rkvarho3 : 0;



                            // $kwho1=$r->kwho1;
                            // $kwho2=$r->kwho2;
                            // $kwho3=$r->kwho3;

                            // $kwhp1=$r->kwhp1;
                            // $kwhp2=$r->kwhp2;
                            // $kwhp3=$r->kwhp3;

                            $kwhp1 = numberf($r->kwhp1 ??  0);
                            $kwhp2 = numberf($r->kwhp2 ??  0);
                            $kwhp3 = numberf($r->kwhp3 ??  0);


                        if(abs($mvisual->kwho1-$kwho1)>500)
                            $kwho1=$mvisual->kwho1;

                        if(abs($mvisual->kwho2-$kwho2)>500)
                            $kwho2=$mvisual->kwho2;

                        if(abs($mvisual->kwho3-$kwho3)>500)
                            $kwho3=$mvisual->kwho3;


                        if(abs($mvisual->kwhp1-$kwhp1)>500)
                            $kwhp1=$mvisual->kwhp1;

                        if(abs($mvisual->kwhp2-$kwhp2)>500)
                            $kwhp2=$mvisual->kwhp2;

                        if(abs($mvisual->kwhp3-$kwhp3)>500)
                            $kwhp3=$mvisual->kwhp3;


                            $rkwho1 = numberf($r->rkwho1 ??  0);
                            $rkwho2 = numberf($r->rkwho2 ??  0);
                            $rkwho3 = numberf($r->rkwho3 ??  0);

                            // $rkwho1=$r->rkwho1;
                            // $rkwho2=$r->rkwho2;
                            // $rkwho3=$r->rkwho3;

                            // $rkwhp1=$r->rkwhp1;
                            // $rkwhp2=$r->rkwhp2;
                            // $rkwhp3=$r->rkwhp3;
                            $rkwhp1 = numberf($r->rkwhp1 ??  0);
                            $rkwhp2 = numberf($r->rkwhp2 ??  0);
                            $rkwhp3 = numberf($r->rkwhp3 ??  0);

                        //reverse value
                        if(abs($mvisual->rkwho1-$rkwho1)>500)
                            $rkwho1=$mvisual->rkwho1;

                        if(abs($mvisual->rkwho2-$rkwho2)>500)
                            $rkwho2=$mvisual->rkwho2;

                        if(abs($mvisual->rkwho3-$rkwho3)>500)
                            $rkwho3=$mvisual->rkwho3;

                        if(abs($mvisual->rkwhp1-$rkwhp1)>500)
                            $rkwhp1=$mvisual->rkwhp1;

                        if(abs($mvisual->rkwhp2-$rkwhp2)>500)
                            $rkwhp2=$mvisual->rkwhp2;

                        if(abs($mvisual->rkwhp3-$rkwhp3)>500)
                            $rkwhp3=$mvisual->rkwhp3;






                            // $arri = array(numberf($r->i_red),numberf($r->i_blue),numberf($r->i_yellow));

                            // if ($mvisual->kwh_dev_offpeak_red > $r->kwh_op_red)
                            // $r->kwh_op_red=$mvisual->kwh_dev_offpeak_red;

                            // if ($mvisual->kwh_dev_offpeak_blue > $r->kwh_op_blue)
                            // $r->kwh_op_blue=$mvisual->kwh_dev_offpeak_blue;

                            // if ($mvisual->kwh_dev_offpeak_yellow > $r->kwh_op_yellow)
                            // $r->kwh_op_yellow=$mvisual->kwh_dev_offpeak_yellow;

                            $arrkwhoffpeak = array(numberf($kwho1),numberf($kwho2),numberf($kwho3));


                            // if ($mvisual->kwh_dev_peak_red > $r->kwh_p_red)
                            // $r->kwh_p_red=$mvisual->kwh_dev_peak_red;

                            // if ($mvisual->kwh_dev_peak_blue > $r->kwh_p_blue)
                            // $r->kwh_p_blue=$mvisual->kwh_dev_peak_blue;

                            // if ($mvisual->kwh_dev_peak_yellow> $r->kwh_p_yellow)
                            // $r->kwh_p_yellow=$mvisual->kwh_dev_peak_yellow;

                            $arrkwhpeak = array(numberf($kwhp1),numberf($kwhp2),numberf($kwhp3));


                            // if ($mvisual->kwh_dev_offpeak1 < $r->kwh_op_red)
                            // $mvisual->kwh_dev_offpeak_red=numberf($r->kwho1);
                            // else
                            // $arrkwhoffpeak[0] = numberf($mvisual->kwh_dev_offpeak1);

                            // if($mvisual->kwh_dev_offpeak2 < $r->kwh_op_blue)
                            // $mvisual->kwh_dev_offpeak_blue=numberf($r->kwho2);
                            // else
                                // $arrkwhoffpeak[1] = numberf($mvisual->kwh_dev_offpeak2);

                            // if ($mvisual->kwh_dev_offpeak3 < $r->kwh_op_yellow)
                            // $mvisual->kwh_dev_offpeak_yellow = numberf($r->kwho3);
                            // else
                                // $arrkwhoffpeak[2] = numberf($mvisual->kwh_dev_offpeak3);

                            // if ($mvisual->kwh_dev_peak1 < $r->kwh_p_red)
                                // $mvisual->kwh_dev_peak_red = numberf($r->kwh_p_red);
                            // else
                                // $arrkwhpeak[0] = numberf($mvisual->kwh_dev_peak1);

                            // if ($mvisual->kwh_dev_peak2 < $r->kwh_p_blue)
                            // $mvisual->kwh_dev_peak_blue = numberf($r->kwh_p_blue);
                            // else
                            // $arrkwhpeak[1] = numberf($mvisual->kwh_dev_peak2);


                            // if ($mvisual->kwh_dev_peak3 < $r->kwh_p_yellow)
                            // $mvisual->kwh_dev_peak_yellow = numberf($r->kwh_p_yellow);
                            // else
                                // $arrkwhpeak[2] = numberf($mvisual->kwh_dev_peak3);



                            // $offpeak_dev = numberf($arrkwhoffpeak[0] + $arrkwhoffpeak[1] + $arrkwhoffpeak[2]);
                            // $peak_dev =numberf( $arrkwhpeak[0] + $arrkwhpeak[1] + $arrkwhpeak[2]);
                            // $offpeak_dev = numberf(array_sum($arrkwhoffpeak));
                            // $peak_dev =numberf(array_sum($arrkwhpeak));
                            $peakflg = $ispeak;


                            $angle1 = acos($pf1);
                            $angle2 = acos($pf2);
                            $angle3 = acos($pf3);
                            $angle12 = deg2rad(120) + $angle2 - $angle1;
                            $angle13 = deg2rad(240) + $angle3 - $angle1;


                            $A = $i1 + ($i2 * cos($angle12)) + ($i3 * cos($angle13));   //Real Components
                            $B = ($i2 * sin($angle12)) + ($i3 * sin($angle13)); //Imaginary Components
                            $C = sqrt( $A*$A + $B*$B ); //Magnitude
                            $neutral = round($C, 2);

                            // ---nutural current --------------------
                            $nc = sqrt(
                                        pow($i1, 2) + pow($i2, 2) + pow($i3, 2)
                                        - ($i1 * $i2) - ($i2 * $i3) - ($i3 * $i1)
                                    );

                            $nc=round($nc, 2);

                            //Power Factor Correction (Avoid 1 on Transformers)------------------------
                                if($pf1>0.99)
                                    $pf1 = 0.98;
                                if($pf2>0.99)
                                    $pf2 = 0.98;
                                if($pf3>0.99)
                                    $pf3 = 0.98;


                                $kva1= round($i1*$v1/1000,2);
                                $kva2= round($i2*$v2/1000,2);
                                $kva3= round($i3*$v3/1000,2);
                                // ---------------------------------------------------------------
                                // Active Posititive MDI
                                $acp1=numberf($kva1*sin($angle1));
                                $acp2=numberf($kva2*sin($angle2));
                                $acp3=numberf($kva3*sin($angle3));
                                $acp4=0;
                                $acl= $acp1+ $acp2+  $acp3+ $acp4;
                                $b_data['active_mdi_pos_t1']= $acp1 ;
                                $b_data['active_mdi_pos_t2']= $acp2 ;
                                $b_data['active_mdi_pos_t3']= $acp3 ;
                                $b_data['active_mdi_pos_t4']=  $acp4 ;
                                $b_data['active_mdi_pos_tl']=  $acl ;

                                // Active Netative MDI
                                $acn1=0;
                                $acn2=0;
                                $acn3=0;
                                $acn4=0;
                                $acnl= $acn1+ $acn2+  $acn3+ $acn3;
                                $b_data['active_mdi_neg_t1']= $acn1 ;
                                $b_data['active_mdi_neg_t2']= $acn2 ;
                                $b_data['active_mdi_neg_t3']= $acn3 ;
                                $b_data['active_mdi_neg_t4']=  $acn4 ;
                                $b_data['active_mdi_neg_tl']=  $acnl ;


                                // Commulative MDI Posititive
                                $cpp1= $acp1+ $acn1;
                                $cpp2=$acp2+ $acn2;
                                $cpp3=$acp3+ $acn3;
                                $cpp4=$acp4+ $acn4;
                                $cpl= $cpp1+$cpp2+$cpp3+$cpp4;

                                $b_data['cumulative_mdi_pos_t1']= $cpp1 ;
                                $b_data['cumulative_mdi_pos_t2']= $cpp2 ;
                                $b_data['cumulative_mdi_pos_t3']= $cpp3 ;
                                $b_data['cumulative_mdi_pos_t4']=  $cpp4 ;
                                $b_data['cumulative_mdi_pos_tl']=  $cpl ;

                                // cumulative MDI Negative
                                $cnp1=0;
                                $cnp2=0;
                                $cnp3=0;
                                $cnp4=0;
                                $cnl=$cnp1+$cnp2+$cnp3+$cnp4 ;
                                $b_data['cumulative_mdi_neg_t1']= $cpp1 ;
                                $b_data['cumulative_mdi_neg_t2']= $cpp2 ;
                                $b_data['cumulative_mdi_neg_t3']= $cpp3 ;
                                $b_data['cumulative_mdi_neg_t4']=  $cpp4 ;
                                $b_data['cumulative_mdi_neg_tl']=  $cnl ;


                                // cumulative MDI Absolute
                                $cabp1=numberf(abs($cpp1+$cnp1));
                                $cabp2=numberf(abs($cpp2+$cnp2));
                                $cabp3=numberf(abs($cpp3+$cnp3));
                                $cabp4=numberf(abs($cpp4+$cnp4));
                                $cabnl= $cabp1+ $cabp2+  $cabp3+ $cabp4;
                                $b_data['cumulative_mdi_abs_t1']= $cabp1 ;
                                $b_data['cumulative_mdi_abs_t2']= $cabp2 ;
                                $b_data['cumulative_mdi_abs_t3']= $cabp3 ;
                                $b_data['cumulative_mdi_abs_t4']=  $cabp4 ;
                                $b_data['cumulative_mdi_abs_tl']=  $cabnl ;

                                // ---------------------------------------------------------------



                                $currenttime = strtotime($datetime);
                                $prevdatetime = $mvisual->datetime;
                                $prevdatetime = strtotime($prevdatetime);
                                $lasttime=$prevdatetime;
                                $timediff = ceil(($currenttime-$lasttime)/36000);


                                // Calculate kVAR and kvarh
                                $kvar1 = round($kva1 * sin(acos($pf1)), 2);
                                $kvar2 = round($kva2 * sin(acos($pf2)), 2);
                                $kvar3 = round($kva3 * sin(acos($pf3)), 2);


                                $kvarh1 = numberf($kvar1 * $timediff);
                                $kvarh2 = numberf($kvar2 * $timediff);
                                $kvarh3 = numberf($kvar3 * $timediff);
                                $totalKvarhP = $kvarh1 + $kvarh2 + $kvarh3;

                                $b_data['reactive_energy_pos_t1']= $kvarh1 ;
                                $b_data['reactive_energy_pos_t2']= $kvarh2 ;
                                $b_data['reactive_energy_pos_t3']= $kvarh3 ;
                                $b_data['reactive_energy_pos_t4']= 0 ;
                                $b_data['reactive_energy_pos_tl']=  $totalKvarhP ;

                                $b_data['reactive_energy_neg_t1']= 0 ;
                                $b_data['reactive_energy_neg_t2']= 0 ;
                                $b_data['reactive_energy_neg_t3']= 0 ;
                                $b_data['reactive_energy_neg_t4']= 0 ;
                                $b_data['reactive_energy_neg_tl']= 0 ;

                                $b_data['reactive_energy_abs_t1']= numberf(abs($b_data['reactive_energy_pos_t1']+ $b_data['reactive_energy_neg_t1'])) ;
                                $b_data['reactive_energy_abs_t2']= numberf(abs($b_data['reactive_energy_pos_t2']+  $b_data['reactive_energy_neg_t2']));
                                $b_data['reactive_energy_abs_t3']= numberf(abs( $b_data['reactive_energy_pos_t3']+  $b_data['reactive_energy_neg_t3']));
                                $b_data['reactive_energy_abs_t4']= 0;
                                $b_data['reactive_energy_abs_tl']= numberf(abs( $b_data['reactive_energy_pos_tl']+$b_data['reactive_energy_neg_tl'])) ;



                                $b_data['active_mdi_pos_t1']= numberf($kvarh1*$timediff) ;
                                $b_data['active_mdi_pos_t2']= numberf($kvarh2*$timediff );
                                $b_data['active_mdi_pos_t3']= numberf($kvarh3*$timediff );
                                $b_data['active_mdi_pos_tl']=  numberf($totalKvarhP*$timediff) ;

                                $b_data['active_mdi_neg_t1']= 0 ;
                                $b_data['active_mdi_neg_t2']= 0 ;
                                $b_data['active_mdi_neg_t3']= 0 ;
                                $b_data['active_mdi_neg_tl']= 0 ;

                                $b_data['active_mdi_abs_t1']=numberf( abs($b_data['active_mdi_pos_t1']+ $b_data['active_mdi_neg_t1'])) ;
                                $b_data['active_mdi_abs_t2']=numberf( abs($b_data['active_mdi_pos_t2']+  $b_data['active_mdi_neg_t2']));
                                $b_data['active_mdi_abs_t3']= numberf(abs( $b_data['active_mdi_pos_t3']+  $b_data['active_mdi_neg_t3']));
                                $b_data['active_mdi_abs_t4']= 0;
                                $b_data['active_mdi_abs_tl']= numberf(abs( $b_data['active_mdi_pos_tl']+$b_data['active_mdi_neg_tl'])) ;

                                // $totalOffpk =numberf($mvisual->offpeak);
                                // $totalpeak = numberf($mvisual->peak);
                                // $NL = numberf(round($mvisual->ltlength * $mvisual->cresistance  * $neutral *$neutral,2));
                                // $mvisual-> NC = numberf($neutral);
                                // $mvisual-> NL = numberf($NL);
                                // $NUL = numberf($NL * $timediff);
                                // $NUL = round($NUL/(60*60),2);
                                // $mvisual->NUL = $NUL;





                                $trCurrentLog[]=['global_device_id'=> $moduleid,
                                            'dtime'=>$r->dtime,
                                            'v1'=>$v1,
                                            'v2'=>$v2,
                                            'v3'=>$v3,
                                            'pf1'=>$pf1,
                                            'pf2'=>$pf2,
                                            'pf3'=>$pf3,
                                            'i1'=>$i1,
                                            'i2'=>$i2,
                                            'i3'=>$i3,

                                            'ncl'=>$neutral,
                                            'nc'=>$nc,
                                            'stime'=>$datetime,
                                            'kwho1'=>$kwho1,
                                            'kwho2'=>$kwho2,
                                            'kwho3'=>$kwho3,

                                            'kwhp1'=>$kwhp1,
                                            'kwhp2'=>$kwhp2,
                                            'kwhp3'=>$kwhp3,


                                            'rkwho1'=>$rkwho1,
                                            'rkwho2'=>$rkwho2,
                                            'rkwho3'=>$rkwho3,

                                            'rkwhp1'=>$rkwhp1,
                                            'rkwhp2'=>$rkwhp2,
                                            'rkwhp3'=>$rkwhp3,

                                            'kw1'=>$kw1,
                                            'kw2'=> $kw2,
                                            'kw3'=> $kw3 ,

                                            'kvarhp1'=> $kvarhp1,
                                            'kvarhp2'=> $kvarhp2,
                                            'kvarhp3'=> $kvarhp3,

                                            'kvarho1'=> $kvarho1,
                                            'kvarho2'=> $kvarho2,
                                            'kvarho3'=> $kvarho3,

                                            'rkvarhp1'=> $rkvarhp1,
                                            'rkvarhp2'=> $rkvarhp2,
                                            'rkvarhp3'=> $rkvarhp3,

                                            'rkvarho1'=> $rkvarho1,
                                            'rkvarho2'=> $rkvarho2,
                                            'rkvarho3'=> $rkvarho3,
                                            'isPk'=>$r->isPk,
                                            // 'isRv'=>$r->isRv,
                                            'stime'=>date('Y-m-d H:i:s')
                                           ];

                                //  echo json_encode($trCurrentLog);

                                $mvisual->current_phase_a=$i1;
                                $mvisual->current_phase_b=$i2;
                                $mvisual->current_phase_c=$i3;

                                $mvisual->voltage_phase_a=$v1;
                                $mvisual->voltage_phase_b=$v2;
                                $mvisual->voltage_phase_c=$v3;

                                $mvisual->pf1=$pf1;
                                $mvisual->pf2=$pf2;
                                $mvisual->pf3=$pf3;

                                $mvisual->kwho1=$kwho1;
                                $mvisual->kwho2=$kwho2;
                                $mvisual->kwho3=$kwho3;


                                $mvisual->kwhp1=$kwhp1;
                                $mvisual->kwhp2=$kwhp2;
                                $mvisual->kwhp3=$kwhp3;


                                //reverse value
                                $mvisual->rkwho1=$rkwho1;
                                $mvisual->rkwho2=$rkwho2;
                                $mvisual->rkwho3=$rkwho3;

                                $mvisual->rkwhp1=$rkwhp1;
                                $mvisual->rkwhp2=$rkwhp2;
                                $mvisual->rkwhp3=$rkwhp3;

                                // $mvisual->rkwho2=$r->rkwho2;
                                // $mvisual->rkwho3=$r->rkwho3;

                                // $mvisual->rkwhp1=$r->rkwhp1;
                                // $mvisual->rkwhp2=$r->rkwhp2;
                                // $mvisual->rkwhp3=$r->rkwhp3;

                                $mankwh = (($v1 * $i1 *$pf1) + ($v2 * $i2 * $pf2) + ($v2 * $i2 * $pf3) );
                                $b_data['active_energy_pos_t1']=numberf(($v1 * $i1 *$pf1)*$timediff);
                                $b_data['active_energy_pos_t2']=numberf(($v2 * $i2 *$pf2)*$timediff);
                                $b_data['active_energy_pos_t3']=numberf(($v3 * $i3 *$pf3)*$timediff);
                                $b_data['active_energy_pos_t4']=0;
                                $b_data['active_energy_pos_tl']=0;

                                $b_data['active_energy_neg_t1']=0;
                                $b_data['active_energy_neg_t2']=0;
                                $b_data['active_energy_neg_t3']=0;
                                $b_data['active_energy_neg_t4']=0;
                                $b_data['active_energy_neg_tl']=0;


                                $b_data['active_energy_abs_t1']=numberf(abs($b_data['active_energy_pos_t1']+$b_data['active_energy_neg_t1']));
                                $b_data['active_energy_abs_t2']=numberf(abs($b_data['active_energy_pos_t2']+$b_data['active_energy_neg_t2']));
                                $b_data['active_energy_abs_t3']=numberf(abs($b_data['active_energy_pos_t3']+$b_data['active_energy_neg_t3']));
                                $b_data['active_energy_abs_t4']=numberf(abs($b_data['active_energy_pos_t4']+$b_data['active_energy_neg_t4']));
                                $b_data['active_energy_abs_tl']=0;

                                $insertBillingData[]=$b_data;
                                $mankwh = numberf($mankwh*$timediff);
                                $mankwh = numberf($mankwh);
                                $mankwh = numberf($mankwh / (1000));
                                $arrkwh = array(($v1 * $i1 *$pf1*$timediff)/3600000,($v2 * $i2 * $pf2*$timediff)/3600000,($v3 * $i3 *
                                $pf3*$timediff)/3600000);
                                $offpeak = 0;
                                $pk = 0;


                                if($ispeak== 1)
                                {
                                    // $offpeak = numberf($totalOffpk);
                                    // $pk = (float)$totalpeak;
                                    $realval = numberf($mankwh);
                                    // $mvisual->kwhp1=numberf($mvisual->kwhp1 +$arrkwhpeak[0]);
                                    // $mvisual->kwhp2=numberf($mvisual->kwhp2 +$arrkwhpeak[1]);
                                    // $mvisual->kwhp3=numberf($mvisual->kwhp3 +$arrkwhpeak[2]);
                                }
                                else
                                {
                                    // $pk = numberf($totalpeak);
                                    // $offpeak = numberf($totalOffpk);
                                    $realval = numberf($mankwh);
                                    // $mvisual->kwho1=numberf($mvisual->kwho1 +$arrkwhoffpeak[0]);
                                    // $mvisual->kwho2=numberf($mvisual->kwho2 +$arrkwhoffpeak[1]);
                                    // $mvisual->kwho3=numberf($mvisual->kwho3 +$arrkwhoffpeak[2]);
                                }

                                // if($ispeak ==1)
                                // {
                                //     $pkunits_dev = numberf($peak_dev -  $mvisual->peak_dev);
                                //     $pkunits = numberf($arrkwhpeak[0] + $arrkwhpeak[1] + $arrkwhpeak[2]);

                                //     $offpkunits_dev = 0;
                                //     $offpkunits = 0;
                                // }
                                // else
                                // {
                                //     $offpkunits_dev = numberf($offpeak_dev -  $mvisual->offpeak_dev);
                                //     $offpkunits = numberf($arrkwhoffpeak[0] + $arrkwhoffpeak[1] + $arrkwhoffpeak[2]);
                                //     $pkunits_dev = 0;
                                //     $pkunits = 0;
                                // }

                            //   $mvisual->peak_dev = $peak_dev;
                            //   $mvisual->offpeak_dev = $offpeak_dev;
                            //   $mvisual->offpeak= $offpeak;
                            //   $mvisual->peak= $pk;
                              $insertkwh[]=['trid'=> $moduleid,
                                            'offpeak'=>$offpeak,
                                            'peak'=>$pk,
                                            // 'offpeak_dev'=>$offpeak_dev,
                                            // 'peak_dev'=>$peak_dev,
                                            'stime'=>$datetime,
                                            // 'offpkunits'=>$offpkunits,
                                            // 'pkunits'=>$pkunits,
                                            // 'offpkunits_dev'=>$offpkunits_dev,
                                            // 'pkunits_dev'=>$pkunits_dev,
                                            'v1'=>$v1,
                                            'v2'=>$v2,
                                            'v3'=>$v3,
                                            'i1'=>$i1,
                                            'i2'=>$i2,
                                            'i3'=>$i3,
                                            'pf1'=>$pf1,
                                            'pf2'=>$pf2,
                                            'pf3'=>$pf3,

                                            'kw1'=>$kw1,
                                            'kw2'=> $kw2,
                                            'kw3'=> $kw3 ,


                                            'kwhp1'=>$kwhp1,
                                            'kwhp2'=>$kwhp2,
                                            'kwhp3'=>$kwhp3,
                                            'kwho1'=>$kwho1,
                                            'kwho2'=>$kwho2,
                                            'kwho3'=>$kwho3,

                                            'rkwho1'=>$rkwho1,
                                            'rkwho2'=>$rkwho2,
                                            'rkwho3'=>$rkwho3,

                                            'rkwhp1'=>$rkwhp1,
                                            'rkwhp2'=>$rkwhp2,
                                            'rkwhp3'=>$rkwhp3,
                                            'dtime'=>$r->dtime,


                                            'pkflg'=>$peakflg
                                            ];
                                            // $row1->datetime = $datetime;
                                            $lasttime=strtotime($mvisual->switch_time);
                                            $timediff = ceil(($currenttime-$lasttime)/60);



                                $mvisual->save();
                        // }
            //    }
        // }
        if(!empty($trCurrentLog))
        TrCurrentLog::insert($trCurrentLog);


        // insertion to recentCurrentLog
        DB::table('tr_current_logs_recent')->insert($trCurrentLog);

        if(!empty($insertkwh))
        TrKwhLog::insert($insertkwh);

    //    if(!empty($insertBillingData))
    //     BillingData::insert($insertBillingData);

        // echo 'trigger data inserted successfully';
        return 1;

        // echo json_encode('Crone Job Run Successfully ');



    }

    // public function post_event($re)
    // {
    //     $validator = Validator::make($re['d'], [
    //                 'event_code' => 'required|integer',
    //                 // 'global_device_id' => 'required',
    //                 'event_datetime' => 'required',
    //                 'event_description'=>'required'
    //             ]);

    //     if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);
    //     $request=$re['d'];
    //     // return response()->json($request->all());
    //     $data=[
    //             'msn'=>$request['msn'],
    //             'global_device_id'=>$re['gid'],
    //             'event_datetime'=>$request['event_datetime'],
    //             'event_code'=>$request['event_code'],
    //             'event_description'=>$request['event_description'],
    //             'mdc_read_datetime'=>date('Y-m-d H:i:s'),
    //             'db_datetime'=>date('Y-m-d H:i:s')
    //             ]  ;

    //     if(!empty($data))
    //     {
    //         EventM::insert($data);
    //     return  ['message'=>'Event Store Successfully'];
    //     }
    //     else
    //     return  ['message'=>'Event Saving failed'];
    // }
    public function post_event($re)
    {
        $validator = Validator::make($re['d'], [
            'events' => 'required|array',
            'events.*.event_code' => 'required|integer',
            'events.*.gid' => 'required', // Uncomment if you need this
            'events.*.event_datetime' => 'required',
            'events.*.event_description' => 'required',
        ]);

        if ($validator->fails()) {
            return result(0, 'Validation Error.', $validator->errors(), 422);
        }

        $eventsData = [];
        foreach ($re['d'] as $event) {
            $eventsData[] = [
                                'msn' => $event['msn'] ?? null, // Assuming 'msn' is part of each event
                                'global_device_id' => $re['gid'],
                                'event_datetime' => $event['event_datetime'],
                                'event_code' => $event['event_code'],
                                'event_description' => $event['event_description'],
                                'mdc_read_datetime' => date('Y-m-d H:i:s'),
                                'db_datetime' => date('Y-m-d H:i:s'),
                            ];
        }

        if (!empty($eventsData)) {
            EventM::insert($eventsData);
            return ['message' => 'Events Stored Successfully'];
        } else {
            return ['message' => 'Event Saving Failed'];
        }
    }

    function save_configuration_data($dt)
    {

        $r = $dt['d'];
        $gid = $dt['gid'];

        $data = [
                 'data' => json_encode($r, true),

                ];

        // Insert or update the record where global_device_id matches
        return DeviceConfiguration::updateOrInsert(
            ['global_device_id' => $gid], // Match condition
            $data // Data to insert or update
        );
    }
    function extra_log($dt)
    {
        $r=(object)$dt['d'];
        $gid=$dt['gid'];
        $elog=[];
        $elog['global_device_id']= $gid ;
        $elog['dtime']= date('Y-m-d H:i:s',strtotime($r->m_dt));
        $elog['stime']= date('Y-m-d H:i:s');

        $elog['si']= $r->si;
        $elog['bi']= $r->bi;
        $elog['wi']= $r->wi;
        $elog['wv']= $r->wv;
        $elog['ii']= $r->ii;
        $elog['vi']= $r->vi;
        $elog['sv']= $r->sv;
        $elog['bv']= $r->bv;


        if(!empty($elog))
            return ExtraLog::insert($elog);
        else

            return [];
    }
     function post_billing_data($dt)
    {

        $r=(object)$dt['d'];
        $gid=$dt['gid'];
        $b_data=[];
        $b_data['global_device_id']= $gid ;
        $b_data['meter_datetime']= date('Y-m-d H:i:s',strtotime($r->m_dt)) ;
        $b_data['mdc_read_datetime']= date('Y-m-d H:i:s') ;


        $b_data['active_energy_pos_t1']=round((float)$r->aept1, 5);
        $b_data['active_energy_pos_t2']=round((float)$r->aept2, 5);
        $b_data['active_energy_pos_t3']=round((float)$r->aept3, 5);
        $b_data['active_energy_pos_t4']=round((float)$r->aept4, 5);
        $b_data['active_energy_pos_tl']=round((float)$r->aeptl, 5);

        $b_data['active_energy_neg_t1']=round((float)$r->aent1, 5);
        $b_data['active_energy_neg_t2']=round((float)$r->aent2, 5);
        $b_data['active_energy_neg_t3']=round((float)$r->aent3, 5);
        $b_data['active_energy_neg_t4']=round((float)$r->aent4, 5);
        $b_data['active_energy_neg_tl']=round((float)$r->aentl, 5);


        $b_data['active_energy_abs_t1']=round((float)$r->aeat1, 5);
        $b_data['active_energy_abs_t2']=round((float)$r->aeat2, 5);
        $b_data['active_energy_abs_t3']=round((float)$r->aeat3, 5);
        $b_data['active_energy_abs_t4']=round((float)$r->aeat4, 5);
        $b_data['active_energy_abs_tl']=round((float)$r->aeatl, 5);
        // Active Posititive MDI
        $b_data['active_mdi_pos_t1']=round((float) $r->ampt1 , 5);
        $b_data['active_mdi_pos_t2']=round((float) $r->ampt2 , 5);
        $b_data['active_mdi_pos_t3']=round((float) $r->ampt3 , 5);
        $b_data['active_mdi_pos_t4']=round((float) $r->ampt4 , 5);
        $b_data['active_mdi_pos_tl']=round((float) $r->amptl , 5);

        // Active Netative MDI
        $b_data['active_mdi_neg_t1']=round((float) $r->amnt1, 5);
        $b_data['active_mdi_neg_t2']=round((float) $r->amnt2, 5);
        $b_data['active_mdi_neg_t3']=round((float) $r->amnt3, 5);
        $b_data['active_mdi_neg_t4']=round((float) $r->amnt4, 5);
        $b_data['active_mdi_neg_tl']=round((float) $r->amntl, 5);

        //active mdi absolute
        $b_data['active_mdi_abs_t1']=round((float)$r->amat1, 5);
        $b_data['active_mdi_abs_t2']=round((float)$r->amat2, 5);
        $b_data['active_mdi_abs_t3']=round((float) $r->amat3, 5);
        $b_data['active_mdi_abs_t4']=round((float) $r->amat4, 5);
        $b_data['active_mdi_abs_tl']=round((float) $r->amatl, 5);


        // Commulative MDI Posititive

        $b_data['cumulative_mdi_pos_t1']=round((float) $r->cmpt1 , 5);
        $b_data['cumulative_mdi_pos_t2']=round((float) $r->cmpt2 , 5);
        $b_data['cumulative_mdi_pos_t3']=round((float) $r->cmpt3 , 5);
        $b_data['cumulative_mdi_pos_t4']=round((float) $r->cmpt4 , 5);
        $b_data['cumulative_mdi_pos_tl']=round((float)  $r->cmptl , 5);

        // cumulative MDI Negative
        $b_data['cumulative_mdi_neg_t1']=round((float) $r->cmnt1 , 5);
        $b_data['cumulative_mdi_neg_t2']=round((float) $r->cmnt2 , 5);
        $b_data['cumulative_mdi_neg_t3']=round((float) $r->cmnt3 , 5);
        $b_data['cumulative_mdi_neg_t4']=round((float) $r->cmnt4 , 5);
        $b_data['cumulative_mdi_neg_tl']=round((float)  $r->cmntl , 5);


        // cumulative MDI Absolute
        $b_data['cumulative_mdi_abs_t1']=round((float)  $r->cmat1, 5);
        $b_data['cumulative_mdi_abs_t2']=round((float) $r->cmat2, 5);
        $b_data['cumulative_mdi_abs_t3']=round((float) $r->cmat3, 5);
        $b_data['cumulative_mdi_abs_t4']=round((float)  $r->cmat4, 5);
        $b_data['cumulative_mdi_abs_tl']=round((float)  $r->cmatl, 5);

        // ---------------------------------------------------------------

        $b_data['reactive_energy_pos_t1']=round((float) $r->rept1 , 5);
        $b_data['reactive_energy_pos_t2']=round((float) $r->rept2 , 5);
        $b_data['reactive_energy_pos_t3']=round((float) $r->rept3 , 5);
        $b_data['reactive_energy_pos_t4']=round((float) $r->rept4 , 5);
        $b_data['reactive_energy_pos_tl']=round((float)  $r->reptl , 5);

        $b_data['reactive_energy_neg_t1']=round((float) $r->rent1 , 5);
        $b_data['reactive_energy_neg_t2']=round((float)  $r->rent2 , 5);
        $b_data['reactive_energy_neg_t3']=round((float)  $r->rent3 , 5);
        $b_data['reactive_energy_neg_t4']=round((float)  $r->rent4 , 5);
        $b_data['reactive_energy_neg_tl']=round((float)  $r->rentl , 5);

        $b_data['reactive_energy_abs_t1']=round((float) $r->reat1, 5);
        $b_data['reactive_energy_abs_t2']=round((float) $r->reat2, 5);
        $b_data['reactive_energy_abs_t3']=round((float) $r->reat3, 5);
        $b_data['reactive_energy_abs_t4']=round((float) $r->reat4, 5);
        $b_data['reactive_energy_abs_tl']=round((float) $r->reatl, 5);

        if(!empty($b_data))
            return BillingData::insert($b_data);
        else

            return [];
    }

    function post_monthly_billing_data($dt)
    {

        $r=(object)$dt['d'];
        $gid=$dt['gid'];
        $b_data=[];
        $b_data['global_device_id']= $gid ;
        $b_data['meter_datetime']= date('Y-m-d H:i:s',strtotime($r->m_dt)) ;
        $b_data['mdc_read_datetime']= date('Y-m-d H:i:s') ;
        $b_data['mdi_reset_datetime']= date('Y-m-d H:i:s',strtotime($r->mdi_reset_datetime));
        $b_data['reset_count']= ((int)$r->reset_count);

        $b_data['active_energy_pos_t1']=round((float)$r->aept1, 5);
        $b_data['active_energy_pos_t2']=round((float)$r->aept2, 5);
        $b_data['active_energy_pos_t3']=round((float)$r->aept3, 5);
        $b_data['active_energy_pos_t4']=round((float)$r->aept4, 5);
        $b_data['active_energy_pos_tl']=round((float)$r->aeptl, 5);

        $b_data['active_energy_neg_t1']=round((float)$r->aent1, 5);
        $b_data['active_energy_neg_t2']=round((float)$r->aent2, 5);
        $b_data['active_energy_neg_t3']=round((float)$r->aent3, 5);
        $b_data['active_energy_neg_t4']=round((float)$r->aent4, 5);
        $b_data['active_energy_neg_tl']=round((float)$r->aentl, 5);


        $b_data['active_energy_abs_t1']=round((float)$r->aeat1, 5);
        $b_data['active_energy_abs_t2']=round((float)$r->aeat2, 5);
        $b_data['active_energy_abs_t3']=round((float)$r->aeat3, 5);
        $b_data['active_energy_abs_t4']=round((float)$r->aeat4, 5);
        $b_data['active_energy_abs_tl']=round((float)$r->aeatl, 5);
        // Active Posititive MDI
        $b_data['active_mdi_pos_t1']=round((float) $r->ampt1 , 5);
        $b_data['active_mdi_pos_t2']=round((float) $r->ampt2 , 5);
        $b_data['active_mdi_pos_t3']=round((float) $r->ampt3 , 5);
        $b_data['active_mdi_pos_t4']=round((float) $r->ampt4 , 5);
        $b_data['active_mdi_pos_tl']=round((float) $r->amptl , 5);

        // Active Netative MDI
        $b_data['active_mdi_neg_t1']=round((float) $r->amnt1, 5);
        $b_data['active_mdi_neg_t2']=round((float) $r->amnt2, 5);
        $b_data['active_mdi_neg_t3']=round((float) $r->amnt3, 5);
        $b_data['active_mdi_neg_t4']=round((float) $r->amnt4, 5);
        $b_data['active_mdi_neg_tl']=round((float) $r->amntl, 5);

        //active mdi absolute
        $b_data['active_mdi_abs_t1']=round((float)$r->amat1, 5);
        $b_data['active_mdi_abs_t2']=round((float)$r->amat2, 5);
        $b_data['active_mdi_abs_t3']=round((float) $r->amat3, 5);
        $b_data['active_mdi_abs_t4']=round((float) $r->amat4, 5);
        $b_data['active_mdi_abs_tl']=round((float) $r->amatl, 5);


        // Commulative MDI Posititive

        $b_data['cumulative_mdi_pos_t1']=round((float) $r->cmpt1 , 5);
        $b_data['cumulative_mdi_pos_t2']=round((float) $r->cmpt2 , 5);
        $b_data['cumulative_mdi_pos_t3']=round((float) $r->cmpt3 , 5);
        $b_data['cumulative_mdi_pos_t4']=round((float) $r->cmpt4 , 5);
        $b_data['cumulative_mdi_pos_tl']=round((float)  $r->cmptl , 5);

        // cumulative MDI Negative
        $b_data['cumulative_mdi_neg_t1']=round((float) $r->cmnt1 , 5);
        $b_data['cumulative_mdi_neg_t2']=round((float) $r->cmnt2 , 5);
        $b_data['cumulative_mdi_neg_t3']=round((float) $r->cmnt3 , 5);
        $b_data['cumulative_mdi_neg_t4']=round((float) $r->cmnt4 , 5);
        $b_data['cumulative_mdi_neg_tl']=round((float)  $r->cmntl , 5);


        // cumulative MDI Absolute
        $b_data['cumulative_mdi_abs_t1']=round((float)  $r->cmat1, 5);
        $b_data['cumulative_mdi_abs_t2']=round((float) $r->cmat2, 5);
        $b_data['cumulative_mdi_abs_t3']=round((float) $r->cmat3, 5);
        $b_data['cumulative_mdi_abs_t4']=round((float)  $r->cmat4, 5);
        $b_data['cumulative_mdi_abs_tl']=round((float)  $r->cmatl, 5);

        // ---------------------------------------------------------------

        $b_data['reactive_energy_pos_t1']=round((float) $r->rept1 , 5);
        $b_data['reactive_energy_pos_t2']=round((float) $r->rept2 , 5);
        $b_data['reactive_energy_pos_t3']=round((float) $r->rept3 , 5);
        $b_data['reactive_energy_pos_t4']=round((float) $r->rept4 , 5);
        $b_data['reactive_energy_pos_tl']=round((float)  $r->reptl , 5);

        $b_data['reactive_energy_neg_t1']=round((float) $r->rent1 , 5);
        $b_data['reactive_energy_neg_t2']=round((float)  $r->rent2 , 5);
        $b_data['reactive_energy_neg_t3']=round((float)  $r->rent3 , 5);
        $b_data['reactive_energy_neg_t4']=round((float)  $r->rent4 , 5);
        $b_data['reactive_energy_neg_tl']=round((float)  $r->rentl , 5);

        $b_data['reactive_energy_abs_t1']=round((float) $r->reat1, 5);
        $b_data['reactive_energy_abs_t2']=round((float) $r->reat2, 5);
        $b_data['reactive_energy_abs_t3']=round((float) $r->reat3, 5);
        $b_data['reactive_energy_abs_t4']=round((float) $r->reat4, 5);
        $b_data['reactive_energy_abs_tl']=round((float) $r->reatl, 5);

        if(!empty($b_data))
            return MonthlyBillingData::insert($b_data);
        else

            return [];
    }

    function load_profile($dt)
    {
        try {
        $r=(object)$dt['d'];
        $gid=$dt['gid'];
        $b_data=[];
        $b_data['global_device_id']= $gid ;

        $b_data['meter_datetime']= date('Y-m-d H:i:s',strtotime($r->m_dt)) ;
        $b_data['mdc_read_datetime']= date('Y-m-d H:i:s') ;
        $b_data['current_phase_a']=numberf($r->i1);
        $b_data['current_phase_b']=numberf($r->i2);
        $b_data['current_phase_c']=numberf($r->i3);

        $b_data['voltage_phase_a']=numberf($r->v1);
        $b_data['voltage_phase_b']=numberf($r->v2);
        $b_data['voltage_phase_c']=numberf($r->v3);

        $b_data['thdva']=numberf($r->thdv1);
        $b_data['thdvb']=numberf($r->thdv2);
        $b_data['thdvc']=numberf($r->thdv3);

        $b_data['load_direction_a']=numberf($r->d1);
        $b_data['load_direction_b']=numberf($r->d2);
        $b_data['load_direction_c']=numberf($r->d3);



        $b_data['average_pf']=numberf($r->avg_pf);


        // $b_data['active_energy_pos_t1']=round((float)$r->aept1, 5);
        // $b_data['active_energy_pos_t2']=round((float)$r->aept2, 5);
        // $b_data['active_energy_pos_t3']=round((float)$r->aept3, 5);
        // $b_data['active_energy_pos_t4']=round((float)$r->aept4, 5);
        // $b_data['active_energy_pos_tl']=round((float)$r->aeptl, 5);

        // $b_data['active_energy_neg_t1']=round((float)$r->aent1, 5);
        // $b_data['active_energy_neg_t2']=round((float)$r->aent2, 5);
        // $b_data['active_energy_neg_t3']=round((float)$r->aent3, 5);
        // $b_data['active_energy_neg_t4']=round((float)$r->aent4, 5);
        // $b_data['active_energy_neg_tl']=round((float)$r->aentl, 5);


        // $b_data['active_energy_abs_t1']=round((float)$r->aeat1, 5);
        // $b_data['active_energy_abs_t2']=round((float)$r->aeat2, 5);
        // $b_data['active_energy_abs_t3']=round((float)$r->aeat3, 5);
        // $b_data['active_energy_abs_t4']=round((float)$r->aeat4, 5);
        // $b_data['active_energy_abs_tl']=round((float)$r->aeatl, 5);
        // // Active Posititive MDI
        // $b_data['active_mdi_pos_t1']=round((float) $r->ampt1 , 5);
        // $b_data['active_mdi_pos_t2']=round((float) $r->ampt2 , 5);
        // $b_data['active_mdi_pos_t3']=round((float) $r->ampt3 , 5);
        // $b_data['active_mdi_pos_t4']=round((float) $r->ampt4 , 5);
        // $b_data['active_mdi_pos_tl']=round((float) $r->amptl , 5);

        // // Active Netative MDI
        // $b_data['active_mdi_neg_t1']=round((float) $r->amnt1, 5);
        // $b_data['active_mdi_neg_t2']=round((float) $r->amnt2, 5);
        // $b_data['active_mdi_neg_t3']=round((float) $r->amnt3, 5);
        // $b_data['active_mdi_neg_t4']=round((float) $r->amnt4, 5);
        // $b_data['active_mdi_neg_tl']=round((float) $r->amntl, 5);

        // //active mdi absolute
        // $b_data['active_mdi_abs_t1']=round((float)$r->amat1, 5);
        // $b_data['active_mdi_abs_t2']=round((float)$r->amat2, 5);
        // $b_data['active_mdi_abs_t3']=round((float) $r->amat3, 5);
        // $b_data['active_mdi_abs_t4']=round((float) $r->amat4, 5);
        // $b_data['active_mdi_abs_tl']=round((float) $r->amatl, 5);


        // // Commulative MDI Posititive

        // $b_data['cumulative_mdi_pos_t1']=round((float) $r->cmpt1 , 5);
        // $b_data['cumulative_mdi_pos_t2']=round((float) $r->cmpt2 , 5);
        // $b_data['cumulative_mdi_pos_t3']=round((float) $r->cmpt3 , 5);
        // $b_data['cumulative_mdi_pos_t4']=round((float) $r->cmpt4 , 5);
        // $b_data['cumulative_mdi_pos_tl']=round((float)  $r->cmptl , 5);

        // // cumulative MDI Negative
        // $b_data['cumulative_mdi_neg_t1']=round((float) $r->cmnt1 , 5);
        // $b_data['cumulative_mdi_neg_t2']=round((float) $r->cmnt2 , 5);
        // $b_data['cumulative_mdi_neg_t3']=round((float) $r->cmnt3 , 5);
        // $b_data['cumulative_mdi_neg_t4']=round((float) $r->cmnt4 , 5);
        // $b_data['cumulative_mdi_neg_tl']=round((float)  $r->cmntl , 5);


        // // cumulative MDI Absolute
        // $b_data['cumulative_mdi_abs_t1']=round((float)  $r->cmat1, 5);
        // $b_data['cumulative_mdi_abs_t2']=round((float) $r->cmat2, 5);
        // $b_data['cumulative_mdi_abs_t3']=round((float) $r->cmat3, 5);
        // $b_data['cumulative_mdi_abs_t4']=round((float)  $r->cmat4, 5);
        // $b_data['cumulative_mdi_abs_tl']=round((float)  $r->cmatl, 5);

        // // ---------------------------------------------------------------

        // $b_data['reactive_energy_pos_t1']=round((float) $r->rept1 , 5);
        // $b_data['reactive_energy_pos_t2']=round((float) $r->rept2 , 5);
        // $b_data['reactive_energy_pos_t3']=round((float) $r->rept3 , 5);
        // $b_data['reactive_energy_pos_t4']=round((float) $r->rept4 , 5);
        // $b_data['reactive_energy_pos_tl']=round((float)  $r->reptl , 5);

        // $b_data['reactive_energy_neg_t1']=round((float) $r->rent1 , 5);
        // $b_data['reactive_energy_neg_t2']=round((float)  $r->rent2 , 5);
        // $b_data['reactive_energy_neg_t3']=round((float)  $r->rent3 , 5);
        // $b_data['reactive_energy_neg_t4']=round((float)  $r->rent4 , 5);
        // $b_data['reactive_energy_neg_tl']=round((float)  $r->rentl , 5);

        // $b_data['reactive_energy_abs_t1']=round((float) $r->reat1, 5);
        // $b_data['reactive_energy_abs_t2']=round((float) $r->reat2, 5);
        // $b_data['reactive_energy_abs_t3']=round((float) $r->reat3, 5);
        // $b_data['reactive_energy_abs_t4']=round((float) $r->reat4, 5);
        // $b_data['reactive_energy_abs_tl']=round((float) $r->reatl, 5);

        if(!empty($b_data))
            return LoadProfileData::insert($b_data);
        else

            return [];
        } catch (\Exception $e) {
            echo "error in data : {$e->getMessage()}\n";
        }
    }

    public function update_relay_status($data)
    {
        $rec=Command::where(['a'=>'aux_relay_operation','gid'=>$data['gid']])->delete();
        $row=MeterVisual::where('global_device_id',$data['gid'])
        ->update(['auxr_status'=>$data['d']['auxr_status']]);
        return 1;
    }



}
