<?php

namespace App\Traits;

use App\Models\Command;
use Illuminate\Support\Facades\DB; // Ensure to import the DB facade
use WebSocket\Client;

trait CommandTrait
{
    /**
     * Send a command to a specific device using WebSocket.
     *
     * @param array $data
     * @param string $operation
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendCommand(array $data)
    {
        
        $gid = $data['gid'];
        $action = $data['a'];
        $message = socket_data($data);  // your existing function to prepare the message
        $webSocketUrl = "wss://apms-lesco.cisnr.com/ws/?company=".session('company_id')."&server_token=abc23ZCZ";
        // $webSocketUrl = "ws://127.0.0.1:9000/?company=".session('company_id')."&server_token=abc23ZCZ";
    
        // Check if client is connected (your DB logic)
        $client = DB::table('websocket_connections')
            ->where('global_device_id', $gid)
            ->orderBy('id', 'desc')
            ->first();
    
        $crec = Command::where([
            'at' => $data['at'],
            'a' => $data['a'],
            'gid' => $gid
        ])->first();
    
        // If client not connected, log command and return 0 or 2
        if (!$client) {
            if ($crec) {
                return 2; // command already exists, device not connected
            }
    
            Command::create([
                'gid' => $gid,
                'command' => json_encode($message),
                'a' => $data['a'],
                'at' => $data['at'],
            ]);
            return 0;
        }
    
        // If client is connected and command not yet logged, log it
        if (!$crec) {
            Command::create([
                'gid' => $gid,
                'command' => json_encode($message),
                'a' => $data['a'],
                'at' => $data['at'],
            ]);
        }
    
        // Try to send WebSocket message using textalk/websocket client
        \Log::info('Sending WebSocket message:', $message);

        try {
            $clientWs = new Client($webSocketUrl, [
                'timeout' => 5,
                'headers' => [
                    'Origin' => 'https://apms-lesco.cisnr.com'
                ]
            ]);

            $clientWs->send(json_encode($message));
            $clientWs->close();

            \Log::info('WebSocket message sent successfully.');

        } catch (\Exception $e) {
            \Log::error('WebSocket error: ' . $e->getMessage());
            return 0;
        }
    
        return 1;  // success
    }

    public function sendCommandsToMultipleDevices(array $deviceCommands)
    {
        // Create an event loop instance
        $loop = Loop::get();
        $connector = new WebSocketConnector($loop);

        // Store connections and commands
        $connections = [];
        $responses = [];

        // WebSocket server URL
        $server = env('WEBSOCKET_SERVER');
        $port = env('WEBSOCKET_PORT');
        $webSocketUrl = "{$server}:{$port}?server_token=abc23ZCZ";

        // Create a single connection for all devices
        $connector($webSocketUrl)->then(
            function (WebSocket $conn) use ($deviceCommands, &$responses, &$connections) {
                foreach ($deviceCommands as $rowkey => $row) {
                    $data = [
                        'gid' => $row['gid'],
                        'a' => $row['a'],
                        'at'=>$row['at'],
                        'd'=>$row['d']
                    ];

                    $message = socket_data($data);
                    // print_r($message);
                    $conn->send(json_encode($message));

                    // Store the response for this command
                    // $responses[] = "Command '{$action}' sent to device {$gid}";
                }

                // Close the WebSocket connection after all commands are sent
                $conn->close();
            },
            function (\Exception $e) {
                // Handle connection failure
                echo "Could not connect: {$e->getMessage()}\n";
            }
        );

        // Run the event loop
        $loop->run();

        return response()->json([
            'status' => 1,
            'responses' => $responses,
        ]);
    }

}
