<?php

namespace App\Traits;

trait ApiResponse
{
    /**
     * Format and return a consistent API response.
     *
     * @param mixed $data
     * @param string $message
     * @param int $statusCode
     * @param bool $success
     * @return \Illuminate\Http\JsonResponse
     */
    public function apiResponse($message = '',$data ,$success = true,$statusCode = 200)
    {
        $response = [
            'success' => $success,
            'message' => $message,
            'data' => $data,
        ];

        return response()->json($response, $statusCode);
    }
}
