<?php

namespace App\Services;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\User;
use App\Models\UserInterest;

use App\Http\Controllers\NotificationController;

class TaskNotificationService 
{
    public function sendTaskNotifications()
    {
        $today = Carbon::now()->toDateString();
        $tasks = $this->fetchTasks($today);
        return sizeof($tasks);
        foreach ($tasks as $task) {
            $this->prepareAndSendNotification($task);
        }
    }

    protected function fetchTasks($today)
    {
        $users = User::all();

        // Initialize an array to store the tasks
        $allTasks = [];

        // Loop through each user
        foreach ($users as $user) {
            $userTimezone = $user->timezone;

            // Convert the current date to the user's timezone
            $currentDate = now();
            $selectedDate = $currentDate->setTimezone($userTimezone);

            // Modify the query to filter tasks based on the user's timezone and the selected date
            $tasks = UserInterest::leftJoin('user_tasks AS ut', function ($join) use ($selectedDate) {
                $join->on('user_interests.id', '=', 'ut.task_id')
                    ->on('user_interests.id', '=', 'ut.task_id')
                    ->where(function ($query) use ($selectedDate) {
                        $query->whereRaw("DATE(ut.updated_at) = '{$selectedDate->toDateString()}'");
                    });
                    
            })
                ->where('user_interests.user_id', $user->id)
                ->where(function ($query) use ($selectedDate) {
                    $query->where('user_interests.how_often', 'daily')
                        ->orWhere(function ($query) use ($selectedDate) {
                            $query->where('user_interests.how_often', 'weekly')
                                ->whereRaw("DAYOFWEEK('{$selectedDate->toDateString()}') = DAYOFWEEK(user_interests.created_at)");
                        })
                        ->orWhere(function ($query) use ($selectedDate) {
                            $query->where('user_interests.how_often', 'custom')
                                ->where(function ($query) use ($selectedDate) {
                                    $query->where('user_interests.id', '=', DB::raw('ut.task_id'))
                                        ->orWhereExists(function ($subquery) use ($selectedDate) {
                                            $subquery->select(DB::raw(1))
                                                ->from('repeat_days AS rd')
                                                ->where('rd.task_id', '=', DB::raw('user_interests.id'))
                                                ->whereRaw("rd.day = '{$selectedDate->format('D')}'");
                                        });
                                });
                        })
                        ->orWhere(function ($query) use ($selectedDate) {
                            $query->where('user_interests.how_often', 'monthly')
                                ->whereRaw("DAY('{$selectedDate->toDateString()}') = DAY(user_interests.created_at)");
                        });
                })
                ->select('user_interests.id', 'user_interests.importance', 'user_interests.user_id', 'user_interests.sub_buckets_id', 'user_interests.task', 'user_interests.favourite', 'user_interests.created_at', 'user_interests.updated_at', 'user_interests.how_often', 'user_interests.how_long', 'user_interests.best_time', 'user_interests.importance', 'user_interests.task_repeat', 'ut.status', 'ut.start_time', 'ut.end_time', DB::raw("DATE_FORMAT(user_interests.created_at, '%Y-%m-%d %H:i:s') as task_date"))
                ->get();

            // Check if the user has tasks
            if ($tasks->isNotEmpty()) {
                // Store tasks with user's token and timezone
                foreach ($tasks as $task) {

                    if ($task->status == 'complete' || $task->status == 'delete') {
                        continue;
                    }

                    $task['token'] = $user->fcm_token;
                    $task['timezone'] = $user->timezone;

                    $allTasks[] = $task;
                }
            }

            
    }

    return $allTasks;
    }
    protected function prepareAndSendNotification($task)
    {
        $userTimezone = $task->timezone;
        $now = Carbon::now($userTimezone);
        $taskTime = Carbon::createFromFormat('Y-m-d H:i:s', $task->task_date, $userTimezone);
        $notificationTime = $taskTime->copy()->subMinutes(5);
        $notificationTimeDiff = $now->diffInMinutes($notificationTime, false);
        $exactTaskTimeDiff = $now->diffInMinutes($taskTime, false);

        if ($notificationTimeDiff == 0) {
            $this->sendNotification($task, 'Are you ready?', $task->task . ' in 5 mins', 'begin after 5min');
        } elseif ($exactTaskTimeDiff == 0) {
            $this->sendNotification($task, 'Time to start!', 'Press to begin', 'start');
        }
    }

    protected function sendNotification($task, $title, $message, $status)
    {
        if (!empty($task->fcm_token)) {
            $notification = [
                'title' => $title,
                'message' => $message,
                'token' => $task->fcm_token,
                'task' => $task,
                'status' => $status,
                'screen' => 'focus',
            ];

            // Here, integrate your actual notification sending logic,
            // for example, through a push notification service or an email service.
            $this->logNotification($task, $notification); // Placeholder for actual notification sending logic
        }
    }

    protected function logNotification($task, $notification)
    {
        // Placeholder method for logging or sending the notification
        // This should be replaced with actual logging or notification sending code
        echo "Notification prepared for task ID: {$task->id} with message: {$notification['message']}\n";
    }
}
