<?php

namespace App\Services;

use App\Models\CustomTask;
use App\Models\UserInterest;
use App\Models\RepeatDay;
use App\Models\CustomTaskNotificationSetting;
use App\Models\CustomNotificationReminder;
use Carbon\Carbon;
class EditCustomTaskService
{   


    public function editTask(array $data, $id)
    {   
        
        $task = UserInterest::find($id);
        $general_info = $this->updateGeneralInfo($data,$task);
        $this->handleRepeatDays($data, $task->id );

        if($data['task_type'] == 'custom'){
            $this->updateDetail($data, $task);
            $this->handleCustomTaskNotificationSound($data, $task);
            $this->handleCustomNotificationReminder($data, $task); 
        }
        
        return $general_info;
    }

  


    private function updateGeneralInfo(array $data, $task)
    {       
            $task->task = $data['task'];
            $task->sub_buckets_id = $data['sub_buckets_id' ]?? $task->sub_buckets_id;
            $task->importance = $data['importance']?? $task->importance;
            $task->task_date = $data['task_date']?? $task->task_date;
            $task->created_at = $data['task_date']?? $task->task_date;
            $task->updated_at = $data['task_date']?? $task->task_date;
            $task->best_time = $data['best_time']?? $task->best_time;
            $task->how_often = $data['how_often']?? $task->how_often;
            $task->how_long = $data['how_long']?? $task->how_long;
            $task->focus = $data['focus']  ?? $task->focus;
          
            if(isset($data['detail'])){
                $detail = $data['detail'];
                $task->notes = $detail['notes'] ?? $task->notes;
                $task->color = $detail['color'] ?? $task->color;
            }

            if($task->save()){
               return $task;
            }


    }

    private function updateDetail(array $data, $task)
    {   
        $custom = CustomTask::find($task->user_task_id);

       
        if(isset($data['detail']) && $custom){
            $detail = $data['detail'];
            $custom->notes = $detail['notes'] ?? $custom->notes;
            $custom->location = $detail['location'] ?? $custom->location;
            $custom->color = $detail['color'] ?? $custom->color;
            $custom->save();
        }
        return true;
    }

    private function handleRepeatDays(array $data, $task_id)
    {
        if($data['how_often']=='custom' && isset($data['week_days']) && !empty($data['week_days'])){

           RepeatDay::where('task_id', $task_id)->delete(); 
           return RepeatDay::storeTaskDays($task_id, $data['week_days']);

        }
    }

    private function handleCustomTaskNotificationSound(array $data, $task)
    {   
        CustomTaskNotificationSetting::where('custom_task_id', $task->user_task_id)->delete();
        if(isset($data['notification_sound']) && !empty($data['notification_sound'])){
          
            foreach ($data['notification_sound'] as $key => $data) {
    
                $data['custom_task_id'] =  $task->user_task_id;
                CustomTaskNotificationSetting::create($data);
               
            }
        }
    }


    private function handleCustomNotificationReminder(array $data, $task)
    {   
        CustomNotificationReminder::where('custom_task_id', $task->user_task_id)->delete();
        if(isset($data['notification_reminder']) && !empty($data['notification_reminder'])){

            foreach ($data['notification_reminder'] as $key => $data) {
                
                $data['custom_task_id'] = $task->user_task_id;
                CustomNotificationReminder::create($data);
               
            }
        }
    }

}
