<?php

namespace App\Services;

use App\Models\CustomTask;
use App\Models\UserInterest;
use App\Models\RepeatDay;
use App\Models\CustomTaskNotificationSetting;
use App\Models\CustomNotificationReminder;
use Carbon\Carbon;
class CustomTaskService
{   


    public function createTask(array $data, $user)
    {   
        
        // $existingTask = $this->checkExistingTask($data);
        // if($existingTask){
        //     return false;
        // }
        $customTask = $this->createCustomTask($data);
        $userInterest = $this->createUserInterest($data, $user, $customTask);
        $this->handleRepeatDays($data, $userInterest->id );
        $this->handleCustomTaskNotificationSound($data, $customTask);
        $this->handleCustomNotificationReminder($data, $customTask);
        return $customTask;
    }

    private function checkExistingTask(array $data)
    {   
        $task= CustomTask::where(
            [
                'name'=> $data['task'],
                'location' =>$data['location']??null,
                'color' =>$data['color']??null,
            ]
            )->first();


        if($task){
            return true;
        }

        return false;
       
    }


    private function createCustomTask(array $data)
    {
        $custom = new CustomTask();
        $custom->name = $data['task'];
        $custom->notes = $data['notes']??null;
        $custom->color = $data['color']??null;
        $custom->location = $data['location']??null;
        $custom->save();

        return $custom;
    }

    private function createUserInterest(array $data, $user, $customTask)
    {
        $task = new UserInterest();
        $task->user_id = $user->id;
        $task->task = $data['task'];
        $task->sub_buckets_id = $data['sub_buckets_id'];
        $task->user_task_id = $customTask->id;
        $task->user_task_type = 'App\Models\CustomTask';
        $task->importance = $data['importance'];
        $task->task_date = $data['task_date'];
        $task->best_time = $data['best_time'];
        $task->how_often = $data['how_often'];
        $task->how_long = $data['how_long'];
        $task->focus = $data['focus'];
        $task->task_repeat = $data['how_often']=='once'?'no':'yes';
        if($task->save()){
           return $task;
        }
        
        return false;



    }

    private function handleRepeatDays(array $data, $task_id)
    {
        if($data['how_often']=='custom' && isset($data['week_days']) && !empty($data['week_days'])){

           return RepeatDay::storeTaskDays($task_id, $data['week_days']);

        }
    }

    private function handleCustomTaskNotificationSound(array $data, $custom)
    {
        if(isset($data['notification_sound']) && !empty($data['notification_sound'])){

            foreach ($data['notification_sound'] as $key => $data) {
                
                $data['custom_task_id'] = $custom->id;
                CustomTaskNotificationSetting::create($data);
               
            }
        }
    }


    private function handleCustomNotificationReminder(array $data, $custom)
    {
        if(isset($data['notification_reminder']) && !empty($data['notification_reminder'])){

            foreach ($data['notification_reminder'] as $key => $data) {
                
                $data['custom_task_id'] = $custom->id;
                CustomNotificationReminder::create($data);
               
            }
        }
    }

}
