<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'user_type',
        'login_type',
        'last_login'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Get the user's interests.
     */
    public function isAdmin()
    {
        return $this->user_type == 1;
    }

    public function lastLogin()
    {
        return $this->hasOne(UserTask::class)
       // ->select(['id', 'updated_at'])
            ->latest('updated_at');
    }

    // //user tasks
    // public function userInterests()
    // {
    //     return $this->hasMany(UserInterest::class, 'user_id', 'id');
    // }

    // public function repeatDays()
    // {
    //     return $this->hasManyThrough(RepeatDay::class, UserInterest::class, 'user_id', 'task_id', 'id', 'id');
    // }

    // public function calculateTotalTasks()
    // {
    //     return $this->hasMany(UserTask::class, 'user_id', 'id')
    //          ->count();
    // }
    

    // public function calculateTotalCountPriorityTasks($priority)
    // {   
       
    //     return UserTask::join('user_interests', 'user_interests.id', '=', 'user_tasks.task_id')
    //     ->whereIn('user_interests.importance', $priority)
    //     ->where('user_tasks.user_id', $this->id)->count();

    // }

    // public function completedTasks()
    // {
    //     return $this->hasMany(UserTask::class, 'user_id', 'id')
    //         ->where('status', 'complete')
    //         ->count();
    // }
    // public function completedTasksList()
    // {
    //     return $this->hasMany(UserTask::class, 'user_id', 'id')
    //         ->where('status', 'complete');
    //         // ->get();
    // }

    // public function OnTasks()
    // {
    //     return $this->hasMany(UserTask::class, 'user_id', 'id')
    //         ->where('status', 'started')
    //         ->count();
    // }

    public function userFeedback()
    {
        return $this->hasOne(UserFeedback::class, 'user_id', 'id');
    }
}
