<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeterVisual extends Model
{
    use HasFactory;
    public $table='meter_visuals';
    public $timestamps=false;
    protected $fillable = ['global_device_id', 'auxr_status'];

    // public function getFullNameAttribute()
    // {
    //     return "{$this->first_name} {$this->last_name}";
    // }

    protected $casts = [
        'lsch_load_shedding_slabs' => 'array', // Cast the 'lsch_load_shedding_slabs' attribute to an array
    ];
     public function children()
    {
        return $this->hasMany(MeterVisual::class, 'parent_id')
         ->select('id', 'global_device_id', 'parent_id') //  Limit columns
                    ->with('children');
    }

    public function poolChildren()
{
    return $this->hasMany(MeterVisual::class, 'parent_id')
        ->select('id', 'global_device_id', 'parent_id', 'installed_on') // Make sure to include 'installed_on' in select
        ->where('installed_on', 'pool')
        ->with('children');
}


//    public function meterType() {
//        return $this->belongsTo(MeterType::class, 'meter_type_id');
//    }
//
//    public function category() {
//        return $this->belongsTo(Category::class, 'category_id');
//    }
    public function currentLogsLastHour()
    {
        return $this->hasMany(TrCurrentLog::class, 'global_device_id', 'global_device_id')
                    ->where('created_at', '>=', \Carbon\Carbon::now()->subHour());
    }

}
