<?php

namespace App\Listeners;

use App\Events\WelcomeMailProcessed;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Mail;
use App\Mail\ThankYouEmail;

class SendWelcomeEmail
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(WelcomeMailProcessed $event): void
    {
        $data = $event->data;
        Mail::to($data['email'])->send(new ThankYouEmail($data));
    }
}
