<?php
namespace App\Http\Middleware;

use Closure;
use App\Models\ApiKey;
use Illuminate\Http\Request;

class ValidateApiKey
{
    public function handle(Request $request, Closure $next)
    {
        $key = $request->privatekey;

        // Ensure the key exists and is not expired
        $apiKey = ApiKey::where('private_key', $key)
                        ->where('expires_at', '>', now())
                        ->first();

        if (!$apiKey) {
            return response()->json(['status'=>0,'message' => 'Unauthorized. PrivateKey Expired '], 401);
        }

        // Optionally, you can attach the user to the request for easier access
        // $request->user = $apiKey->user;

        return $next($request);
    }
}
