<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class TenantDatabaseSwitcher
{
    public function handle(Request $request, Closure $next)
    {
        // Skip tenant switching on public routes like GET /login
        if (
            $request->is('login') && $request->isMethod('get') ||
            $request->is('register') ||
            $request->is('password/*')
        ) {
            return $next($request);
        }

        $companyId = $request->input('company') ?? session('company_id');

        if (!$companyId) {
            // Only redirect if this is not an API/AJAX call
            return redirect('/login')->withErrors(['company' => 'Company ID is required']);
        }

        try {
            switchTenantDatabase($companyId); // your helper function
            session(['company_id' => $companyId]);
        } catch (\Exception $e) {
            return redirect('/login')->withErrors(['company' => 'Invalid company ID']);
        }

        return $next($request);
    }
}
