<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class IdentifyTenantFromRequest
{
    public function handle(Request $request, Closure $next)
    {
        // ✅ Skip tenant resolution for public routes (GET /login etc.)
        if (
            $request->is('login') && $request->isMethod('get') ||
            $request->is('/') ||
            $request->is('password/*') ||
            $request->is('register')
        ) {
            return $next($request);
        }

        // Get company ID from form or session
        $companyId = $request->input('company') ?? session('company_id');

        if (!$companyId) {
            return redirect('/login')->withErrors(['company' => 'Company ID is required']);
        }

        try {
            switchTenantDatabase($companyId); // your helper
            session(['company_id' => $companyId]);
        } catch (\Exception $e) {
            return redirect('/login')->withErrors(['company' => 'Invalid company ID']);
        }

        return $next($request);
    }
}

