<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Check if the user is logged in and has admin role
        if (auth()->check() && auth()->user()->isAdmin()) {

            return $next($request);
        }

        return response()->json(['success' => false, 'msg' => 'Unauthorized User4'], 403);
    }
}
