<?php
namespace App\Http\Controllers\Web;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\KwhReading;
use App\Models\MeterVisual;
use App\Models\Reading;

class ReadingController extends Controller
{
  
        public function index(Request $request)
        {
            $tr_data=MeterVisual::select('global_device_id')->get();
            $query = Reading::query();

            if ($request->from) {
                $fromDate = date('Y-m-d', strtotime($request->from));
                $query->where('rdate', '>=', $fromDate);
            }
            
            if ($request->to) {
                $toDate = date('Y-m-d', strtotime($request->to));
                $query->where('rdate', '<=', $toDate);
            }
            
            if ($request->DeviceId) {
                $query->where('global_device_id', $request->DeviceId);
            }
            
            $data = $query->paginate(30);
            return view('reading',compact('tr_data','data'));

        }

        public function kwh_index(Request $request)
        {
            $tr_data=MeterVisual::select('global_device_id')->get();
            $query = KwhReading::query();

            if ($request->from) {
                $fromDate = date('Y-m-d', strtotime($request->from));
                $query->where('created_at', '>=', $fromDate);
            }
            
            if ($request->to) {
                $toDate = date('Y-m-d', strtotime($request->to));
                $query->where('created_at', '<=', $toDate);
            }
            
            if ($request->DeviceId) {
                $query->where('global_device_id', $request->DeviceId);
            }
            
            $data = $query->paginate(30);
            return view('kwh_reading',compact('tr_data','data'));

        }


        public function load_form()
        {
            $tr_data=MeterVisual::select('global_device_id')->get();
            return view('reading_insert',compact('tr_data'));

        }

        public function load_kwh_form()
        {
            $tr_data=MeterVisual::select('global_device_id')->get();
            return view('kwh_reading_insert',compact('tr_data'));

        }
        public function kwh_store(Request $request)
        {
            // dd($request->all());
            // Validate the incoming request
            $validated = $request->validate([
                'DeviceId'     => 'required|string', // GID
                'readingDate'  => 'required|date',
                'pesco_total_kwho'           => 'required|numeric',
                'pesco_total_kwhp'           => 'required|numeric',
                'total_kwho'           => 'required|numeric',
                'total_kwhp'           => 'required|numeric'
                
            ]);
            // dd($request->file());

            $reading = new KwhReading();
            if($request->hasFile('pesco_images')) {
                
                $filenamepesoc=[];
                foreach ($request->file('pesco_images') as $file) {
                    $filenamepesoc[] = $file->store('pesco_images', 'public');
                    // Save $filename to database if needed
                }
                $reading->pesco_images=json_encode($filenamepesoc);
            }
            
            if($request->hasFile('cisnr_images')) {
                $filename=[];
                foreach ($request->file('cisnr_images') as $file) {
                    $filename[] = $file->store('cisnr_images', 'public');
                    // Save $filename to database if needed
                }
                $reading->cisnr_images=json_encode($filename);
            }



            // Store the validated data in the database
            $reading->global_device_id = $validated['DeviceId'];
            $reading->rdate = date('Y-m-d', strtotime($validated['readingDate']));
            $reading->pesco_total_kwho = $validated['pesco_total_kwho'];
            $reading->pesco_total_kwhp = $validated['pesco_total_kwhp'];
            $reading->total_kwho = $validated['total_kwho'];
            $reading->total_kwhp = $validated['total_kwhp'];
            $reading->save();

            return redirect()->back()->with('success', 'Record Insert successfully!');
        }
        public function store(Request $request)
        {
            // Validate the incoming request
            $v = $request->validate([
                'DeviceId'     => 'required|string', // GID
                'readingDate'  => 'required|date',
                'pv1'           => 'required|numeric',
                'pv2'           => 'required|numeric',
                'pv3'           => 'required|numeric',
                'pi1'           => 'required|numeric',
                'pi2'           => 'required|numeric',
                'pi3'           => 'required|numeric',
                'ppf1'          => 'required|numeric',
                'ppf2'          => 'required|numeric',
                'ppf3'          => 'required|numeric',

                'cv1'           => 'required|numeric',
                'cv2'           => 'required|numeric',
                'cv3'           => 'required|numeric',
                'ci1'           => 'required|numeric',
                'ci2'           => 'required|numeric',
                'ci3'           => 'required|numeric',
                'cpf1'          => 'required|numeric',
                'cpf2'          => 'required|numeric',
                'cpf3'          => 'required|numeric',


            ]);

            // Store the v data in the database
            $r = new Reading();
            $r->global_device_id = $v['DeviceId'];
            $r->rdate = date('Y-m-d', strtotime($v['readingDate']));
            $r->pv1 = $v['pv1'];
            $r->pv2 = $v['pv2'];
            $r->pv3 = $v['pv3'];
            $r->pi1 = $v['pi1'];
            $r->pi2 = $v['pi2'];
            $r->pi3 = $v['pi3'];
            $r->ppf1 = $v['ppf1'];
            $r->ppf2 = $v['ppf2'];
            $r->ppf3 = $v['ppf3'];

            $r->cv1 = $v['cv1'];
            $r->cv2 = $v['cv2'];
            $r->cv3 = $v['cv3'];
            $r->ci1 = $v['ci1'];
            $r->ci2 = $v['ci2'];
            $r->ci3 = $v['ci3'];
            $r->cpf1 = $v['cpf1'];
            $r->cpf2 = $v['cpf2'];
            $r->cpf3 = $v['cpf3'];


            $r->save();

            return redirect()->back()->with('success', 'Record Insert successfully!');
        }

    


}
