<?php
namespace App\Http\Controllers\Web;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BinaryDataController extends Controller
{
    /**
     * Send a specific chunk of binary data from a file.
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */
    // public function sendBinaryChunk(Request $request)
    // {
    //     // file_put_contents(public_path('firmware/firmware.bin'), random_bytes(46202848));
    //     // die('file created');
    //     // Define the path to the binary file in the public/firmware directory
    //     $filePath = public_path('firmware/firmware.bin');

    //     // Check if the file exists
    //     if (!file_exists($filePath)) {
    //         return response()->json(['error' => 'File not found'], 404);
    //     }

    //     // Read the binary data from the file
    //     $binaryData = file_get_contents($filePath);

    //     // Get the size of the binary data
    //     $fileSize = strlen($binaryData);

    //     // Check if the file is empty
    //     if ($fileSize === 0) {
    //         return response()->json(['error' => 'File is empty'], 400);
    //     }

    //     // Define chunk size (e.g., 2 MB)
    //     $chunkSize = 2 * 1024 * 1024;

    //     // Calculate the number of chunks needed
    //     $numberOfChunks = ceil($fileSize / $chunkSize);

    //     // Get the requested chunk number from the request
    //     $chunkNumber = (int) $request->input('chunk', 0);

    //     // Validate the requested chunk number
    //     if ($chunkNumber < 0 || $chunkNumber >= $numberOfChunks) {
    //         return response()->json(['error' => 'Invalid chunk number'], 400);
    //     }

    //     // Calculate the offset and size for the requested chunk
    //     $offset = $chunkNumber * $chunkSize;
    //     $currentChunkSize = min($chunkSize, $fileSize - $offset);

    //     // Extract the requested chunk of data
    //     $chunkData = substr($binaryData, $offset, $currentChunkSize);

    //     // Encode the chunk data to base64
    //     $encodedData = base64_encode($chunkData);

    //     // Return the metadata and the encoded chunk data
    //     return response()->json([
    //         'file_size' => $fileSize,
    //         'number_of_chunks' => $numberOfChunks,
    //         'chunk_number' => $chunkNumber,
    //         'data' => $encodedData
    //     ]);
    // }
 
        // public function sendBinaryChunk(Request $request)
            public function sendBinaryChunk(Request $request)
            {
                $filePath = public_path('firmware/app.txt'); // Path to your binary file
                
                if (!file_exists($filePath)) {
                    return response()->json(['error' => 'File not found'], 404);
                }
        
                // Read the binary data from the file
                $binaryData = file_get_contents($filePath);
                $length = strlen($binaryData);
                
                // Each chunk will contain 512 uint32_t values, which is 2048 bytes
                $chunkSize = 512; // Number of uint32_t values per chunk
                $bytesPerChunk = $chunkSize * 4; // 2048 bytes per chunk
                
                $numberOfChunks = ceil($length / $bytesPerChunk); // Total number of chunks
                $chunkNumber = (int) $request->input('chunk', 0);
        
                // Validate the requested chunk number
                if ($chunkNumber < 0 || $chunkNumber >= $numberOfChunks) {
                    return response()->json(['error' => 'Invalid chunk number'], 400);
                }
        
                $offset = $chunkNumber * $bytesPerChunk; // Offset in bytes
                $currentChunkSize = min($bytesPerChunk, $length - $offset); // Current chunk size in bytes
                $chunkData = substr($binaryData, $offset, $currentChunkSize);
        
                // Unpack the chunk data into uint32_t values
                $uint32Array = [];
                for ($i = 0; $i < strlen($chunkData); $i += 4) {
                    if ($i + 4 <= strlen($chunkData)) {
                        $uint32Value = unpack("V", substr($chunkData, $i, 4))[1]; // Unpack as unsigned int
                        $uint32Array[] = $uint32Value;
                    }
                }
        
                // Limit the returned data to the first 512 values
                $uint32Array = array_slice($uint32Array, 0, 512);
                
                // Count of uint32_t values in the array
                $arraySize = count($uint32Array);
        
                return response()->json([
                    'size' => $arraySize, // Number of uint32_t values returned
                    'chunk_number' => $chunkNumber,
                    'data' => $uint32Array,
                ]);

            }
    


}
