<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function userList()
    {
        if(auth()->user()->ugroups!='admin')
            $data=User::where('company_id',auth()->user()->company_id)->get();
        else
            $data=User::get();
        return view('list_user',compact('data'));
    }

    public function addUserForm()
    {
        $company=DB::table('companys')->get();
        return view('add_user_form',compact('company'));
    }

    public function editUserForm($id)
    {
        $company=DB::table('companys')->get();
        $data=User::where('id',$id)->first();
        // dd($data);
        return view('edit_user_form',compact('data','company'));
    }

    public function editUser(Request $request,$id)
    {

        $request->validate([
            'name' => 'required|string|max:255',
            'status' => 'required',
            'email' => 'required|email|unique:users,email',
            // 'password' => 'required|string|min:8|confirmed', // Optional for password confirmation
            // 'role' => 'required|in:company_admin,company_user',
        ]);
        // return redirect()->back()->with('error', 'Email Already Exits');
        $m=User::find($id);
        $m-> name = $request->name;
        $m->email = $request->email;
        //    $m->password = $request->password;
        if($request->password)
        {
            $m->password = Hash::make($request->password);

        }
        if(auth()->user()->ugroups!='admin')
            $m->company_id=auth()->user()->company_id;
        else
            $m->company_id = $request->company;

        $m->status = $request->status;
        $app_access=[];
        if($request->phase1)
            $app_access[]=$request->phase1;
        if($request->phase3)
            $app_access[]=$request->phase3;

        $m->ugroups = 'company';
        $m->app_access=json_encode($app_access);
        $m->save();



        return redirect()->back()->with('success', 'Action Completed');

    }
    public function addUserNew(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            // 'company' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|min:8|confirmed', // Optional for password confirmation
            // 'role' => 'required|in:company_admin,company_user',
        ]);
        $dev= User::where('email',$request->email)->first();
        if($dev)
            return redirect()->back()->with('error', 'Email Already Exits');

        $m=new User();
        $m-> name = $request->name;
        $m->email = $request->email;
        //    $m->password = $request->password;
        $m->password = Hash::make($request->password);
        if(auth()->user()->ugroups!='admin')
            $m->company_id=auth()->user()->company_id;
        else
            $m->company_id = $request->company;

        $m->status = $request->status;
        $app_access=[];
        if($request->phase1)
            $app_access[]=$request->phase1;
        if($request->phase3)
            $app_access[]=$request->phase3;

        $m->ugroups = 'company';
        $m->app_access=json_encode($app_access);
        $m->save();
        //    $rec= new Transformer();
        //    $rec-> trid = $request->dev_id;
        //    $rec-> name = $request->tname;

        //    $rec-> kva_capacity= $request->capacity  ;
        // //    $rec-> = $request->location
        //    $rec->LT_flag = $request->LTC;
        //    $rec->ltlength = $request->length;
        //    $rec->cresistance = $request->CResistance;


        //    $rec->longitude = $request->long;
        //    $rec->latitude = $request->lat;
        //    $rec->description = $request->description;
        //    $rec->offpeak = $request->offpk;
        //    $rec->peak = $request->pk;
        //    $rec->sim_no = $request->simno;
        //    $rec->save();
        return redirect()->back()->with('success', 'Action Completed');
        // }
        // else
        // {
        //     return redirect()->back()->with('error', 'Data Missing');
        // }
        // }
        // else{
        //     return redirect()->back()->with('error', 'Global Id Missing');
        // }
    }

}
