<?php

namespace App\Http\Controllers;

use App\Models\AutoSwitching;
use App\Models\BillingData;
use App\Models\Dbbox;
use App\Models\DeviceConfiguration;
use App\Models\DeviceThreshold;
use App\Models\Event;
use App\Models\Feeder;
use App\Models\KwhReading;
use App\Models\LoadProfileData;
use App\Models\MeterVisual;
use App\Models\RawTransLog;
use App\Models\Reading;
use App\Models\Transformer;
use App\Models\TrappingEventSetting;
use App\Models\TrCurrentLog;
use App\Models\TrKwhLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    // public function index()
    // {
    //     // dd(auth()->user());
    //     $data['t_trans']=MeterVisual::count();
    //     $data['i_trans']=MeterVisual::where('auxr_status',1)->count();
    //     $data['o_trans']=MeterVisual::where('auxr_status',0)->count();
    //     return view('home',compact('data'));
    // }



    // public function dataList()
    // {
    //     $data=MeterVisual::get();
    //     return view('list',compact('data'));
    // }

    // public function getCofiguration($id)
    // {
    //     $data=DeviceConfiguration::where('global_device_id',$id)->first();
    //     return response()->json($data);
    // }







    // public function dataItem($id)
    // {
    //     $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
    //     // $graph_data=LoadProfileData::get();
    //     // dd($data);

    //     return view('single-item-chart',compact('data'));
    // }

    // public function ItemRealTimeData($id)
    // {
    //     $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
    //     $graph_data=DB::table('tr_current_logs')->where('global_device_id',$id)->orderBy('id','desc')->limit(10)->get();
    //     // $graph_data=LoadProfileData::get();
    //     // dd($data);

    //     return view('single-item-real-time-data',compact('data','graph_data'));
    // }

    // public function itemGraphDataAjax($id,$time=0)
    // {
    //     // dd('testing');
    //     // $data=MeterVisual::find($id);
    //     $graph_data=RawTransLog::select('server_date_time','i_red as ca','i_blue as cb','i_yellow as cc','v_red as va','v_blue as vb' ,'v_yellow as vc')->where('moduleid',$id);
    //     // echo(json_encode($graph_data));
    //     // die;
    //     if($time !=0){
    //         if ($time == 'lh') {
    //             // Filter records from the last hour
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subHour());
    //         }

    //         if ($time == 'l24h') {
    //             // Filter records from the last 24 hours
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subDay());
    //         }

    //         if ($time == 'lw') {
    //             // Filter records from the last week
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subWeek());
    //         }

    //         if ($time == 'lm') {
    //             // Filter records from the last month
    //             $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subMonth());
    //         }

    //         // if ($time == 'c') {
    //             //     // Custom filter logic, for example:
    //                 //     // You might need to define start and end dates based on user input or other criteria
    //                 //     // Here we assume a custom range for demonstration purposes
    //                 //     $start_date = '2024-01-01 00:00:00'; // Example start date
    //                 //     $end_date = '2024-01-31 23:59:59'; // Example end date
    //                 //     $graph_data = $graph_data->whereBetween('db_datetime', [$start_date, $end_date]);
    //                 // }

    //             }
    //     $graph=$graph_data->get();
    //     // pr($graph);
    //     return result(1,'',$graph);
    //     // dd($data);

    //     // return view('single-item-chart',compact('data'));
    // }
                private function buildHierarchyWithLogs($node)
            {
                // Get logs for this node
                $logs = DB::table('tr_current_logs')
                        ->where('global_device_id', $node->global_device_id)
                        ->orderBy('stime','Desc')
                        ->first();

                // Recursively process children
                $children = $node->children->map(function ($child) {
                    return $this->buildHierarchyWithLogs($child);
                });

                return [
                    'id' => $node->id,
                    'global_device_id' => $node->global_device_id,
                    'logs' => $logs,
                    'children' => $children,
                ];
            }

            // Helper for recursive eager loading string
            private function recursiveChildrenString($depth = 5)
            {
                return implode('.', array_fill(0, $depth, 'children'));
            }

    // public function technicalReportForm(Request $request)
    // {

    //         $tr_data=MeterVisual::where('installed_on','transformer')->select('global_device_id','installed_on')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->with('children')
    //                             ->first();

    //                         if (!$transformer) {
    //                             return response()->json(['error' => 'Transformer not found'], 404);
    //                         }

    //                         $transformer->load($this->recursiveChildrenString(6)); // load deep children

    //                         $data = $this->buildHierarchyWithLogs($transformer);

    //                             // dd($data);

    //                             if($data )
    //                             {

    //                                 $logs=$data['logs'];


    //                                 if($data && $data['children'] )
    //                                 {

    //                                     foreach($data['children'] as $row)
    //                                     {
    //                                         if($row && $row['children'] )
    //                                         {
    //                                             foreach($row['children'] as $childrow)
    //                                             {
    //                                                 $grow=[];
    //                                                         $logs2=$childrow['logs'];
    //                                                         $logs2->stime;
    //                                                         $grow['stime']=$logs2->stime;
    //                                                         $grow['parent_id']=$logs->global_device_id;
    //                                                         // $logs->global_device_id;
    //                                                         $grow['child_id']=$logs2->global_device_id;
    //                                                         $grow['v1_difference']=$logs2->v1-$logs->v1;
    //                                                         $grow['v2_difference']=$logs2->v2-$logs->v2;
    //                                                         $grow['v3_difference']=$logs2->v3-$logs->v3;

    //                                                         $graph_data[]=$grow;
    //                                                     }
    //                                                 }



    //                                             }
    //                                         }


    //                             }

    //                 }
    //                 // dd($graph_data);


    //     return view('technicalReportView',compact('data','tr_data','graph_data'));
    // }
    public function technicalReportForm(Request $request)
    {
        $graph_data = [];

        // Step 0: Get target date (required)
        // $targetDate = $request->input('date');
        $targetDate='2025-06-25';

        if (!$targetDate) {
            return response()->json(['error' => 'Please provide a valid date (e.g., ?date=2025-06-25)'], 400);
        }

        // Step 1: Load transformers
        $transformers = MeterVisual::select('id', 'global_device_id', 'installed_on', 'category', 'parent_id')
            ->where('installed_on', '!=', 'normal')
            ->get();

        if ($transformers->isEmpty()) {
            return response()->json(['error' => 'Transformer not found'], 404);
        }

        // Filter transformers (installed_on = transformer, category = STDB)
        $t_collection = $transformers->where('installed_on', 'transformer')
                                     ->where('category', 'STDB');

        // Load pool meters
        $transformerIds = $t_collection->pluck('id')->toArray();
        $transformerDeviceIds = $t_collection->pluck('global_device_id')->toArray();

        $poolMeters = $transformers->where('installed_on', 'pole');
        $poolDeviceIds = $poolMeters->pluck('global_device_id')->toArray();

        // Step 2: Load all logs for the given date
        $allDeviceIds = array_merge($transformerDeviceIds, $poolDeviceIds);

        $logsByDevice = DB::table('tr_current_logs')
            ->whereIn('global_device_id', $allDeviceIds)
            ->whereDate('stime', $targetDate)
            ->select('global_device_id', 'v1', 'v2', 'v3')
            ->get()
            ->groupBy('global_device_id');

        // Step 3: Compute averages and compare
        $graph_data2 = [];

        foreach ($t_collection as $transformer) {
            $t_logs = $logsByDevice[$transformer->global_device_id] ?? collect();

            if ($t_logs->isEmpty()) continue;

            // Average transformer log
            $t_v1 = $t_logs->avg('v1');
            $t_v2 = $t_logs->avg('v2');
            $t_v3 = $t_logs->avg('v3');

            $v1_list = [];
            $v2_list = [];
            $v3_list = [];

            // Get child pool meters
            $children = $poolMeters->where('parent_id', $transformer->id);

            foreach ($children as $child) {
                $c_logs = $logsByDevice[$child->global_device_id] ?? collect();

                if ($c_logs->isEmpty()) continue;

                $v1_list[] = $c_logs->avg('v1') ?? 0;
                $v2_list[] = $c_logs->avg('v2') ?? 0;
                $v3_list[] = $c_logs->avg('v3') ?? 0;
            }

            $avg_v1 = count($v1_list) ? array_sum($v1_list) / count($v1_list) : 0;
            $avg_v2 = count($v2_list) ? array_sum($v2_list) / count($v2_list) : 0;
            $avg_v3 = count($v3_list) ? array_sum($v3_list) / count($v3_list) : 0;

            $graph_data2[] = (object)[
                'global_device_id' => $transformer->global_device_id,
                'v1_loss' => $avg_v1 ? abs($t_v1 - $avg_v1) : 0,
                'v2_loss' => $avg_v2 ? abs($t_v2 - $avg_v2) : 0,
                'v3_loss' => $avg_v3 ? abs($t_v3 - $avg_v3) : 0,
            ];
        }
        // echo "<pre>";
        // print_r($graph_data2);
        // die;


        return view('technicalReportView', compact('graph_data', 'graph_data2'));
    }

    public function commercialReportForm(Request $request)
{
    // Fetch all transformers with category STDB installed on transformer
    $transformers = MeterVisual::select('id', 'global_device_id')
                    ->where('installed_on', 'transformer')
                    ->where('category', 'STDB')
                    ->get();

    if ($transformers->isEmpty()) {
        return response()->json(['error' => 'Transformer not found'], 404);
    }

    // Get all transformer global_device_ids
    $transformerGlobalIds = $transformers->pluck('global_device_id')->toArray();

    // Fetch all child devices related to these transformers
    $childDevices = MeterVisual::where('installed_on', 'normal')
                    ->where('category', 'NOR')
                    ->whereIn('parent_id', $transformers->pluck('id'))
                    ->select('id', 'global_device_id', 'parent_id')
                    ->get();

    // Collect all global_device_ids for latest logs query (transformers + children)
    $allGlobalDeviceIds = array_merge($transformerGlobalIds, $childDevices->pluck('global_device_id')->toArray());

    if (empty($allGlobalDeviceIds)) {
        // No devices found, return empty data
        return view('commercialReportView', ['graph_data' => [], 'graph_data2' => []]);
    }

    // Fetch latest logs for all these devices using a single query
    $placeholders = implode(',', array_fill(0, count($allGlobalDeviceIds), '?'));

    $latestLogsQuery = "
        SELECT logs.v1, logs.v2, logs.v3, logs.i1, logs.i2, logs.i3, logs.stime, logs.global_device_id
        FROM tr_current_logs AS logs
        INNER JOIN (
            SELECT global_device_id, MAX(stime) AS max_stime
            FROM tr_current_logs
            WHERE global_device_id IN ($placeholders)
            GROUP BY global_device_id
        ) AS max_logs
        ON logs.global_device_id = max_logs.global_device_id AND logs.stime = max_logs.max_stime
    ";

    $latestLogsRaw = DB::select($latestLogsQuery, $allGlobalDeviceIds);

    // Key the logs collection by global_device_id for fast access
    $latestLogs = collect($latestLogsRaw)->keyBy('global_device_id');

    $graph_data2 = [];

    // Process each transformer
    foreach ($transformers as $transformer) {
        $lg1 = $latestLogs->get($transformer->global_device_id);

        $i1_list = [];
        $i2_list = [];
        $i3_list = [];

        // Get child devices for this transformer
        $children = $childDevices->where('parent_id', $transformer->id);

        foreach ($children as $child) {
            $lg2 = $latestLogs->get($child->global_device_id);
            if ($lg2) {
                if (preg_match('/CN(\d+)$/', $child->global_device_id, $matches)) {
                    $cnNumber = (int)$matches[1];
                    $phase = $cnNumber % 3;
                    if ($phase == 1) {
                        $i1_list[] = $lg2->i1 ?? 0;
                    } elseif ($phase == 2) {
                        $i2_list[] = $lg2->i2 ?? 0;
                    } else {
                        $i3_list[] = $lg2->i3 ?? 0;
                    }
                }
            }
        }

        $sum_i1 = count($i1_list) ? array_sum($i1_list) : 0;
        $sum_i2 = count($i2_list) ? array_sum($i2_list) : 0;
        $sum_i3 = count($i3_list) ? array_sum($i3_list) : 0;

        if ($lg1) {
            $graph_data2[] = (object)[
                'global_device_id' => $transformer->global_device_id,
                'i1' => $sum_i1 !== 0 ? abs($lg1->i1 - $sum_i1) : 0,
                'i2' => $sum_i2 !== 0 ? abs($lg1->i2 - $sum_i2) : 0,
                'i3' => $sum_i3 !== 0 ? abs($lg1->i3 - $sum_i3) : 0,
            ];
        }
    }

    // Return the view with data
    return view('commercialReportView', compact('graph_data2'))->with('graph_data', []);
}

    public function deviceTree(Request $request)
    {
        //Device Hierarchy Graph

        $data['tree'] = MeterVisual::whereNull('parent_id')
        ->select('id', 'global_device_id', 'parent_id')
        ->with('children')
        ->get();
        // dd($data['tree'][0]);


        return view('devicetreeReport',compact('data'));
    }
    public function mannualReading(Request $request)
    {
        //Device Hierarchy Graph

        $deviceId = 'TR01'; // or get this from a request input

        $readings = \App\Models\KwhReading::where('global_device_id', $deviceId)
            ->orderBy('rdate')
            ->get();

        $kwhpDiffs = [];
        $kwhoDiffs = [];

        for ($i = 1; $i < $readings->count(); $i++) {
            $prev = $readings[$i - 1];
            $curr = $readings[$i];

            $kwhpDiffs[] = [
                'rdate' => $curr->rdate,
                'pesco_diff' => $curr->pesco_total_kwhp - $prev->pesco_total_kwhp,
                'cisnr_diff' => $curr->total_kwhp - $prev->total_kwhp,
            ];

            $kwhoDiffs[] = [
                'rdate' => $curr->rdate,
                'pesco_diff' => $curr->pesco_total_kwho - $prev->pesco_total_kwho,
                'cisnr_diff' => $curr->total_kwho - $prev->total_kwho,
            ];
        }


        $readings = Reading::select('rdate',
        'pv1', 'pv2', 'pv3', 'cv1', 'cv2', 'cv3',
        'pi1', 'pi2', 'pi3', 'ci1', 'ci2', 'ci3'
        )->orderBy('rdate')->get();



        return view('mannualReadingReport',compact('readings','kwhpDiffs', 'kwhoDiffs','deviceId'));
    }


    // public function technicalReportForm(Request $request)
    // {
    //     $tr_data=MeterVisual::select('global_device_id')->get();


    //         $data = [];

    //         if ($request->DeviceId) {
    //             $meter_data=MeterVisual::select('global_device_id',$request->DeviceId)->first();

    //             $data = DB::table('tr_current_logs')
    //             ->select('tr_current_logs.*')
    //             ->where('tr_current_logs.global_device_id',$request->DeviceId)
    //             ->orderBy('tr_current_logs.stime', 'DESC');

    //             $results = DB::table('tr_current_logs')
    //             ->join('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
    //             ->select('tr_current_logs.*', 'meter_visuals.meter_name') // customize columns as needed
    //             ->get();
    //         }

    //         if ($request->from) {
    //             $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
    //             $data = $data->where('tr_current_logs.stime', '>=', $fromDate);
    //             }

    //         if ($request->to) {
    //         $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
    //         $data = $data->where('tr_current_logs.stime', '<=', $toDate);
    //         }

    //         if ($request->DeviceId) {
    //         $data = $data->where('tr_current_logs.global_device_id', $request->DeviceId);
    //         }
    //         // dd($data);

    //         if($request->from || $request->to )
    //           $data = $data->limit(30)->get();
    //         else
    //         {
    //             if (!empty($data) )
    //             $data = $data->limit(500)->get();
    //         }
    //         // }



    //     return view('technicalReportView',compact('data','tr_data'));
    // }
    // public function commercialReportForm(Request $request)
    // {

    //         $tr_data=MeterVisual::where('installed_on','transformer')->select('global_device_id','installed_on')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->with('children')
    //                             ->first();

    //                         if (!$transformer) {
    //                             return response()->json(['error' => 'Transformer not found'], 404);
    //                         }

    //                         $transformer->load($this->recursiveChildrenString(6)); // load deep children

    //                         $data = $this->buildHierarchyWithLogs($transformer);

    //                             // dd($data);

    //                             if($data )
    //                             {

    //                                 $logs=$data['logs'];


    //                                 if($data && $data['children'] )
    //                                 {

    //                                     foreach($data['children'] as $row)
    //                                     {
    //                                         if($row && $row['children'] )
    //                                         {
    //                                             foreach($row['children'] as $childrow)
    //                                             {
    //                                                 $grow=[];
    //                                                         $logs2=$childrow['logs'];
    //                                                         $logs2->stime;
    //                                                         $grow['stime']=$logs2->stime;
    //                                                         $grow['parent_id']=$logs->global_device_id;
    //                                                         // $logs->global_device_id;
    //                                                         $grow['child_id']=$logs2->global_device_id;
    //                                                         $grow['i1_difference']=abs($logs2->i1-$logs->i1);
    //                                                         $grow['i2_difference']=abs($logs2->i2-$logs->i2);
    //                                                         $grow['i3_difference']=abs($logs2->i3-$logs->i3);

    //                                                         $graph_data[]=$grow;
    //                                                     }
    //                                                 }



    //                                             }
    //                                         }


    //                             }

    //                 }
    //                 // dd($graph_data);


    //     return view('commercialReportView',compact('data','tr_data','graph_data'));
    // }

    // public function deviceGraphs(Request $request)
    // {

    //         $tr_data=MeterVisual::select('global_device_id')->get();
    //         $data = [];
    //         $graph_data=[];
    //                         if ($request->DeviceId) {
    //                             // Get transformer meter info
    //                             $transformer = MeterVisual::where('global_device_id', $request->DeviceId)
    //                             ->first();
    //                             if (!$transformer) {
    //                                 return response()->json(['error' => 'Transformer not found'], 404);
    //                             }


    //                             $graph_data = TrCurrentLog::where('global_device_id', $request->DeviceId)
    //                                                         ->orderBy('stime','desc')->get();







    //                 }
    //                 // dd($graph_data);


    //     return view('deviceGraphReport',compact('data','tr_data','graph_data'));
    // }


    public function deviceList(Request $request)
    {
        $paginate_count = 500;

        // Fetch ONLY top-level devices (parent_id = null)
        $query = MeterVisual::select('id', 'global_device_id', 'parent_id', 'latitude', 'longitude', 'installed_on', 'dmdt_bidirectional_device', 'dmdt_phase', 'category')
            ->whereNull('parent_id')
            ->with([
                'children' => function ($q) {
                    $q->select('id', 'global_device_id', 'parent_id', 'latitude', 'longitude', 'installed_on', 'dmdt_bidirectional_device', 'dmdt_phase', 'category');
                }
            ]);



        if ($request->has('search')) {
            $search = $request->input('search');

            $query->where(function ($q) use ($search) {
                $q->where('global_device_id', 'LIKE', '%' . $search . '%')
                    ->orWhereHas('children', function ($childQuery) use ($search) {
                        $childQuery->where('global_device_id', 'LIKE', '%' . $search . '%');
                    });
            });
        }

        $devices = $query->orderBy('id')->get();

        return view('reports.device_list_report', compact('devices'));
    }




    public function deviceDistance(Request $request)
    {
        $paginate_count = 500;
        $query = MeterVisual::where('installed_on', 'transformer') // Only top-level transformers
        ->with(['children' => function ($q) {
            $q->whereIn('installed_on', ['transfer', 'pole'])  // Only fetch pools or transfer children
            ->select('id', 'global_device_id', 'parent_id', 'latitude', 'longitude', 'installed_on');
        }]);

        // Optional search
        if ($request->has('search')) {
            $search = $request->input('search');

            $query->where(function ($q) use ($search) {
                $q->where('global_device_id', 'LIKE', '%' . $search . '%') // Search in parent
                ->orWhereHas('children', function ($childQuery) use ($search) {
                    $childQuery->where('global_device_id', 'LIKE', '%' . $search . '%'); // Search in children
                });
            });
        }

        $devices = $query->orderBy('id')->get();

        return view('reports.device_distance_report', compact('devices'));
    }

    public function unresponsiveDevices(Request $request)
    {
        $paginate_count = 50;
        $query = MeterVisual::query();

        // Handle the search functionality
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where('global_device_id', 'LIKE', '%' . $search . '%');
        }
        $devices=$query->orderBy('id')->paginate($paginate_count);
        return view('reports.device_unresponsive_report', compact('devices'));
    }


    public function neutralLosses(Request $request)
    {
        $query = MeterVisual::where('installed_on', 'transformer') // Only top-level transformers
        ->with(['children' => function ($q) {
            $q->whereIn('installed_on', ['transfer', 'pole'])  // Only fetch pool or transfer children
            ->select('id', 'global_device_id', 'parent_id', 'latitude', 'longitude', 'installed_on');
        }])
            ->join(DB::raw('(
        SELECT t1.global_device_id, t1.nc
        FROM tr_current_logs AS t1
        WHERE t1.dtime = (
            SELECT MAX(t2.dtime)
            FROM tr_current_logs t2
            WHERE t2.global_device_id = t1.global_device_id
        )
    ) AS latest_logs'), 'meter_visuals.global_device_id', '=', 'latest_logs.global_device_id')
            ->select('meter_visuals.*', 'latest_logs.nc');


        // Optional search
        if ($request->has('search')) {
            $search = $request->input('search');

            if ($request->has('search')) {
                $search = $request->input('search');
                $query->where('meter_visuals.global_device_id', 'LIKE', '%' . $search . '%');
            }
        }
        $devices = $query->orderBy('id')->get();

        return view('reports.neutrallosses', compact('devices'));
    }
    public function neutralCurrentLossGraph (Request $request)
    {
        $query = MeterVisual::where('installed_on', 'transformer') // Only top-level transformers
        ->with(['children' => function ($q) {
            $q->whereIn('installed_on', ['transfer', 'pole'])  // Only fetch pool or transfer children
            ->select('id', 'global_device_id', 'parent_id', 'latitude', 'longitude', 'installed_on');
        }])
            ->join(DB::raw('(
        SELECT t1.global_device_id, t1.nc
        FROM tr_current_logs AS t1
        WHERE t1.dtime = (
            SELECT MAX(t2.dtime)
            FROM tr_current_logs t2
            WHERE t2.global_device_id = t1.global_device_id
        )
    ) AS latest_logs'), 'meter_visuals.global_device_id', '=', 'latest_logs.global_device_id')
            ->select('meter_visuals.*', 'latest_logs.nc');


        // Optional search
        if ($request->has('search')) {
            $search = $request->input('search');

            if ($request->has('search')) {
                $search = $request->input('search');
                $query->where('meter_visuals.global_device_id', 'LIKE', '%' . $search . '%');
            }
        }
        $devices = $query->orderBy('id')->get();

        return view('reports.neutralcurrentlossesgraph', compact('devices'));
    }


    public function deviceGraphs(Request $request)
    {
        $deviceId = $request->input('DeviceId');
        $range = $request->input('range', 'last_hour'); // default to last_hour

        $graph_data = collect();

        if ($deviceId) {
            $query = DB::table('tr_current_logs')
                ->join('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
                ->where('tr_current_logs.global_device_id', $deviceId);

            // Determine time filter and group by expression
            switch ($range) {
                case 'last_hour':
                    $from = now()->subHour();
                    $groupBy = 'FROM_UNIXTIME(FLOOR(UNIX_TIMESTAMP(tr_current_logs.stime) / 300) * 300)'; // 5-minute intervals
                    break;

                case 'last_day':
                    $from = now()->subDay();
                    $groupBy = 'FROM_UNIXTIME(FLOOR(UNIX_TIMESTAMP(tr_current_logs.stime) / 900) * 900)'; // 15-minute intervals
                    break;

                case 'last_week':
                    $from = now()->subWeek();
                    $groupBy = 'DATE(tr_current_logs.stime)';
                    break;

                case 'last_month':
                    $from = now()->subMonth();
                    $groupBy = 'CONCAT(YEAR(tr_current_logs.stime), "-W", LPAD(WEEK(tr_current_logs.stime, 1), 2, "0"))';
                    break;

                case 'last_year':
                    $from = now()->subYear();
                    $groupBy = 'CONCAT(YEAR(tr_current_logs.stime), "-", LPAD(MONTH(tr_current_logs.stime), 2, "0"))';
                    break;


                default:
                    $from = now()->subDay();
                    $groupBy = 'DATE_FORMAT(tr_current_logs.stime, "%Y-%m-%d %H:00:00")';
            }

            $query->where('tr_current_logs.stime', '>=', $from)
                ->selectRaw("
                    {$groupBy} as stime,
                    AVG(tr_current_logs.v1) as v1, AVG(tr_current_logs.v2) as v2, AVG(tr_current_logs.v3) as v3,
                    AVG(tr_current_logs.i1) as i1, AVG(tr_current_logs.i2) as i2, AVG(tr_current_logs.i3) as i3,
                    AVG(tr_current_logs.nc) as ncl,
                    MAX(meter_visuals.dmdt_phase) as dmdt_phase
                ")
                ->groupByRaw($groupBy)
                ->orderBy('stime', 'desc');

            $graph_data = $query->get();
        }

        // Get device list for dropdown
        $tr_data = MeterVisual::select('global_device_id')->get();

        return view('deviceGraphReport', compact('graph_data', 'tr_data', 'range'));
    }







    public function timeDomainGraph(Request $request)
    {
        $deviceId = $request->input('DeviceId');
        $channelGroup = $request->input('channelGroup');

        $graph_data = collect();

        // Only fetch graph data if deviceId is provided
        if ($deviceId) {
            $graph_data = DB::table('time_domain_graph_data')
            ->where('device_id', $deviceId)
            ->orderBy('id')
            ->get()
            ->groupBy('channel_group');

        }


        // get device list for the dropdown
        $tr_data=MeterVisual::select('global_device_id')->get(); // replace with actual device table


        return view('timeDomainGraphReport', compact('graph_data', 'tr_data'));
    }

    // public function commercialReportForm(Request $request)
    // {
    //     // dd($request->all());
    //     $tr_data=MeterVisual::select('global_device_id')->get();

    //         // $data=TrCurrentLog::orderBy('datetime','DESC')->take(100)->get();

    //        // Start with the TrCurrentLog query
    //         $data = DB::table('tr_current_logs')
    //         ->leftJoin('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
    //         ->select('tr_current_logs.*',  'meter_visuals.dmdt_phase')
    //         ->orderBy('tr_current_logs.stime', 'DESC');

    //         // Apply the filters based on the request parameters
    //         if ($request->from) {
    //         $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
    //         $data = $data->where('tr_current_logs.stime', '>=', $fromDate);
    //         }

    //         if ($request->to) {
    //         $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
    //         $data = $data->where('tr_current_logs.stime', '<=', $toDate);
    //         }

    //         if ($request->DeviceId) {
    //         $data = $data->where('tr_current_logs.global_device_id', $request->DeviceId);
    //         }

    //         // Limit the number of results and get the data
    //         if($request->from || $request->to )
    //           $data = $data->limit(30)->get();
    //         else
    //         $data = $data->limit(500)->paginate(30);


    //     // $data=Transformer::find($id);
    //     // dd($data);

    //     return view('commercialReportView',compact('data','tr_data'));
    // }




}
