<?php

namespace App\Http\Controllers;

use App\Models\AutoSwitching;
use App\Models\BillingData;
use App\Models\Dbbox;
use App\Models\DeviceConfiguration;
use App\Models\DeviceThreshold;
use App\Models\Event;
use App\Models\ExtraLog;
use App\Models\Feeder;
use App\Models\LoadProfileData;
use App\Models\MeterVisual;
use App\Models\RawTransLog;
use App\Models\Transformer;
use App\Models\TrappingEventSetting;
use App\Models\TrCurrentLog;
use App\Models\TrKwhLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use App\Traits\CommandTrait;

class HomeController extends Controller
{
    use CommandTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function apmsrawpanel(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();

            $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');

            $data = DB::table('raw_device_log')
            ->leftJoin('meter_visuals', 'raw_device_log.moduleid', '=', 'meter_visuals.global_device_id')
            ->select('raw_device_log.*',  'meter_visuals.dmdt_phase')
            ->orderBy('raw_device_log.server_date_time', 'DESC');

        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('raw_device_log.server_date_time', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('raw_device_log.server_date_time', '<=', $toDate);
        }

        if ($request->DeviceId) {
            $data = $data->where('raw_device_log.moduleid', $request->DeviceId);
            }

            // dd($data->toSql(), $data->getBindings());

            // Limit the number of results and get the data
            if( $hasFilters)
            {
                $data = $data->paginate(30);
            }
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);




        // $data=Transformer::find($id);
        // dd($data);

        return view('raw_panel_apms',compact('data','tr_data'));
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
   public function index()
    {
        // $data=MeterVisual::where('installed_on','transformer')->get();

        $oneHourAgo = Carbon::now()->subHour();

        // $data = MeterVisual::where('installed_on', 'transformer')
        // ->select('global_device_id','v1','v2','v3','i1','i2','i3','pf1','pf2','pf3','stime','server_time_update_our_value')
        // ->get();
        $data = MeterVisual::where('installed_on', 'transformer')
        ->where('is_warterScade_device', 0) // Added condition here
        ->select([
            'global_device_id',
            'server_time_update_our_value',
            'kva',
            'auxr_status',

            // Average voltage of all v1, v2, v3 combined
            DB::raw('AVG((voltage_phase_a + voltage_phase_b + voltage_phase_c) / 3) as avg_voltage'),

            // Average power factor of all pf1, pf2, pf3 combined
            DB::raw('AVG((pf1 + pf2 + pf3) / 3) as avg_powerfactor'),

            // Sum of all currents i1 + i2 + i3
            DB::raw('SUM(current_phase_a + current_phase_b + current_phase_c) as sum_current'),

            DB::raw('ROUND(SUM((kwhp1 + kwhp2 + kwhp3) + (kwho1 + kwho2 + kwho3)), 2) as total_consumption'),

            // Total KVA sum of (i*v)/1000 for all phases
            DB::raw('ROUND(SUM((current_phase_a * voltage_phase_a + current_phase_b * voltage_phase_b + current_phase_c * voltage_phase_c) / 1000), 2) as total_kva'),
        ])
        ->groupBy('global_device_id', 'server_time_update_our_value', 'kva', 'auxr_status')
        ->get();

        // dd($data);

                // dd($data);
        return view('home',compact('data'));
    }


public function trasnfDash() 
{
    $oneHourAgo = Carbon::now()->subHour();

    $data = MeterVisual::where('installed_on', 'transformer')
        ->where('is_warterScade_device', 0) // Added condition here
        ->select([
            'global_device_id',
            'server_time_update_our_value',
            'kva',
            'auxr_status',

            // Average voltage of all v1, v2, v3 combined
            DB::raw('AVG((voltage_phase_a + voltage_phase_b + voltage_phase_c) / 3) as avg_voltage'),

            // Average power factor of all pf1, pf2, pf3 combined
            DB::raw('AVG((pf1 + pf2 + pf3) / 3) as avg_powerfactor'),

            // Sum of all currents i1 + i2 + i3
            DB::raw('SUM(current_phase_a + current_phase_b + current_phase_c) as sum_current'),

            DB::raw('ROUND(SUM((kwhp1 + kwhp2 + kwhp3) + (kwho1 + kwho2 + kwho3)), 2) as total_consumption'),

            // Total KVA sum of (i*v)/1000 for all phases
            DB::raw('ROUND(SUM((current_phase_a * voltage_phase_a + current_phase_b * voltage_phase_b + current_phase_c * voltage_phase_c) / 1000), 2) as total_kva'),
        ])
        ->groupBy('global_device_id', 'server_time_update_our_value', 'kva', 'auxr_status')
        ->get();

        // dd($data[0]);

    return view('trasnfDash', compact('data'));
}


      public function apmsDash()
    {
            $oneHourAgo = Carbon::now()->subHour();

    $data = MeterVisual::where('installed_on', 'transformer')
        ->where('is_warterScade_device', 1) //  Added condition here
        ->select([
            'id',
            'global_device_id',
            'server_time_update_our_value',
            'kva',
            'auxr_status',

            // Average voltage of all v1, v2, v3 combined
            DB::raw('AVG((voltage_phase_a + voltage_phase_b + voltage_phase_c) / 3) as avg_voltage'),

            // Average power factor of all pf1, pf2, pf3 combined
            DB::raw('AVG((pf1 + pf2 + pf3) / 3) as avg_powerfactor'),

            // Sum of all currents i1 + i2 + i3
            DB::raw('SUM(current_phase_a + current_phase_b + current_phase_c) as sum_current'),

            // Total KVA sum of (i*v)/1000 for all phases
            DB::raw('ROUND(SUM((current_phase_a * voltage_phase_a + current_phase_b * voltage_phase_b + current_phase_c * voltage_phase_c) / 1000), 2) as total_kva'),

            DB::raw('ROUND(SUM((kwhp1 + kwhp2 + kwhp3) + (kwho1 + kwho2 + kwho3)), 2) as total_consumption'),
        ])
        ->groupBy('global_device_id', 'server_time_update_our_value', 'kva', 'auxr_status','id')
        ->get();
        return view('apmsDash',compact('data'));
    }



    public function deviceData($id)
{
    $data = MeterVisual::select('id','global_device_id')->where('global_device_id', $id)->first();
    $graph_data = DB::table('tr_current_logs')
        ->where('global_device_id', $id)
        ->orderBy('id', 'desc')
        ->limit(10)
        ->get();

        // dd($graph_data);

    return view('device-data', compact('data', 'graph_data'));
}   



 public function connDeviceData($pid)
{
        // dd($pid);
    $data = MeterVisual::where('parent_id', $pid)
        // ->where('is_warterScade_device', 1) //  Added condition here
        ->select([
            'id',    
            'global_device_id',
            'server_time_update_our_value',
            'kva',
            'auxr_status',

            // Average voltage of all v1, v2, v3 combined
            DB::raw('AVG((voltage_phase_a + voltage_phase_b + voltage_phase_c) / 3) as avg_voltage'),

            // Average power factor of all pf1, pf2, pf3 combined
            DB::raw('AVG((pf1 + pf2 + pf3) / 3) as avg_powerfactor'),

            // Sum of all currents i1 + i2 + i3
            DB::raw('SUM(current_phase_a + current_phase_b + current_phase_c) as sum_current'),
            DB::raw('ROUND(SUM((kwhp1 + kwhp2 + kwhp3) + (kwho1 + kwho2 + kwho3)), 2) as total_consumption'),

            // Total KVA sum of (i*v)/1000 for all phases
            DB::raw('ROUND(SUM((current_phase_a * voltage_phase_a + current_phase_b * voltage_phase_b + current_phase_c * voltage_phase_c) / 1000), 2) as total_kva'),
        ])
        ->groupBy('global_device_id', 'server_time_update_our_value', 'kva', 'auxr_status')
        ->get();

    return view('connect-device-data', compact('data'));
}

 public function connectionDeviceData($pid)
{

    $data = MeterVisual::where('installed_on', 'connection')
        ->where('parent_id', $pid) //  Added condition here
        ->select([
            'global_device_id',
            'server_time_update_our_value',
            'kva',
            'auxr_status',

            // Average voltage of all v1, v2, v3 combined
            DB::raw('AVG((voltage_phase_a + voltage_phase_b + voltage_phase_c) / 3) as avg_voltage'),

            // Average power factor of all pf1, pf2, pf3 combined
            DB::raw('AVG((pf1 + pf2 + pf3) / 3) as avg_powerfactor'),

            // Sum of all currents i1 + i2 + i3
            DB::raw('SUM(current_phase_a + current_phase_b + current_phase_c) as sum_current'),
            DB::raw('ROUND(SUM((kwhp1 + kwhp2 + kwhp3) + (kwho1 + kwho2 + kwho3)), 2) as total_consumption'),

            // Total KVA sum of (i*v)/1000 for all phases
            DB::raw('ROUND(SUM((current_phase_a * voltage_phase_a + current_phase_b * voltage_phase_b + current_phase_c * voltage_phase_c) / 1000), 2) as total_kva'),
        ])
        ->groupBy('global_device_id', 'server_time_update_our_value', 'kva', 'auxr_status')
        ->get();

    return view('connection-device-data', compact('data'));
}


    public function dataList()
    {
        // $data=MeterVisual::get();
        $data=MeterVisual::where('installed_on','!=','normal')->get();
        // pr($data);
        return view('list',compact('data'));
    }

    public function getCofiguration($id)
    {
        // $data=MeterVisual::get();
        $data=DeviceConfiguration::where('global_device_id',$id)->first();
        // pr($data);
        return response()->json($data);
    }

    public function dataListTabular(Request $request)
    {
        $paginate_count = 15;
        $query = MeterVisual::query();

        // Handle the search functionality
        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where('global_device_id', 'LIKE', '%' . $search . '%');
        }
        $data=$query->orderBy('id')->paginate($paginate_count);
        // $data=MeterVisual::get();
        return view('list_tabular',compact('data'));
    }

    public function dataListMap()
    {
        $data=MeterVisual::select('latitude','longitude','global_device_id')->where('latitude','>',0)->where('longitude','>',0)->get();
        return view('list_map',compact('data'));
    }
    public function dataListConnection()
    {
        return view('list_connection');
    }


    public function dataItem($id)
    {
        $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
        // $graph_data=LoadProfileData::get();
        // dd($data);

        return view('single-item-chart',compact('data'));
    }

    public function ItemRealTimeData($id)
    {
        $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
        $graph_data=DB::table('tr_current_logs')->where('global_device_id',$id)->orderBy('id','desc')->limit(10)->get();
        // $graph_data=LoadProfileData::get();
        // dd($data);

        return view('single-item-real-time-data',compact('data','graph_data'));
    }
    // public function deviceData($id)
    // {
    //     $data=MeterVisual::select('id','global_device_id')->where('global_device_id',$id)->first();
    //     $graph_data=DB::table('tr_current_logs')->where('global_device_id',$id)->orderBy('id','desc')->limit(10)->get();
    //     // $graph_data=LoadProfileData::get();
    //     // dd($graph_data);

    //     return view('device-data',compact('data','graph_data'));
    // }
    public function itemGraphDataAjax($id,$time=0)
    {
        // dd('testing');
        // $data=MeterVisual::find($id);
        $graph_data=RawTransLog::select('server_date_time','i_red as ca','i_blue as cb','i_yellow as cc','v_red as va','v_blue as vb' ,'v_yellow as vc')->where('moduleid',$id);
        // echo(json_encode($graph_data));
        // die;
        if($time !=0){
            if ($time == 'lh') {
                // Filter records from the last hour
                $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subHour());
            }

            if ($time == 'l24h') {
                // Filter records from the last 24 hours
                $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subDay());
            }

            if ($time == 'lw') {
                // Filter records from the last week
                $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subWeek());
            }

            if ($time == 'lm') {
                // Filter records from the last month
                $graph_data = $graph_data->where('server_date_time', '>=', Carbon::now()->subMonth());
            }

            // if ($time == 'c') {
                //     // Custom filter logic, for example:
                    //     // You might need to define start and end dates based on user input or other criteria
                    //     // Here we assume a custom range for demonstration purposes
                    //     $start_date = '2024-01-01 00:00:00'; // Example start date
                    //     $end_date = '2024-01-31 23:59:59'; // Example end date
                    //     $graph_data = $graph_data->whereBetween('db_datetime', [$start_date, $end_date]);
                    // }

                }
        $graph=$graph_data->get();
        // pr($graph);
        return result(1,'',$graph);
        // dd($data);

        // return view('single-item-chart',compact('data'));
    }
    public function getRecentLog($deviceID=0,$id=0)
    {
        $data = RawTransLog::orderBy('stime','DESC');

        if($deviceID !=0 ){
                    $data = $data->where('global_device_id', $deviceID);
                }
        $data=$data->first();

        if($data->id!=$id)
        {

            return result(1,'',$data);

        }
        else
        return result(1,'','');
        // return view('single-item-chart',compact('data'));
    }

    public function itemSwitch($id)
    {
        // dd('test');
        // $data=Transformer::find($id);
        $data=MeterVisual::where('global_device_id',$id)->select('id','auxr_status','is_warterScade_device')->first();
        if($data->is_warterScade_device==1)
        {
            $data->status_change_time=date('Y-m-d H:i:s');
            if($data->auxr_status==1)
                $data->auxr_status=0;
            else
                $data->auxr_status=1;
            $data->save();
            return Redirect::back()->withSuccess( 'Action completed for APMS Device.');
        }

        if($data->auxr_status==1){
            // $data->auxr_status=0;
            $command=['gid'=>$id,'at'=>'order','a'=>'aux_relay_operation','d'=>['auxr_status'=>0]];
        }
        else
        {
            // $data->auxr_status=1;
            $command=['gid'=>$id,'at'=>'order','a'=>'aux_relay_operation','d'=>['auxr_status'=>1]];
        }
        $data->save();

       $check=$this->sendCommand($command);
       if($check==1)
       return Redirect::back()->withSuccess('Action Saved ,Status Will Update After Device Response.');
       else if($check==2)
       return Redirect::back()->withError( 'Action already in Que.');
       else
        return Redirect::back()->withSuccess( 'Action Saved ,Status Will Update After Device Response.');
        // return result(1,'',$graph);
    }


    public function currentLog(Request $request)
    {
        // Fetch global_device_ids once, cache if needed
        $tr_data = MeterVisual::select('global_device_id')->get();

        $hasFilters = $request->hasAny(['from', 'to', 'DeviceId']);

        $data = collect(); // Default empty collection in case no filters

        if ($hasFilters) {
            $query = DB::table('tr_current_logs')
                ->leftJoin('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
                ->select(
                    'tr_current_logs.global_device_id',
                    'tr_current_logs.dtime',
                    'tr_current_logs.stime',
                    'tr_current_logs.isPk',
                    'tr_current_logs.isRv',
                    'tr_current_logs.v1',
                    'tr_current_logs.v2',
                    'tr_current_logs.v3',
                    'tr_current_logs.i1',
                    'tr_current_logs.i2',
                    'tr_current_logs.i3',
                    'tr_current_logs.pf1',
                    'tr_current_logs.pf2',
                    'tr_current_logs.pf3',
                    'tr_current_logs.d1',
                    'tr_current_logs.d2',
                    'tr_current_logs.d3',
                    'tr_current_logs.nc',
                    'meter_visuals.dmdt_phase',
                    'meter_visuals.category'
                )
                ->orderBy('tr_current_logs.stime', 'DESC');

//            if ($request->from) {
//                $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
//                $query->where('tr_current_logs.stime', '>=', $fromDate);
//            }
//
//            if ($request->to) {
//                $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
//                $query->where('tr_current_logs.stime', '<=', $toDate);
//            }

            if ($request->from) {
                $fromDate = dbDate($request->from); // cleaner and reusable
                $query->where('tr_current_logs.stime', '>=', $fromDate);
            }

            if ($request->to) {
                $toDate = dbDate($request->to); // keep the time from the input
                $query->where('tr_current_logs.stime', '<=', $toDate);
            }
            if ($request->DeviceId) {
                $query->where('tr_current_logs.global_device_id', $request->DeviceId);
            }

            $data = $query->paginate(30);
        }
        else
        $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);

        return view('currentLog', compact('data', 'tr_data'));
    }

    public function errorLog(Request $request)
    {
        // dd($request->all());
        $tr_data=MeterVisual::select('global_device_id')->get();

            // $data=TrCurrentLog::orderBy('datetime','DESC')->take(100)->get();
            $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');
           // Start with the TrCurrentLog query
            $data = DB::table('logs');

            // Apply the filters based on the request parameters
            if ($request->from) {
            $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
            $data = $data->where('ttime', '>=', $fromDate);
            }

            if ($request->to) {
            $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
            $data = $data->where('ttime', '<=', $toDate);
            }

            if ($request->DeviceId) {
            $data = $data->where('gid', $request->DeviceId);
            }

            // Limit the number of results and get the data
            if($hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);


        // $data=Transformer::find($id);
        // dd($data);

        return view('errorLog',compact('data','tr_data'));
    }

    public function rawpanel(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();

            $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');

            $data = DB::table('raw_transfocure_log')
            ->leftJoin('meter_visuals', 'raw_transfocure_log.global_device_id', '=', 'meter_visuals.global_device_id')
            ->select('raw_transfocure_log.*',  'meter_visuals.dmdt_phase')
            ->orderBy('raw_transfocure_log.stime', 'DESC');

        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('raw_transfocure_log.stime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('raw_transfocure_log.stime', '<=', $toDate);
        }

        if ($request->DeviceId) {
            $data = $data->where('raw_transfocure_log.global_device_id', $request->DeviceId);
            }

            // dd($data->toSql(), $data->getBindings());

            // Limit the number of results and get the data
            if( $hasFilters)
            {
                $data = $data->paginate(30);
            }
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);




        // $data=Transformer::find($id);
        // dd($data);

        return view('raw_panel',compact('data','tr_data'));
    }


    public function alert(Request $request)
    {
        // dd($request->all());
        $tr_data=MeterVisual::select('global_device_id')->get();

            // $data = DB::table('raw_transfocure_log')
            // ->leftJoin('meter_visuals', 'raw_transfocure_log.global_device_id', '=', 'meter_visuals.global_device_id')
            // ->select('raw_transfocure_log.*',  'meter_visuals.dmdt_phase')
            // ->orderBy('raw_transfocure_log.stime', 'DESC');
            $data=Event::query();
            $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');    

            // Apply the filters based on the request parameters
            if ($request->from) {
            $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
            $data = $data->where('db_datetime', '>=', $fromDate);
            }

            if ($request->to) {
            $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
            $data = $data->where('db_datetime', '<=', $toDate);
            }

            if ($request->DeviceId) {
            $data = $data->where('global_device_id', $request->DeviceId);
            }

            // Limit the number of results and get the data
    if ($hasFilters) {
        $data = $data->orderBy('db_datetime', 'DESC')->paginate(30);
    } else {
        // ✅ Fetch latest 50 when no filters applied
        $data = Event::orderBy('db_datetime', 'DESC')->paginate(50);
    }

        // $data=Transformer::find($id);
        // dd($data);
        return view('alert',compact('data','tr_data'));
    }


    public function kvaLog(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();

        $data = DB::table('tr_current_logs')
        ->leftJoin('meter_visuals', 'tr_current_logs.global_device_id', '=', 'meter_visuals.global_device_id')
        ->select('tr_current_logs.*',  'meter_visuals.dmdt_phase')
        ->orderBy('tr_current_logs.stime', 'DESC');

        $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');

        // Apply the filters based on the request parameters
        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('tr_current_logs.stime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('tr_current_logs.stime', '<=', $toDate);
        }


        if ($request->DeviceId) {
        $data = $data->where('tr_current_logs.global_device_id', $request->DeviceId);
        }

        // Limit the number of results and get the data
        if( $hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);

        // dd($data);
        // else
        // $data=TrKwhLog::orderBy('stime','DESC')->take(100)->get();
        return view('kvaLog',compact('data','tr_data'));
    }


    
    public function thdLog(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();

        $data = DB::table('raw_transfocure_log')
        ->leftJoin('meter_visuals', 'raw_transfocure_log.global_device_id', '=', 'meter_visuals.global_device_id')
        ->select('raw_transfocure_log.*',  'meter_visuals.dmdt_phase')
        ->orderBy('raw_transfocure_log.stime', 'DESC');

        $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');

        // Apply the filters based on the request parameters
        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('raw_transfocure_log.stime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('raw_transfocure_log.stime', '<=', $toDate);
        }


        if ($request->DeviceId) {
        $data = $data->where('raw_transfocure_log.global_device_id', $request->DeviceId);
        }

        // Limit the number of results and get the data
        if( $hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);

        // dd($data);
        // else
        // $data=TrKwhLog::orderBy('stime','DESC')->take(100)->get();
        return view('thdLog',compact('data','tr_data'));
    }
    public function kwhLog(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();
        // $data = TrKwhLog::orderBy('stime','DESC');
        // if($request->from)
        // {
        //     $fromDate = date('Y-m-d 00:00:00', strtotime($request->from));
        //     $data = $data->where('stime', '>=', $fromDate);
        // }

        //     if($request->to)
        //     {
        //         $toDate = date('Y-m-d 23:59:59', strtotime($request->to));
        //         $data = $data->where('stime', '<=', $toDate);
        //     }

        // if($request->DeviceId)
        // $data = $data->where('trid', $request->DeviceId);

        // $data=$data->limit(200)->get();


        $data = DB::table('tr_kwh_logs')
        ->leftJoin('meter_visuals', 'tr_kwh_logs.trid', '=', 'meter_visuals.global_device_id')
        ->select('tr_kwh_logs.*',  'meter_visuals.dmdt_phase')
        ->orderBy('tr_kwh_logs.stime', 'DESC');
        $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');

        // Apply the filters based on the request parameters

        if ($request->from) {
            $fromDate = dbDate($request->from); // cleaner and reusable
            $data->where('tr_kwh_logs.stime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to); // keep the time from the input
            $data->where('tr_kwh_logs.stime', '<=', $toDate);
        }


        if ($request->DeviceId) {
        $data = $data->where('tr_kwh_logs.trid', $request->DeviceId);
        }

        // Limit the number of results and get the data
        if( $hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);

        // dd($data);
        // else
        // $data=TrKwhLog::orderBy('stime','DESC')->take(100)->get();
        return view('kwhLog',compact('data','tr_data'));
    }

    public function mdiLog(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();
        $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');
        // dd('test');
        // $data=BillingData::orderBy('db_datetime','DESC')->take(100)->get();

        $data = BillingData::orderBy('db_datetime', 'DESC');

        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('db_datetime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('db_datetime', '<=', $toDate);
        }

        if ($request->DeviceId) {
            $data = $data->where('global_device_id', $request->DeviceId);
        }

        if( $hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);



        // $data=Transformer::find($id);
        // dd($data);

        return view('mdiLog',compact('data','tr_data'));
    }
    public function extraLog(Request $request)
    {
        $tr_data=MeterVisual::select('global_device_id')->get();
        $hasFilters = $request->filled('from') || $request->filled('to') || $request->filled('DeviceId');
        // dd('test');
        // $data=BillingData::orderBy('db_datetime','DESC')->take(100)->get();

        $data = ExtraLog::orderBy('dtime', 'DESC');

        if ($request->from) {
            $fromDate = dbDate($request->from);
            $data = $data->where('dtime', '>=', $fromDate);
        }

        if ($request->to) {
            $toDate = dbDate($request->to);
            $data = $data->where('dtime', '<=', $toDate);
        }

        if ($request->DeviceId) {
            $data = $data->where('global_device_id', $request->DeviceId);
        }

        if( $hasFilters)
              $data = $data->paginate(30);
            else
            $data = new \Illuminate\Pagination\LengthAwarePaginator([], 0, 30);


        // $data=Transformer::find($id);
        // dd($data);

        return view('extraLog',compact('data','tr_data'));
    }

    public function transformerSwitching(Request $request)
    {
        $data=[];
        if(isset($request->deviceId))
        $data=DB::table('auto_switching')->orderBy('repeat','asc')->where('trid',$request->deviceId)->get();
        // dd($data);

        $tr_data=MeterVisual::select('global_device_id')->get();

        return view('transformerSwitch',compact('tr_data','data'));
    }
    public function transformerSwitchingSave(Request $request)
    {
        if(isset($request->deviceId))
        {

            $day=$request->day;
            $st=$request->start;
            $end=$request->end;
            if(!empty($day))
            {
                // dd($request->all());
                $all_data=[];

                foreach($day as $k =>$row)
                {
                    $data=array('starttime'=>$st[$k],'offtime'=>$end[$k],'repeat'=>$k,'trid'=>$request->deviceId);
                    $all_data[]=$data;
                }
                // AutoSwitching::where('trid',$request->deviceId)->delete();
                if(!empty($all_data))
                AutoSwitching::insert($all_data);
            return redirect()->back()->with('success', 'Action Completed');
            }
            else
            {
                return redirect()->back()->with('error', 'Data Missing');
            }
        }
        else{
            return redirect()->back()->with('error', 'Global Id Missing');
        }
    }

    public function deleteSwitchRecord($id)
    {

                AutoSwitching::where('id',$id)->delete();
            return redirect()->back()->with('success', 'Action Completed');
    }

    public function dataItemDelete($id)
    {

        MeterVisual::where('global_device_id',$id)->delete();
            return redirect()->back()->with('success', 'Action Completed');
    }


    public function addTransformerForm()
    {
//        $tr_data=MeterVisual::select('global_device_id')->get();
        $tr_data = MeterVisual::where('installed_on', '!=', 'normal')
            ->where('installed_on', '!=', 'connection')
            ->get();
//dd($tr_data);
        return view('add_transformer_form',compact('tr_data'));
    }

    public function addTransformerThresholdForm(Request $request)
    {

        $tr_data=MeterVisual::select('global_device_id')->get();

        if ($request->has('DeviceId')) {
            $threshold_data = TrappingEventSetting::where('global_device_id', $request->query('DeviceId'))->get()->toArray();
        } else {
            $threshold_data = (object) []; // Return an empty object if DeviceId is not present
        }


        // dd($threshold_data);
        return view('add_transformer_thresold_form',compact('threshold_data','tr_data'));
    }
    public function editTransformerForm($id)
    {
        $tr_data=MeterVisual::select('global_device_id','id')->get();
        $data=MeterVisual::where('global_device_id',$id)->first();
//         dd($data);
        return view('edit_transformer_form',compact('data','tr_data'));
    }

    public function editTransformer(Request $request,$id)
    {
       $m= MeterVisual::where('global_device_id',$request->dev_id)->first();
       $m-> global_device_id= $request->dev_id;
       $m-> parent_id=      ($request->parentDevice) ? $request->parentDevice :null;
       $m->sim_number       = $request->sim_number;
       $m->msn              = $request->msn;
       $m->auxr_status      = 1;
       $m->longitude        = $request->long;
       $m->latitude         = $request->lat;
       $m->description      = $request->description;
       $m->offpeak          = (int)$request->offpk;
       $m->peak             = (int)$request->pk;
       $m->installed_on     = $request->installed_on;
       $m->dmdt_phase        = $request->meter_type;
       $m->dmdt_bidirectional_device     = ($request->meter_mode) ? $request->meter_mode: 0 ;
       $m->category    = $request->meter_category;
       $m->respond_time    = $request->respond_time;
       $m->is_aux_relay     = $request->switching;
       $m->kva     = $request->kva;
       $m->save();

        return redirect()->back()->with('success', 'Action Completed');

    }
//    public function addTransformer(Request $request)
//    {
//
//       $dev= MeterVisual::where('global_device_id',$request->dev_id)->first();
//       if($dev)
//       return redirect()->back()->with('error', 'Device Id Already Used');
//
//       $m=new MeterVisual();
//       $m-> global_device_id= $request->dev_id;
//       $m-> parent_id= $request->parentDevice;
//       $m->sim_number       = $request->simno;
//       $m->msn              = $request->s_no;
//       $m->auxr_status      = 1;
//       $m->longitude        = $request->long;
//       $m->latitude         = $request->lat;
//       $m->description      = $request->description;
//       $m->offpeak          = $request->offpk;
//       $m->peak             = $request->pk;
//       $m->installed_on     = $request->installed_on;
//       $m->dmdt_phase        = $request->meter_type;
//       $m->category    = $request->meter_category;
//       $m->is_aux_relay     = $request->switching;
//       $m->respond_time     = $request->respond_time;
//       $m->dmdt_bidirectional_device     = ($request->meter_mode) ? $request->meter_mode: 0 ;
//       $m->kva     = $request->kva;
////dd($m);
//       $m->save();
//
//        return redirect()->back()->with('success', 'Action Completed');
//
//    }


    // public function addTransformer(Request $request)
    // {
    //     $from = $request->dev_id;
    //     $to = $request->todev_id;

    //     // Parse base and numeric suffix from From Device ID
    //     preg_match('/^(.*?)(\d+)$/', $from, $matches);
    //     if (!$matches) {
    //         return redirect()->back()->with('error', 'Invalid From Device ID format.');
    //     }

    //     $prefix = $matches[1];     // e.g. "CN1F1T25C"
    //     $startNum = (int) $matches[2]; // e.g. 1

    //     $endNum = $startNum;

    //     if (!empty($to)) {
    //         // Validate To Device ID follows the same prefix
    //         preg_match('/^(.*?)(\d+)$/', $to, $toMatches);
    //         if (!$toMatches || $toMatches[1] !== $prefix) {
    //             return redirect()->back()->with('error', 'To Device ID must match the base of From Device ID.');
    //         }

    //         $endNum = (int) $toMatches[2];
    //     }

    //     // Loop to insert devices from CN1F1T25C1 to CN1F1T25C8 (or just one)
    //     for ($i = $startNum; $i <= $endNum; $i++) {
    //         $newDevId = $prefix . $i;

    //         // Skip if device ID already exists
    //         if (MeterVisual::where('global_device_id', $newDevId)->exists()) {
    //             continue;
    //         }

    //         $m = new MeterVisual();
    //         $m->global_device_id = $newDevId;
    //         $m->parent_id = $request->parentDevice;
    //         $m->sim_number = $request->simno;
    //         $m->msn = $request->s_no;
    //         $m->auxr_status = 1;
    //         $m->longitude = $request->long;
    //         $m->latitude = $request->lat;
    //         $m->description = $request->description;
    //         $m->offpeak = $request->offpk;
    //         $m->peak = $request->pk;
    //         $m->installed_on = $request->installed_on;
    //         $m->dmdt_phase = $request->meter_type;
    //         $m->category = $request->meter_category;
    //         $m->is_aux_relay = $request->switching;
    //         $m->respond_time = $request->respond_time;
    //         $m->dmdt_bidirectional_device = $request->meter_mode ?? 0;
    //         $m->kva = $request->kva;
    //         $m->save();
    //     }

    //     return redirect()->back()->with('success', 'Device(s) inserted successfully.');
    // }

    public function addTransformer(Request $request)
{
    $from = trim($request->dev_id);
    $to = trim($request->todev_id);

    // Allow both purely alphanumeric IDs (like R2f2t1p)
    // and IDs with numeric suffixes (like CN1F1T25C1)
    if (!preg_match('/^[A-Za-z0-9]+$/', $from)) {
        return redirect()->back()->with('error', 'Invalid From Device ID format.');
    }

    // Try to extract base + numeric suffix (optional)
    preg_match('/^(.*?)(\d+)?$/', $from, $matches);
    $prefix = $matches[1];                 // e.g. "CN1F1T25C" or "R2f2t1p"
    $startNum = isset($matches[2]) ? (int)$matches[2] : null;

    $endNum = $startNum;

    if (!empty($to)) {
        if (!preg_match('/^[A-Za-z0-9]+$/', $to)) {
            return redirect()->back()->with('error', 'Invalid To Device ID format.');
        }

        preg_match('/^(.*?)(\d+)?$/', $to, $toMatches);
        if ($toMatches[1] !== $prefix) {
            return redirect()->back()->with('error', 'To Device ID must match the base of From Device ID.');
        }

        $endNum = isset($toMatches[2]) ? (int)$toMatches[2] : $startNum;
    }

    // Insert one or multiple devices
    if ($startNum === null || $endNum === null) {
        // No numeric suffix — insert single ID
        $deviceIds = [$from];
    } else {
        // Numeric range
        $deviceIds = [];
        for ($i = $startNum; $i <= $endNum; $i++) {
            $deviceIds[] = $prefix . $i;
        }
    }

    foreach ($deviceIds as $newDevId) {
        if (MeterVisual::where('global_device_id', $newDevId)->exists()) {
            continue;
        }

        $m = new MeterVisual();
        $m->global_device_id = $newDevId;
        $m->parent_id = $request->parentDevice;
        $m->sim_number = $request->simno;
        $m->msn = $request->s_no;
        $m->auxr_status = 1;
        $m->longitude = $request->long;
        $m->latitude = $request->lat;
        $m->description = $request->description;
        $m->offpeak = $request->offpk;
        $m->peak = $request->pk;
        $m->installed_on = $request->installed_on;
        $m->dmdt_phase = $request->meter_type;
        $m->category = $request->meter_category;
        $m->is_aux_relay = $request->switching;
        $m->respond_time = $request->respond_time;
        $m->dmdt_bidirectional_device = $request->meter_mode ?? 0;
        $m->kva = $request->kva;
        $m->save();
    }

    return redirect()->back()->with('success', 'Device(s) inserted successfully.');
}




    public function addTransformerTreshold(Request $request)
    {
        // dd($request->all());
        $cetl=$request->critical_event_threshold_limit;

        // if(empty($cetl))

        foreach($cetl as $key => $row)
        {
                if($row != null)
                {
                    $data_array=[
                        'global_device_id'=>$request->global_device_id,
                        'type'=>$request->type[$key],
                        'critical_event_threshold_limit' => $row,
                        'critical_event_log_time'=> $request->critical_event_log_time[$key],
                        'tripping_event_threshold_limit'=>$request->tripping_event_threshold_limit[$key],
                        'tripping_event_log_time'=>$request->tripping_event_log_time[$key],
                        'enable_tripping'=>$request->enable_tripping[$key]
                    ];
                    $tevent=TrappingEventSetting::where(['global_device_id'=>$request->global_device_id,'type'=>$request->type[$key]])->first();
                    if($tevent)
                    {
                        TrappingEventSetting::where(['global_device_id'=>$request->global_device_id,'type'=>$request->type[$key]])->update($data_array);
                    }
                    else
                    {
                        TrappingEventSetting::insert($data_array);
                    }
                }

        }
        return redirect()->back()->with('success', 'Action Completed');
        // return redirect()->back()->with('error', 'Fill Required form');
        // $data=$request->except(['_token','DeviceId']);
        // $data['datetime']=date('Y-m-d H:i:s');
        // $data['global_device_id']=$request->DeviceId;

        // $record = DeviceThreshold::updateOrCreate(['global_device_id' => $request->DeviceId],
        //                                             $data
        //                                          );
    }
}
