<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class UserInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return response()->json([
            'message' => 'User info fetched successfully',
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $user = auth()->user();
        $user = User::find($user->id);

        $input = $request->all();
        $input['timezone'] = $request->header('user-timezone');
        User::where('id', $user->id)->update($input);


        $user->save();

        return response()->json(['success' => true, 'message' => 'User info updated successfully']);

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {

        $user = auth()->user();

        $user = User::find($user->id);

        if (! $user) {
            return response()->json(['message' => 'User not found'], 404);
        }

        UserInterest::where('user_id', $id)->delete();
        UserTask::where('user_id', $id)->delete();

        // Delete the user and related data
        //  $user->delete();

        return response()->json(['message' => 'User deleted successfully']);
    }
}
