<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
// use app/config;

class InstantDataController extends Controller
{

    public function store(Request $request, $company)
    {
        // Get company config
        $config = config("tenants.companies.$company");
    
        if (!$config) {
            return response()->json([
                "error" => "Company config not found: $company"
            ], 404);
        }
    
        // Validation rules
        $rules = [
            'moduleid' => 'required|string|max:255',
            'v_red' => 'nullable|numeric',
            'v_blue' => 'nullable|numeric',
            'v_yellow' => 'nullable|numeric',
            'i_red' => 'nullable|numeric',
            'i_blue' => 'nullable|numeric',
            'i_yellow' => 'nullable|numeric',
            'pf_red' => 'nullable|numeric|between:-1,1',
            'pf_blue' => 'nullable|numeric|between:-1,1',
            'pf_yellow' => 'nullable|numeric|between:-1,1',
            'packet_date_time' => 'nullable|date',
            'kwh_offpeak_red' => 'nullable|numeric|min:0',
            'kwh_offpeak_blue' => 'nullable|numeric|min:0',
            'kwh_offpeak_yellow' => 'nullable|numeric|min:0',
            'kwh_peak_red' => 'nullable|numeric|min:0',
            'kwh_peak_blue' => 'nullable|numeric|min:0',
            'kwh_peak_yellow' => 'nullable|numeric|min:0',
        ];
    
        $validator = Validator::make($request->all(), $rules);
    
        // Return validation errors as JSON
        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }
    
        $validated = $validator->validated();
    
        // Set current datetime if not provided
        $validated['packet_date_time'] = $validated['packet_date_time'] ?? now();
    
        // Switch database connection
        config([
            "database.connections.dynamic" => $config
        ]);
    
        // Insert into DB
        $id = DB::connection('dynamic')->table('raw_device_log')->insertGetId($validated);
    
        // Prepare response
        return response()->json([
            "gid" => $validated['moduleid'],
            "a" => "instantaneous",
            "at" => "post_data",
            "d" => [
                "v1" => $validated['v_red'] ?? 0,
                "v2" => $validated['v_yellow'] ?? 0,
                "v3" => $validated['v_blue'] ?? 0,
                "i1" => $validated['i_red'] ?? 0,
                 "i2" => $validated['i_yellow'] ?? 0,
                "i3" => $validated['i_blue'] ?? 0,
                "pf1" => $validated['pf_red'] ?? 0,
                 "pf2" => $validated['pf_yellow'] ?? 0,
                "pf3" => $validated['pf_blue'] ?? 0,
                "dtime" => $validated['packet_date_time'],
                "kwhp1" => $validated['kwh_offpeak_red'] ?? 0,
                "kwhp2" => $validated['kwh_offpeak_blue'] ?? 0,
                "kwhp3" => $validated['kwh_offpeak_yellow'] ?? 0,
                "kwho1" => $validated['kwh_peak_red'] ?? 0,
                "kwho2" => $validated['kwh_peak_blue'] ?? 0,
                "kwho3" => $validated['kwh_peak_yellow'] ?? 0,
                "rkwhp1" => $validated['kwh_offpeak_red'] ?? 0,
                "rkwhp2" => $validated['kwh_offpeak_blue'] ?? 0,
                "rkwhp3" => $validated['kwh_offpeak_yellow'] ?? 0,
            ]
        ]);
    }

public function schedule(Request $request,$company)
{
    // Get company config
    $config = config("tenants.companies.$company");

    if (!$config) {
        return response()->json([
            "error" => "Company config not found: $company"
        ], 404);
    }

    // Dynamically add connection at runtime
    config([
        "database.connections.dynamic" => $config
    ]);

    // Fetch all rows from "schedule" table (company DB)
    // ->where('gid',$request->gid)
    try {
        $schedules = DB::connection('dynamic')->table('schedule')->where('gid', $request->gid)->get();
    } catch (\Exception $e) {
        return response()->json([
            'error' => 'Database connection failed',
            'details' => $e->getMessage()
        ], 500);
    }
    // $schedules = DB::connection('dynamic')->table('schedule')->get();

    if ($schedules->isEmpty()) {
        return response()->json([
            "gid" => $request->gid,
            "a"   => "schedule",
            "at"  => "response",
            "d"   => []
        ]);
    }

    // Take gid from the first record (assuming all have the same gid)

    // Transform to required format
    $data = $schedules->map(function ($item) {
        return [
            "ot" => $item->ot ?? null,
            "ro" => $item->ro ?? null
        ];
    });

    // Custom response
    return response()->json([
        "gid" => $request->gid,
        "a"   => "schedule",
        "at"  => "response",
        "d"   => $data
    ]);
}

public function control($company,$id)
    {

        $config = config("tenants.companies.$company");

        if (!$config) {
            return response()->json([
                "error" => "Company config not found: $company"
            ], 404);
        }
    
        // Dynamically add connection at runtime
        config([
            "database.connections.dynamic" => $config
        ]);

        try {
            $response=[];
                $row =DB::connection('dynamic')->table('meter_visuals')->select('global_device_id','auxr_status','status_change_time')->where('global_device_id', $id)->first();
                if($row)
                {
                    if ($row->status_change_time) {
                        // Convert to Carbon instance
                        $statusChangeTime = Carbon::parse($row->status_change_time);

                        // Check if older than 5 minutes
                        if ($statusChangeTime->lt(now()->subMinutes(5))) {
                            // It's older than 5 minutes
                            // Do something or return true
                           $response = [
                                "gid" => $id,
                                "a"   => "remote_switching",
                                "at"  => "response",
                                "d"   => "do_nothing"
                            ];
                             return response()->json($response);

                        } 
                    }

                    $response = [
                        "gid" => $id,
                        "a"   => "remote_switching",
                        "at"  => "response",
                        "d"   => $row->auxr_status
                    ];
                }
                else
                {
                    $response = [
                        "gid" => $id,
                        "a"   => "remote_switching",
                        "at"  => "response",
                        "d"   => "do_nothing"
                    ];
                }

                
                return response()->json($response);
        } catch (Exception $e) {
            return response()->json([
                "gid" => $id,
                "a"   => "remote_switching",
                "at"  => "response",
                "d"   => "do_nothing",
                "error" => "Exception occurred: " . $e->getMessage()
            ], 500);
        }
    }



}