<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\AutoSwitching;
use App\Models\DeviceThreshold;
use App\Models\EventM;
use App\Models\instantData;
use App\Models\MeterVisual;
use Illuminate\Http\Request;
use App\Models\RawTransLog;
use App\Models\Transformer;
use Illuminate\Support\Facades\Validator;
use App\Traits\DataCollectionTrait;

class HardWareApiC extends Controller
{
    use DataCollectionTrait;

    function get_peak_opeak($id)
    {
        // $validator = Validator::make($request->all(), [
        //             'old_password' => 'required',
        //             'new_password' => 'required|min:3',
        //             'confirm_password' => 'required|same:new_password'
        //         ]);
        
        //         if ($validator->fails()) return error('Validation Error.', $validator->errors(), 422);

        // return response()->json($request->all());
        $peak_timing_array = [
            [
                'fromMonth' => 12,
                'toMonth' => 2,
                'fromTime' => '2000-01-01 17:00:00',
                'toTime' => '2000-01-01 21:00:00',
                'fromHour'=>17,
                'toHour' => 21
            ],
            [
                'fromMonth' => 3,
                'toMonth' => 5,
                'fromTime' => '2000-01-01 18:00:00',
                'toTime' => '2000-01-01 22:00:00',
                'fromHour'=>18,
                'toHour' =>22 
            ],
            [
                'fromMonth' => 6,
                'toMonth' => 8,
                'fromTime' => '2000-01-01 19:00:00',
                'toTime' => '2000-01-01 23:00:00',
                'fromHour'=>19,
                'toHour' =>23 
            ],
            [
                'fromMonth' => 9,
                'toMonth' => 11,
                'fromTime' => '2000-01-01 18:00:00',
                'toTime' => '2000-01-01 22:00:00',
                'fromHour'=>18,
                'toHour' =>22 
            ]
        ];
        $peak_timing_coll=collect($peak_timing_array);

        $check_peak=$peak_timing_coll->where('fromMonth','>=',date('m')) // find peak from peak_timing_coll
                            ->where('toMonth','<=',date('m'))
                            ->where('fromHour','>=',date('H'))
                            ->where('toHour','>=',date('H'));
                            if($check_peak) // peak time 
                            $ispeak= 1;
                            
                            else // offpeak time
                            $ispeak= 0;
            
    //   $data['slabs']=$peak_timing_coll;
      $data['ispeak']=$ispeak;

      $trans=Transformer::select("kwh_peak1", "kwh_peak2","kwh_peak3","kwh_offpeak1",  "kwh_offpeak2", "kwh_offpeak3")->where('trid',$id)->first();
      $data['kwh']=$trans;

      return result(1,'',$data);

    }
    public function get_schedule($id)
    {
        $list=AutoSwitching::select('trid','repeat','starttime','offtime')->where('trid',$id)->get();
        return result(1,'',$list);
    }
    public function get_info($id)
    {
        $row=MeterVisual::select('id','global_device_id','auxr_status','is_aux_relay')->where('global_device_id',$id)->first();
        return result(1,'',$row);
    }

    public function realy_status_update(Request $request)
    {
        $validator = Validator::make($request->all(), [
                                                        'global_device_id' => 'required',
                                                        'status' => 'required|in:0,1',
                                                    ]);
        
                if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);
        extract($request->all());        
        $row=MeterVisual::select('id','global_device_id','auxr_status')->where('global_device_id',$global_device_id)->first();
        if($row)
        {
            Transformer::where('trid',$global_device_id)->update(['status'=>$status]);
            $row->auxr_status=$status;
            $row->save();
        
            return result(1,'Status Updated',$row);
        }
        else
         return result(0,'Device Id Not Found');
    }

    public function load_sheding_slabs(Request $request)
    {
        $validator = Validator::make($request->all(), [
                    'global_device_id' => 'required',
                ]);
        
                if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);

       $data=MeterVisual::select('lsch_load_shedding_slabs','lsch_start_datetime','lsch_end_datetime')->where('global_device_id',$request->global_device_id)->first();
       // $data->lsch_load_shedding_slabs=json_decode($data->lsch_load_shedding_slabs);
        return result(1,'',$data);
    }

    public function get_threshold(Request $request)
    {
        $validator = Validator::make($request->all(), [
                    'global_device_id' => 'required',
                ]);
        
                if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);

       $data=DeviceThreshold::where('global_device_id',$request->global_device_id)->first();
       // $data->lsch_load_shedding_slabs=json_decode($data->lsch_load_shedding_slabs);
        return result(1,'',$data);
    }

    function dataCollection(Request $request)
    {
        
        return $this->pdataCollection($request);
        // return  response()->json($data);
        // echo   $this->dataCollection($request);
        // die;
        // $validator = Validator::make($request->all(), [
        //             'old_password' => 'required',
        //             'new_password' => 'required|min:3',
        //             'confirm_password' => 'required|same:new_password'
        //         ]);
        
        //         if ($validator->fails()) return error('Validation Error.', $validator->errors(), 422);

        // return response()->json($request->all());

            
        // <?php
        // $servername = "10.13.144.6";
        // $username = "user_".$subdivid;
        // $password = "Adm1n@".$subdivid; // set this field "" (empty quotes) if you have not set an$
        // $dbname = $dbtype."_".$subdivid;


        // $SubDiv=$_GET['subdivid'];
        // $moduleid = $_GET['moduleid'];

        $SubDiv=$request->subdivid;
        $moduleid = $request->moduleid;
        // $labels = array();
        // $data = array();
        $flg=true;
        // $sql = "";
        $server_date_time = date('Y-m-d H:i:s');
        $application="electrocure";
        $api_flg ='';
        if(isset($request->api_flag))
            $api_flg = $request->api_flag;

        
        $rtl= new RawTransLog(); 
        $idata= new instantData();  
       

        if($api_flg == 'apitransv21')
        {

            $rtl->moduleid=$request->moduleid;
            $rtl->packet_date_time=$request->packet_date_time;
            $rtl->v_red=numberf($request->v_red);
            $rtl->v_blue=numberf($request->v_blue);
            $rtl->v_yellow=numberf($request->v_yellow);
            
            $idata->    current_tariff_register =0;
            $idata->    signal_strength =0;
            $idata->    msn =0;
            $idata->    frequency =0;
            $idata->    global_device_id =$request->moduleid;
            $idata->    meter_datetime =$request->packet_date_time;


            $idata->    voltage_phase_a =numberf($request->v_red);
            $idata->    voltage_phase_b =numberf($request->v_blue);
            $idata->    voltage_phase_c =numberf($request->v_yellow);

            

           
            $rtl->i_red=numberf($request->i_red); 
            $rtl->i_blue=numberf($request->i_blue);
            $rtl->i_yellow=numberf($request->i_yellow);

            $rtl->pf_red=numberf($request->pf_red);
            $rtl->pf_blue=numberf($request->pf_blue);
            $rtl->pf_yellow=numberf($request->pf_yellow);
            
            $idata->current_phase_a = numberf($request->i_red); 
            $idata->current_phase_b = numberf($request->i_blue);
            $idata->current_phase_c = numberf($request->i_yellow);

            $rtl->kwh_offpeak_red=$request->kwh_offpeak_red;
            $rtl->kwh_offpeak_blue=$request->kwh_offpeak_blue;
            $rtl->kwh_offpeak_yellow=$request->kwh_offpeak_yellow;



            $rtl->kwh_peak_red=$request->kwh_peak_red;
            $rtl->kwh_peak_blue=$request->kwh_peak_blue;
            $rtl->kwh_peak_yellow=$request->kwh_peak_yellow;


                // if ($request->peak== 0)
                // {

                
                // }
                // else
                // {
                //     // $rtl->i_red=0;
                //     // $rtl->i_blue=0;
                //     // $rtl->i_yellow=0;
                //     // $rtl->pf_red=($request->kwh) ? numberf($request->kwh) : 0; 


                //     $idata->current_phase_a = ($request->kwh) ? numberf($request->kwh) : 0; ;
                //     $idata->current_phase_b = 0;
                //     $idata->current_phase_c = 0;
                    
                // }
                $rtl->server_date_time=$server_date_time;
                $rtl->save();
            
                $idata->    aggregate_active_pwr_pos =0;
                $idata->    aggregate_active_pwr_neg =0;
                $idata->    aggregate_active_pwr_abs =0;
                $idata->    aggregate_reactive_pwr_pos =0;
                $idata->    aggregate_reactive_pwr_neg =0;
                $idata->    aggregate_reactive_pwr_abs =0;
                $idata->    average_pf=0;
                $idata->    mdc_read_datetime =date('Y-m-d H:i:s');
                $idata->    db_datetime =date('Y-m-d H:i:s');
                $idata->save();
                return result(1,'Data inserted',$rtl);
        }  
        else
        {
            return result(0,'Failed! api_flag is not apitransv21');
        }      
    }

    public function events(Request $request)
    {
        $validator = Validator::make($request->all(), [
                    'event_code' => 'required|integer',
                    'global_device_id' => 'required',
                    'event_datetime' => 'required',
                    // 'event_description'
                ]);
        
                if ($validator->fails()) return result(0,'Validation Error.', $validator->errors(), 422);

        // return response()->json($request->all());
          $data=['msn'=>$request->msn,
                  'global_device_id'=>$request->global_device_id,
                  'event_datetime'=>$request->event_datetime,
                  'event_code'=>$request->event_code,
                  'event_description'=>$request->event_description,
                  'mdc_read_datetime'=>date('Y-m-d H:i:s'),
                  'db_datetime'=>date('Y-m-d H:i:s')
                ]  ;  
         if(!empty($data))
         EventM::insert($data);
          echo json_encode('Event Save Successfully');
    }




}
