<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\AutoSwitching;
use App\Models\DeviceThreshold;
use App\Models\EventM;
use App\Models\MeterVisual;
use Illuminate\Http\Request;
use App\Models\Transformer;
use Illuminate\Support\Facades\Validator;
use DB;
use Carbon\Carbon;
use Exception;

// ------------------------------------------------------------ temporary electrocure ----------------------------------------------------------

// Route::get('datacollection.php', [ElectricureTempApiController::class, 'datacollection']);  
// Route::get('control.php', [ElectricureTempApiController::class, 'getControl']); 
// Route::get('poke_device.php', [ElectricureTempApiController::class, 'poke_device']); 
// // Route::get('datapopulation.php', [ElectricureTempApiController::class, 'triggerDataPopulation']); 
// Route::get('datapopulation.php', function () {
//     data_population();
// });
// ------------------------------------------------------------ temporary electrocure ----------------------------------------------------------


class ElectricureTempApiController extends Controller
{

    public function datacollection(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'moduleid' => 'required|string',
            'packet_date_time' => 'required|date_format:Y-m-d H:i:s',
            'api_flag' => 'required|string',
        ]);


        if ($validator->fails()) {
            return response()->json(['success' => false, 'errors' => $validator->errors()], 400);
        }

        
        try {
            $moduleid = $request->input('moduleid');
            $packetDateTime = $request->input('packet_date_time');
            $serverDateTime = now();
            $apiFlag = $request->input('api_flag');
            $current_users=explode(',',$request->current_users);
            $pf_users=explode(',',$request->pf_users);

            if ($apiFlag == 'apiucv20') {
                $data = [
                    'moduleid' => $moduleid,
                    'packet_date_time' => $packetDateTime,
                    'v_red' => $request->input('v_red'),
                    'v_blue' => $request->input('v_blue'),
                    'v_yellow' => $request->input('v_yellow'),
                    'server_date_time' => $serverDateTime,
                ];
                // Handling dynamic current and power factor values
                for ($i = 1; $i <= 32; $i++) {
                    $data['i' . $i] = (float)$current_users[$i-1];
                    $data['pf' . $i] = (float)$pf_users[$i-1];
                }

                // return response()->json($data);

                DB::table('electrocure_raw_current_log')->insert($data);
            } elseif ($apiFlag == 'apiukwh10') {
                $data = [
                    'moduleid' => $moduleid,
                    'packet_date_time' => $packetDateTime,
                    'server_date_time' => $serverDateTime,
                ];
                $kwh_users=explode(',',$request->kwh_users);

                // Handling dynamic kWh values
                for ($i = 1; $i <= 32; $i++) {
                    $data['kwh' . $i] = (float)$kwh_users[$i-1];
                }

                $data['peak'] = (int)$request->input('peak');
                // return response()->json($data);

                DB::table('electrocure_raw_kwh_log')->insert($data);
            } else {
                return response()->json(['success' => false, 'message' => 'Invalid API flag provided.'], 400);
            }

            return response()->json(['success' => true, 'message' => 'Data inserted successfully.']);
        } catch (\Exception $e) {
            // Log::error('Error inserting data: ' . $e->getMessage());
            return response()->json(['success' => false, 'message' => 'An error occurred.'], 500);
        }
    }
   

    public function getControl(Request $request)
    {
        // Validate incoming parameters
        $validated = $request->validate([
            'subdivid' => 'required',
            'moduleid' => 'required|string',
            'api_flag' => 'required|string|in:apidblcv20',
        ]);
        // Get parameters
        $subdivid = $validated['subdivid'];
        $moduleid = $validated['moduleid'];
        $api_flag = $validated['api_flag'];

        // Define the DB type

        try {
            // Query based on api_flag
            if ($api_flag == 'apidblcv20') {
                $status_out = DB::table('electrocure_db_status')->where(['dbid' => $moduleid])->first();
            }

            if ($status_out) {
                if ($api_flag == 'apidblcv20') {
                    // Split the status_out string
                    $split_status_out = str_split($status_out->status_out, 1);
                    // return response()->json([
                    //     'switch' => implode(',', $split_status_out),
                    // ]);
                   
                    return response('switch=' . implode(',', $split_status_out), 200)
                    ->header('Content-Type', 'text/plain');
                }
            } else {
                return response()->json(['error' => 'Data not found'], 404);
            }
        } catch (\Exception $e) {
            // Handle the exception
            return response()->json(['error' => 'An error occurred: ' . $e->getMessage()], 500);
        }
    }
    public function poke_device(Request $request)
    {
        // Validate the incoming parameters
        $validated = $request->validate([
            'subdivid' => 'required',
            'moduleid' => 'required|string',
            'api_flag' => 'required|string|in:apiukwh20', // Validate that API flag is valid
        ]);

        $subdivid = $validated['subdivid'];
        $moduleid = $validated['moduleid'];
        $api_flag = $validated['api_flag'];


        try {
            // Connect to the database dynamically

            $string = "";
            $frommontharray = [12, 1, 3, 6, 9];
            $tomontharray = [12, 2, 5, 8, 11];
            $fromtimearray = ['2000-01-01 17:00:00', '2000-01-01 18:00:00', '2000-01-01 19:00:00', '2000-01-01 18:00:00'];
            $totimearray = ['2000-01-01 21:00:00', '2000-01-01 22:00:00', '2000-01-01 23:00:00', '2000-01-01 22:00:00'];

            $time = Carbon::now()->format('H');
            $month = Carbon::now()->format('m');

            $pkflg = 0;
            $string = "";

            // Check for peak/off-peak periods
            foreach (range(0, 3) as $index) {
                $frommonth = $frommontharray[$index];
                $tomonth = $tomontharray[$index];
                $fromtime = Carbon::parse($fromtimearray[$index])->format('H');
                $totime = Carbon::parse($totimearray[$index])->format('H');

                if ($frommonth > $tomonth) {
                    $frommonth = 0;
                }

                if (($month == $frommonth || $month > $frommonth) && ($month == $tomonth || $month < $tomonth)) {
                    if (($time == $fromtime || $time > $fromtime) && ($time == $totime || $time < $totime)) {
                        $pkflg = 1;
                        $string = $string . "peak=1,kwh=";
                        break;
                    } else {
                        $pkflg = 0;
                        $string = $string . "peak=0,kwh=";
                        break;
                    }
                }
            }

            $datetime = Carbon::now()->format('y-m-d H:i:s');

            // Check API flag
            if ($api_flag == 'apiukwh20') {
                if ($pkflg == 0) {
                          $q = ['kwhoffpeak1', 'kwhoffpeak2', 'kwhoffpeak3', 'kwhoffpeak4', 'kwhoffpeak5', 'kwhoffpeak6', 
                          'kwhoffpeak7', 'kwhoffpeak8', 'kwhoffpeak9', 'kwhoffpeak10', 'kwhoffpeak11', 'kwhoffpeak12', 
                          'kwhoffpeak13', 'kwhoffpeak14', 'kwhoffpeak15', 'kwhoffpeak16', 'kwhoffpeak17', 'kwhoffpeak18', 
                          'kwhoffpeak19', 'kwhoffpeak20', 'kwhoffpeak21', 'kwhoffpeak22', 'kwhoffpeak23', 'kwhoffpeak24', 
                          'kwhoffpeak25', 'kwhoffpeak26', 'kwhoffpeak27', 'kwhoffpeak28', 'kwhoffpeak29', 'kwhoffpeak30', 
                          'kwhoffpeak31', 'kwhoffpeak32'];
                } else {
                    $q = ['kwhpeak1', 'kwhpeak2', 'kwhpeak3', 'kwhpeak4', 'kwhpeak5', 'kwhpeak6', 'kwhpeak7', 'kwhpeak8', 
                          'kwhpeak9', 'kwhpeak10', 'kwhpeak11', 'kwhpeak12', 'kwhpeak13', 'kwhpeak14', 'kwhpeak15', 'kwhpeak16', 
                          'kwhpeak17', 'kwhpeak18', 'kwhpeak19', 'kwhpeak20', 'kwhpeak21', 'kwhpeak22', 'kwhpeak23', 'kwhpeak24', 
                          'kwhpeak25', 'kwhpeak26', 'kwhpeak27', 'kwhpeak28', 'kwhpeak29', 'kwhpeak30', 'kwhpeak31', 'kwhpeak32'];
                }
                $results = DB::table('electrocure_connections_db')->select($q)->where(['dbid' => $moduleid])->first();
                if($results)
                {

                    foreach ($results as $row) {
                        // for ($i = 0; $i < 32; $i++) {
                            $string .= round($row, 2) . ",";
                            // $string .= round($row->kwhpeak . ($i + 1), 2) . ",";
                        // }
                    }
                    $string .= "dt=" . $datetime . ",";
                }
                else
                {
                    return response('Device Not Found', 200)->header('Content-Type', 'text/plain');

                }

                
            } 

            // return response()->json(['data' => $string]);
            return response($string, 200)->header('Content-Type', 'text/plain');
            
        } catch (\PDOException $e) {
            return response($e->getMessage(), 500)->header('Content-Type', 'text/plain');
        }
    }
    
   

}

// helper code 
function data_population()
    {

      $dbhost = "localhost";
      $dbuser = "root";
      $dbpass =  "rootroot";
      $dbname =  "apms-single";
      $db = new mysqli($dbhost, $dbuser, $dbpass, $dbname);

      $sql = "select * from electrocure_connections order by cid ";

      $arrayData = array();
      $arrayData_index = array();
      $db_update_index = array();
        $db_index = 0;
        $last_index = '0';
        $result1 = mysqli_query($db,$sql);
        
        while($row = mysqli_fetch_array($result1))
        {  
            $new_index = explode('CN',$row['cid']);
            
            $last_index = $new_index[0];
                $arrayData_index[]=$last_index;
                
                array_push($arrayData,array($row['cid'],$row['offpeak'],$row['peak'],$row['datetime'],$row['v1'],$row['v2'],$row['v3'],$row['c1'],$row['c2'],$row['c3'],$row['pf1'],$row['pf2'],$row['pf3'],$row['kwhpeak1'],$row['kwhpeak2'],$row['kwhpeak3'],$row['kwhoffpeak1'],$row['kwhoffpeak2'],$row['kwhoffpeak3'],$row['slot1'],$row['slot2'],$row['slot3'],$last_index));
        }


        $sql = "SELECT a.* from electrocure_raw_current_log a
            inner join(SELECT moduleid, MAX(server_date_time) pdt
            from electrocure_raw_current_log where server_date_time > now() - interval 4 minute  GROUP BY moduleid)b on a.moduleid = b.moduleid and a.server_date_time = b.pdt and a.server_date_time >now() - interval 4 minute";

        $result = mysqli_query($db,$sql);

        $insert = "INSERT INTO electrocure_current_logs (cid, v1,v2,v3,c1,c2,c3,pf1,pf2,pf3,datetime) VALUES";
        $index_row= 0 ;
        $count = mysqli_num_rows($result);
        $index= 0;
        $cn_update_index = array();
        while($rowdata = mysqli_fetch_array($result))
        {
          $db_index = array_search($rowdata['moduleid'],$arrayData_index);
          while ($rowdata['moduleid']==$arrayData[$db_index][22])
          {
              $rowdata['server_date_time'] = date('Y-m-d H:i:00',strtotime($rowdata['server_date_time']));
              if($index == 0)
              {
                  $index = 1;
              }
              else
              $insert = $insert . ","; 
              
              if ($arrayData[$db_index][20]== -1)
              {
                  $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['v_red']/100)."','".($rowdata['v_blue']/100)."','".($rowdata['v_yellow']/100)."','".($rowdata['i'.$arrayData[$db_index][19]]/100)."',0,0,'".($rowdata['pf'.$arrayData[$db_index][19]]/100)."',0,0,'".$rowdata['server_date_time']."')";
                  $arrayData[$db_index][3]=$rowdata['server_date_time'];
                  $arrayData[$db_index][4]=$rowdata['v_red']/100;
                  $arrayData[$db_index][5]=$rowdata['v_blue']/100;
                  $arrayData[$db_index][6]=$rowdata['v_yellow']/100;
                  $arrayData[$db_index][7]=($rowdata['i'.$arrayData[$db_index][19]]/100);
                  $arrayData[$db_index][10]=$rowdata['pf'.$arrayData[$db_index][19]]/100;
                  
              }
              elseif ($arrayData[$db_index][21]== -1)
              {
                  $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['v_red']/100)."','".($rowdata['v_blue']/100)."','".($rowdata['v_yellow']/100)."','".($rowdata['i'.$arrayData[$db_index][19]]/100)."','".($rowdata['i'.$arrayData[$db_index][20]]/100)."',0,'".($rowdata['pf'.$arrayData[$db_index][19]]/100)."','".($rowdata['pf'.$arrayData[$db_index][20]]/100)."',0,'".$rowdata['server_date_time']."')";
                  $arrayData[$db_index][3]=$rowdata['server_date_time'];
                  $arrayData[$db_index][4]=$rowdata['v_red']/100;
                  $arrayData[$db_index][5]=$rowdata['v_blue']/100;
                  $arrayData[$db_index][6]=$rowdata['v_yellow']/100;
                  $arrayData[$db_index][7]=($rowdata['i'.$arrayData[$db_index][19]]/100);
                  $arrayData[$db_index][8]=($rowdata['i'.$arrayData[$db_index][20]]/100);
                  $arrayData[$db_index][10]=$rowdata['pf'.$arrayData[$db_index][19]]/100;
                  $arrayData[$db_index][11]=$rowdata['pf'.$arrayData[$db_index][20]]/100;
              }
              else
              {
              $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['v_red']/100)."','".($rowdata['v_blue']/100)."','".($rowdata['v_yellow']/100)."','".($rowdata['i'.$arrayData[$db_index][19]]/100)."','".($rowdata['i'.$arrayData[$db_index][20]]/100)."','".($rowdata['i'.$arrayData[$db_index][21]]/100)."','".($rowdata['pf'.$arrayData[$db_index][19]]/100)."','".($rowdata['pf'.$arrayData[$db_index][20]]/100)."','".($rowdata['pf'.$arrayData[$db_index][21]]/100)."','".$rowdata['server_date_time']."')"; 
                  $arrayData[$db_index][3]=$rowdata['server_date_time'];
                  $arrayData[$db_index][4]=$rowdata['v_red']/100;
                  $arrayData[$db_index][5]=$rowdata['v_blue']/100;
                  $arrayData[$db_index][6]=$rowdata['v_yellow']/100;
                  $arrayData[$db_index][7]=($rowdata['i'.$arrayData[$db_index][19]]/100);
                  $arrayData[$db_index][8]=($rowdata['i'.$arrayData[$db_index][20]]/100);
                  $arrayData[$db_index][9]=($rowdata['i'.$arrayData[$db_index][21]]/100);
                  $arrayData[$db_index][10]=$rowdata['pf'.$arrayData[$db_index][19]]/100;
                  $arrayData[$db_index][11]=$rowdata['pf'.$arrayData[$db_index][20]]/100;
                  $arrayData[$db_index][12]=$rowdata['pf'.$arrayData[$db_index][21]]/100;
              }
              
              $cn_update_index[] = $db_index;
              $db_index = $db_index + 1;
              if($db_index == sizeof($arrayData))
              {break;}
          }
         }


            // die($insert);
            $result = $db->query($insert);


            $sql = "SELECT a.* from electrocure_raw_kwh_log a
                inner join(SELECT moduleid, MAX(server_date_time) pdt
                FROM electrocure_raw_kwh_log where server_date_time > now() - interval 4 minute  GROUP BY moduleid)b on a.moduleid = b.moduleid and a.server_date_time = b.pdt and a.server_date_time >now() - interval 4 minute";
        
                $result = mysqli_query($db,$sql);
                $insert = "INSERT INTO `electrocure_kwh_logs`( `cid`, `kwh1`, `kwh2`, `kwh3`, `offpeak`, `peak`, `offpkunits`, `pkunits`, `pkflg`, `datetime`) VALUES";
            $index_row= 0 ;
            $count = mysqli_num_rows($result);
            $index_l= 0;
            while($rowdata = mysqli_fetch_array($result))
            {
      
      
      
                  $db_index = array_search($rowdata['moduleid'],$arrayData_index);
          
          
                while($rowdata['moduleid']==$arrayData[$db_index][22])
                {
                                $rowdata['server_date_time'] = date('Y-m-d H:i:00',strtotime($rowdata['server_date_time']));

                    $datetime 	= $rowdata['server_date_time'];
                        $time = date('H',strtotime($datetime));
                        $month = date('m',strtotime($datetime));
                        $frommontharray = array(12,3,6,9);
                        $tomontharray = array(2,5,8,11);
                        $fromtimearray = array('2000-01-01 17:00:00','2000-01-01 18:00:00','2000-01-01 19:00:00','2000-01-01 18:00:00');
                        $totimearray = array('2000-01-01 21:00:00', '2000-01-01 22:00:00','2000-01-01 23:00:00','2000-01-01 22:00:00');
                        $index = 0;
                    
                    $ispeak = $rowdata['peak'];
                    if($index_l == 0)
                    {
                        $index_l = 1;
                    }
                    else
                    $insert = $insert . ","; 
                    $pkunits = 0;
                    $offpkunits = 0;
                    if ($arrayData[$db_index][20]== -1)
                    {
                        
                        if($ispeak == 1)
                        {
                            $peak = $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $pkunits = $peak - $arrayData[$db_index][2] ;
                            $offpeak = $arrayData[$db_index][1];
                            $arrayData[$db_index][2] = $peak;
                            $arrayData[$db_index][13] = $peak;
                        }
                        else
                        {
                            $offpeak = $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $offpkunits = $offpeak - $arrayData[$db_index][1] ;
                            $peak = $arrayData[$db_index][2];
                            $arrayData[$db_index][1] = $offpeak;
                            $arrayData[$db_index][16] = $offpeak;
                        }
                        $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['kwh'.$arrayData[$db_index][19]]/100)."',0,0,'".$offpeak."','".$peak."','".$pkunits."','".$offpkunits."','".$ispeak."','".$rowdata['server_date_time']."')";
                    //    echo $insert;
                    }
                    elseif ($arrayData[$db_index][21]== -1)
                    {
                        if($ispeak == 1)
                        {
                            $peak = $rowdata['kwh'.$arrayData[$db_index][19]]/100 + $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                            $pkunits = $peak - $arrayData[$db_index][2] ;
                            $offpeak = $arrayData[$db_index][1];
                            $arrayData[$db_index][2] = $peak;
                        $arrayData[$db_index][14] = $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $arrayData[$db_index][15] = $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                        }
                        else
                        {
                            $offpeak = $rowdata['kwh'.$arrayData[$db_index][19]]/100 + $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                            $offpkunits = $offpeak - $arrayData[$db_index][1] ;
                            $peak = $arrayData[$db_index][2];
                            $arrayData[$db_index][1] = $offpeak;
                            $arrayData[$db_index][16] = $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $arrayData[$db_index][17] = $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                        }
                        $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['kwh'.$arrayData[$db_index][19]]/100)."','".($rowdata['kwh'.$arrayData[$db_index][20]]/100)."',0,'".$offpeak."','".$peak."','".$pkunits."','".$offpkunits."','".$ispeak."','".$rowdata['server_date_time']."')";
                    }
                    else
                    {
                        if($ispeak == 1)
                        {
                            $peak = $rowdata['kwh'.$arrayData[$db_index][19]]/100+ $rowdata['kwh'.$arrayData[$db_index][20]]/100 + $rowdata['kwh'.$arrayData[$db_index][21]/100];
                            $pkunits = round($peak - $arrayData[$db_index][2],2) ;
                            $offpeak = $arrayData[$db_index][1];
                            $arrayData[$db_index][2] = $peak;
                            $arrayData[$db_index][13] =  $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $arrayData[$db_index][14] =  $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                            $arrayData[$db_index][15] =  $rowdata['kwh'.$arrayData[$db_index][21]]/100;
                        }
                        else
                        {
                            $offpeak = $rowdata['kwh'.$arrayData[$db_index][19]]/100 + $rowdata['kwh'.$arrayData[$db_index][20]]/100+$rowdata['kwh'.$arrayData[$db_index][21]]/100;
                            $offpkunits =round($offpeak - $arrayData[$db_index][1],2) ;
                            $peak = $arrayData[$db_index][2];
                            $arrayData[$db_index][1] = $offpeak;
                            $arrayData[$db_index][16] =  $rowdata['kwh'.$arrayData[$db_index][19]]/100;
                            $arrayData[$db_index][17] =  $rowdata['kwh'.$arrayData[$db_index][20]]/100;
                            $arrayData[$db_index][18] =  $rowdata['kwh'.$arrayData[$db_index][21]]/100;
                        }
                        $insert = $insert . "('".$arrayData[$db_index][0]."','".($rowdata['kwh'.$arrayData[$db_index][19]]/100)."','".($rowdata['kwh'.$arrayData[$db_index][20]]/100)."','".($rowdata['kwh'.$arrayData[$db_index][21]]/100)."','".$offpeak."','".$peak."','".$offpkunits."','".$pkunits."','".$ispeak."','".$rowdata['server_date_time']."')";
                        
                    }
                    
                    $db_index = $db_index + 1;
                    if($db_index == sizeof($arrayData))
                    {break;}
                }
            }
            $result = $db->query($insert);



            for ($i = 0; $i<count($cn_update_index);$i++)
            {
                $sql = "update  electrocure_connections set `offpeak` = '". $arrayData[$cn_update_index[$i]][1]."',
                    `peak` = '". $arrayData[$cn_update_index[$i]][2]."',
                    `datetime` = '". $arrayData[$cn_update_index[$i]][3]."',
                    `v1` = '". $arrayData[$cn_update_index[$i]][4]."',
                    `v2` = '". $arrayData[$cn_update_index[$i]][5]."',
                    `v3` = '". $arrayData[$cn_update_index[$i]][6]."',
                    `c1` = '". $arrayData[$cn_update_index[$i]][7]."',
                    `c2` = '". $arrayData[$cn_update_index[$i]][8]."',
                    `c3` = '". $arrayData[$cn_update_index[$i]][9]."',
                    `pf1` = '". $arrayData[$cn_update_index[$i]][10]."',
                    `pf2` = '". $arrayData[$cn_update_index[$i]][11]."',
                    `pf3` = '". $arrayData[$cn_update_index[$i]][12]."',
                    `kwhpeak1` = '". $arrayData[$cn_update_index[$i]][13]."',
                    `kwhpeak2` = '". $arrayData[$cn_update_index[$i]][14]."',
                    `kwhpeak3` = '". $arrayData[$cn_update_index[$i]][15]."',
                    `kwhoffpeak1` = '". $arrayData[$cn_update_index[$i]][16]."',
                    `kwhoffpeak2` = '". $arrayData[$cn_update_index[$i]][17]."',
                    `kwhoffpeak3` = '". $arrayData[$cn_update_index[$i]][18]."'
                    where cid = '". $arrayData[$cn_update_index[$i]][0]."'";
                    $result = $db->query($sql);
                    
            }






      
      $sql = "select * from electrocure_connections_db order by dbid ";

      $arrayData = array();
      $arrayData_index = array();
      $db_update_index = array();
        //	$yeild_update_index = array();
        $db_index = 0;
        $result = mysqli_query($db,$sql);
        
        while($row = mysqli_fetch_array($result))
        {  
            $arrayData_index[]=$row['dbid'];
                    array_push($arrayData,array($row['dbid'],
                                                $row['datetime'],
                                                $row['v1'],$row['v2'],$row['v3'],
                                                $row['c1'],$row['c2'],$row['c3'],
                                                $row['c4'],$row['c5'],$row['c6'],
                                                $row['c7'],$row['c8'],$row['c9'],                                           $row['c10'],$row['c11'],$row['c12'],                                           $row['c13'],$row['c14'],$row['c15'],                                           $row['c16'],$row['c17'],$row['c18'],                                            $row['c19'],$row['c20'],$row['c21'],                                            $row['c22'],$row['c23'],$row['c24'],                                            $row['c25'],$row['c26'],$row['c27'],                                            $row['c28'],$row['c29'],$row['c30'],                                            $row['c31'],$row['c32'],$row['pf1'],                                           $row['pf2'],$row['pf3'],$row['pf4'],                                            $row['pf5'],$row['pf6'],$row['pf7'],                                            $row['pf8'],$row['pf9'],$row['pf10'],                                            $row['pf11'],$row['pf12'],$row['pf13'],                                            $row['pf14'],$row['pf15'],$row['pf16'],                                            $row['pf17'],$row['pf18'],$row['pf19'],                                            $row['pf20'],$row['pf21'],$row['pf22'],                                            $row['pf23'],$row['pf24'],$row['pf25'],                                            $row['pf26'],$row['pf27'],$row['pf28'],                                            $row['pf29'],$row['pf30'],$row['pf31'],                                           $row['pf32'],$row['kwhpeak1'],$row['kwhpeak2'],                                          $row['kwhpeak3'],$row['kwhpeak4'],$row['kwhpeak5'],                                      $row['kwhpeak6'],$row['kwhpeak7'],$row['kwhpeak8'],                                      $row['kwhpeak9'],$row['kwhpeak10'],$row['kwhpeak11'],                                    $row['kwhpeak12'],$row['kwhpeak13'],$row['kwhpeak14'],                                  $row['kwhpeak15'],$row['kwhpeak16'],$row['kwhpeak17'],                              $row['kwhpeak18'],$row['kwhpeak19'],$row['kwhpeak20'],                                $row['kwhpeak21'],$row['kwhpeak22'],$row['kwhpeak23'],                                  $row['kwhpeak24'],$row['kwhpeak25'],$row['kwhpeak26'],
                                                $row['kwhpeak27'],$row['kwhpeak28'],$row['kwhpeak29'],$row['kwhpeak30'],$row['kwhpeak31'],$row['kwhpeak32'],$row['kwhoffpeak1'],$row['kwhoffpeak2'],$row['kwhoffpeak3'],$row['kwhoffpeak4'],$row['kwhoffpeak5'],$row['kwhoffpeak6'],$row['kwhoffpeak7'],$row['kwhoffpeak8'],$row['kwhoffpeak9'],$row['kwhoffpeak10'],$row['kwhoffpeak11'],$row['kwhoffpeak12'],$row['kwhoffpeak13'],$row['kwhoffpeak14'],$row['kwhoffpeak15'],$row['kwhoffpeak16'],$row['kwhoffpeak17'],$row['kwhoffpeak18'],$row['kwhoffpeak19'],$row['kwhoffpeak20'],$row['kwhoffpeak21'],$row['kwhoffpeak22'],$row['kwhoffpeak23'],$row['kwhoffpeak24'],$row['kwhoffpeak25'],$row['kwhoffpeak26'],$row['kwhoffpeak27'],$row['kwhoffpeak28'],$row['kwhoffpeak29'],$row['kwhoffpeak30'],$row['kwhoffpeak31'],$row['kwhoffpeak32']));	
        } 

        $sql = "SELECT a.* from electrocure_raw_current_log a
          inner join(SELECT moduleid, MAX(server_date_time) pdt
          from electrocure_raw_current_log where server_date_time > now() - interval 4 minute  GROUP BY moduleid)b on a.moduleid = b.moduleid and a.server_date_time = b.pdt and a.server_date_time >now() - interval 4 minute";

        $result = mysqli_query($db,$sql);

        while($rowdata = mysqli_fetch_array($result))
        {
            $db_index = array_search($rowdata['moduleid'],$arrayData_index);
            // echo $arrayData[$db_index][0].' ';
            // echo $rowdata['moduleid'].' ';
            
            if ($rowdata['moduleid']==$arrayData[$db_index][0])
            {
                $rowdata['server_date_time'] = date('Y-m-d H:i:00',strtotime($rowdata['server_date_time']));

                $arrayData[$db_index][1] = $rowdata['server_date_time'];
                echo  $arrayData[$db_index][1].' ';
                $arrayData[$db_index][2] = $rowdata['v_red']/100;
                $arrayData[$db_index][3] = $rowdata['v_blue']/100;
                $arrayData[$db_index][4] = $rowdata['v_yellow']/100;
                for ($i = 5; $i<37 ; $i=$i+1)
                $arrayData[$db_index][$i] = $rowdata['i'.($i-4)]/100;
                
                for ($i = 37; $i<69 ; $i=$i+1)
                $arrayData[$db_index][$i] = $rowdata['pf'.($i-36)]/100;
                
                $db_update_index[]=$db_index;
                
            }
        }


        $sql = "SELECT a.* from electrocure_raw_kwh_log a
                inner join(SELECT moduleid, MAX(server_date_time) pdt
                from electrocure_raw_kwh_log where server_date_time > now() - interval 4 minute  GROUP BY moduleid)b on a.moduleid = b.moduleid and a.server_date_time = b.pdt and a.server_date_time >now() - interval 4 minute";
        $result = mysqli_query($db,$sql);    
        while($rowdata = mysqli_fetch_array($result))
        {
        
        
        
                    $db_index = array_search($rowdata['moduleid'],$arrayData_index);
                    if ($rowdata['moduleid']==$arrayData[$db_index][0])
                    {
                        $datetime 	= $rowdata['server_date_time'];
                                $time = date('H',strtotime($datetime));
                                $month = date('m',strtotime($datetime));
                                $frommontharray = array(12,3,6,9);
                                $tomontharray = array(2,5,8,11);
                                $fromtimearray = array('2000-01-01 17:00:00','2000-01-01 18:00:00','2000-01-01 19:00:00','2000-01-01 18:00:00');
                                $totimearray = array('2000-01-01 21:00:00', '2000-01-01 22:00:00','2000-01-01 23:00:00','2000-01-01 22:00:00');
                                $index = 0;
                            
                        $ispeak = $rowdata['peak'];
                        if($ispeak)
                        {
                            for ($i = 69; $i<101 ; $i=$i+1)
                            $arrayData[$db_index][$i] = $rowdata['kwh'.($i-68)]/100;
                        }
                        else
                        {
                            for ($i = 101; $i<132 ; $i=$i+1)
                            $arrayData[$db_index][$i] = $rowdata['kwh'.($i-100)]/100;
                        }
                    }
        }

        for ($i = 0; $i<count($db_update_index);$i++)
        {
            $q = "UPDATE `electrocure_connections_db` SET 
            `datetime` = '". $arrayData[$db_update_index[$i]][1]."',
            `v1` = '". $arrayData[$db_update_index[$i]][2]."',`v2` = '". $arrayData[$db_update_index[$i]][3]."', `v3` = '".$arrayData[$db_update_index[$i]][4]."',
            `c1`='".$arrayData[$db_update_index[$i]][5]."',`c2`='".$arrayData[$db_update_index[$i]][6]."',
            `c3`='".$arrayData[$db_update_index[$i]][7]."',`c4`='".$arrayData[$db_update_index[$i]][8]."',
            `c5`='".$arrayData[$db_update_index[$i]][9]."',`c6`='".$arrayData[$db_update_index[$i]][10]."',
            `c7`='".$arrayData[$db_update_index[$i]][11]."',`c8`='".$arrayData[$db_update_index[$i]][12]."',
            `c9`='".$arrayData[$db_update_index[$i]][13]."',`c10`='".$arrayData[$db_update_index[$i]][14]."',
            `c11`='".$arrayData[$db_update_index[$i]][15]."',`c12`='".$arrayData[$db_update_index[$i]][16]."',
            `c13`='".$arrayData[$db_update_index[$i]][17]."',`c14`='".$arrayData[$db_update_index[$i]][18]."',
            `c15`='".$arrayData[$db_update_index[$i]][19]."',`c16`='".$arrayData[$db_update_index[$i]][20]."',
            `c17`='".$arrayData[$db_update_index[$i]][21]."',`c18`='".$arrayData[$db_update_index[$i]][22]."',
            `c19`='".$arrayData[$db_update_index[$i]][23]."',`c20`='".$arrayData[$db_update_index[$i]][24]."',
            `c21`='".$arrayData[$db_update_index[$i]][25]."',`c22`='".$arrayData[$db_update_index[$i]][26]."',
            `c23`='".$arrayData[$db_update_index[$i]][27]."',`c24`='".$arrayData[$db_update_index[$i]][28]."',
            `c25`='".$arrayData[$db_update_index[$i]][29]."',`c26`='".$arrayData[$db_update_index[$i]][30]."',
            `c27`='".$arrayData[$db_update_index[$i]][31]."',`c28`='".$arrayData[$db_update_index[$i]][32]."',
            `c29`='".$arrayData[$db_update_index[$i]][33]."',`c30`='".$arrayData[$db_update_index[$i]][34]."',
            `c31`='".$arrayData[$db_update_index[$i]][35]."',`c32`='".$arrayData[$db_update_index[$i]][36]."',
            `pf1`='".$arrayData[$db_update_index[$i]][37]."',`pf2`='".$arrayData[$db_update_index[$i]][38]."',
            `pf3`='".$arrayData[$db_update_index[$i]][39]."',`pf4`='".$arrayData[$db_update_index[$i]][40]."',
            `pf5`='".$arrayData[$db_update_index[$i]][41]."',`pf6`='".$arrayData[$db_update_index[$i]][42]."',
            `pf7`='".$arrayData[$db_update_index[$i]][43]."',`pf8`='".$arrayData[$db_update_index[$i]][44]."',
            `pf9`='".$arrayData[$db_update_index[$i]][45]."',`pf10`='".$arrayData[$db_update_index[$i]][46]."',
            `pf11`='".$arrayData[$db_update_index[$i]][47]."',`pf12`='".$arrayData[$db_update_index[$i]][48]."',
            `pf13`='".$arrayData[$db_update_index[$i]][49]."',`pf14`='".$arrayData[$db_update_index[$i]][50]."',
            `pf15`='".$arrayData[$db_update_index[$i]][51]."',`pf16`='".$arrayData[$db_update_index[$i]][52]."',
            `pf17`='".$arrayData[$db_update_index[$i]][53]."',`pf18`='".$arrayData[$db_update_index[$i]][54]."',
            `pf19`='".$arrayData[$db_update_index[$i]][55]."',`pf20`='".$arrayData[$db_update_index[$i]][56]."',
            `pf21`='".$arrayData[$db_update_index[$i]][57]."',`pf22`='".$arrayData[$db_update_index[$i]][58]."',
            `pf23`='".$arrayData[$db_update_index[$i]][59]."',`pf24`='".$arrayData[$db_update_index[$i]][60]."',
            `pf25`='".$arrayData[$db_update_index[$i]][61]."',`pf26`='".$arrayData[$db_update_index[$i]][62]."',
            `pf27`='".$arrayData[$db_update_index[$i]][63]."',`pf28`='".$arrayData[$db_update_index[$i]][64]."',
            `pf29`='".$arrayData[$db_update_index[$i]][65]."',`pf30`='".$arrayData[$db_update_index[$i]][66]."',
            `pf31`='".$arrayData[$db_update_index[$i]][67]."',`pf32`='".$arrayData[$db_update_index[$i]][68]."',
            `kwhpeak1`='".$arrayData[$db_update_index[$i]][69]."',`kwhpeak2`='".$arrayData[$db_update_index[$i]][70]."',
            `kwhpeak3`='".$arrayData[$db_update_index[$i]][71]."',`kwhpeak4`='".$arrayData[$db_update_index[$i]][72]."',
            `kwhpeak5`='".$arrayData[$db_update_index[$i]][73]."',`kwhpeak6`='".$arrayData[$db_update_index[$i]][74]."',
            `kwhpeak7`='".$arrayData[$db_update_index[$i]][75]."',`kwhpeak8`='".$arrayData[$db_update_index[$i]][76]."',
            `kwhpeak9`='".$arrayData[$db_update_index[$i]][77]."',`kwhpeak10`='".$arrayData[$db_update_index[$i]][78]."',
            `kwhpeak11`='".$arrayData[$db_update_index[$i]][79]."',`kwhpeak12`='".$arrayData[$db_update_index[$i]][80]."',
            `kwhpeak13`='".$arrayData[$db_update_index[$i]][81]."',`kwhpeak14`='".$arrayData[$db_update_index[$i]][82]."',
            `kwhpeak15`='".$arrayData[$db_update_index[$i]][83]."',`kwhpeak16`='".$arrayData[$db_update_index[$i]][84]."',
            `kwhpeak17`='".$arrayData[$db_update_index[$i]][85]."',`kwhpeak18`='".$arrayData[$db_update_index[$i]][86]."',
            `kwhpeak19`='".$arrayData[$db_update_index[$i]][87]."',`kwhpeak20`='".$arrayData[$db_update_index[$i]][88]."',
            `kwhpeak21`='".$arrayData[$db_update_index[$i]][89]."',`kwhpeak22`='".$arrayData[$db_update_index[$i]][90]."',
            `kwhpeak23`='".$arrayData[$db_update_index[$i]][91]."',`kwhpeak24`='".$arrayData[$db_update_index[$i]][92]."',
            `kwhpeak25`='".$arrayData[$db_update_index[$i]][93]."',`kwhpeak26`='".$arrayData[$db_update_index[$i]][94]."',
            `kwhpeak27`='".$arrayData[$db_update_index[$i]][95]."',`kwhpeak28`='".$arrayData[$db_update_index[$i]][96]."',
            `kwhpeak29`='".$arrayData[$db_update_index[$i]][97]."',`kwhpeak30`='".$arrayData[$db_update_index[$i]][98]."',
            `kwhpeak31`='".$arrayData[$db_update_index[$i]][99]."',`kwhpeak32`='".$arrayData[$db_update_index[$i]][100]."',
            `kwhoffpeak1`='".$arrayData[$db_update_index[$i]][101]."',`kwhoffpeak2`='".$arrayData[$db_update_index[$i]][102]."',
            `kwhoffpeak3`='".$arrayData[$db_update_index[$i]][103]."',`kwhoffpeak4`='".$arrayData[$db_update_index[$i]][104]."',
            `kwhoffpeak5`='".$arrayData[$db_update_index[$i]][105]."',`kwhoffpeak6`='".$arrayData[$db_update_index[$i]][106]."',
            `kwhoffpeak7`='".$arrayData[$db_update_index[$i]][107]."',`kwhoffpeak8`='".$arrayData[$db_update_index[$i]][108]."',
            `kwhoffpeak9`='".$arrayData[$db_update_index[$i]][109]."',`kwhoffpeak10`='".$arrayData[$db_update_index[$i]][110]."',
            `kwhoffpeak11`='".$arrayData[$db_update_index[$i]][111]."',`kwhoffpeak12`='".$arrayData[$db_update_index[$i]][112]."',
            `kwhoffpeak13`='".$arrayData[$db_update_index[$i]][113]."',`kwhoffpeak14`='".$arrayData[$db_update_index[$i]][114]."',
            `kwhoffpeak15`='".$arrayData[$db_update_index[$i]][115]."',`kwhoffpeak16`='".$arrayData[$db_update_index[$i]][116]."',
            `kwhoffpeak17`='".$arrayData[$db_update_index[$i]][117]."',`kwhoffpeak18`='".$arrayData[$db_update_index[$i]][118]."',
            `kwhoffpeak19`='".$arrayData[$db_update_index[$i]][119]."',`kwhoffpeak20`='".$arrayData[$db_update_index[$i]][120]."',
            `kwhoffpeak21`='".$arrayData[$db_update_index[$i]][121]."',`kwhoffpeak22`='".$arrayData[$db_update_index[$i]][122]."',
            `kwhoffpeak23`='".$arrayData[$db_update_index[$i]][123]."',`kwhoffpeak24`='".$arrayData[$db_update_index[$i]][124]."',
            `kwhoffpeak25`='".$arrayData[$db_update_index[$i]][125]."',`kwhoffpeak26`='".$arrayData[$db_update_index[$i]][126]."',
            `kwhoffpeak27`='".$arrayData[$db_update_index[$i]][127]."',`kwhoffpeak28`='".$arrayData[$db_update_index[$i]][128]."',
            `kwhoffpeak29`='".$arrayData[$db_update_index[$i]][129]."',`kwhoffpeak30`='".$arrayData[$db_update_index[$i]][130]."',
            `kwhoffpeak31`='".$arrayData[$db_update_index[$i]][131]."',`kwhoffpeak32`='".$arrayData[$db_update_index[$i]][132]."'
            WHERE dbid = '".$arrayData[$db_update_index[$i]][0]."'";
                $result = mysqli_query($db,$q);
        }

        echo 'Run Successfully';
    }
