<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Mail\ThankYouEmail;
use Illuminate\Support\Facades\Hash;
use App\Events\WelcomeMailProcessed;
use App\Models\ApiKey;
use Validator;

class RegisterController extends Controller
{

    // function test()
    // {
    //     echo json_encode('Testing');
    // }
    public function signup(Request $request)
    {
        $user = User::where('email', '=', $request->email)->first();
        if ($user != null) {
            if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
                $user = Auth::user();
                $user['last_login'] = now();
                $user->save();
                
                $user['token'] = $user->createToken('accessToken')->accessToken;
                $success['user'] = $user;
                
                
                return response()->json(['success' => true, 'message' => 'Login Successfully', 'data' => $user]);

            } else {
               
                $user->password = Hash::make($request->password);
                $user->save();
                
               // return response()->json(['success' => false, 'message' => 'Un Authorized']);
            }
        }

        $validator = Validator::make($request->all(), [

            'email' => [
                'required', 'string', 'max:255', 'unique:'.User::class,
            ],
            'password' => ['required'],

            'login_type' => [
                'required',
            ],
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->messages()->first(), 'success' => false]);
        }
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'login_type' => $request->login_type,
            'last_login' => now(),
        ]);

        $user['token'] = $user->createToken('accessToken')->accessToken;

    
        return response()->json(['message' => 'User Registered Successfully', 'success' => true, 'data' => $user]);
    }

    // public function login(Request $request)
    // {

    //     if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
    //         $user = Auth::user();
    //         $user['token'] = $user->createToken('accessToken')->accessToken;
    //         // print_r($user['token']);
    //         // die;
    //         // ->plainTextToken;
    //         $success['user'] = $user;

    //         return response()->json(['success' => true, 'message' => 'Login Successfully', 'data' => $user]);

    //         return $this->sendResponse($success, 'User Login Successfully.');
    //     } else {
    //         return response()->json(['success' => false, 'message' => 'Un Authorized']);
    //     }
    // }

    public function authorization_service(Request $request)
    {
        // $validator = Validator::make($request->all(), [

        //     'email' => [
        //         'required', 'string', 'max:255',
        //     ],
        //     'password' => ['required'],

        //     'code' => [
        //         'required',
        //     ],
        // ]);

        // if ($validator->fails()) {
        //     return response()->json(['message' => $validator->messages()->first(), 'success' => false]);

        $username = $request->header('username');
        $password = $request->header('password');
        $code = $request->header('code');

        // pr($request->header('password'));
        // pr($request->header());
        if($username && $password &&   $code)
        {
            if (Auth::attempt(['email' => $username, 'password' => $password,'code'=>$code])) {
                $user = Auth::user();
                // $user['token'] = $user->createToken('accessToken')->accessToken;
                
                $key = base64_encode(uniqid()); // Generate a unique key
                $expiresAt = now()->addMinutes(60); // Key is valid for 30 minutes
                
                // Store the key in the database
                ApiKey::create([
                                    'user_id' => $user->id,
                                    'private_key' => $key,
                                    'expires_at' => $expiresAt,
                                ]);
    
                return response()->json(['status' => 1, 'privatekey' => $key, 'message' => 'Authentication Key will be expire in next 1 Hour']);
    
                // return $this->sendResponse($success, 'User Login Successfully.');
            } else {
                return response()->json(['status' => 0,  'message' => 'Un Authorized']);
            }
        }
        else
        {
            return response()->json(['status' => 0,  'message' => 'username , password and code Required']);
        }

        
        
    }

    public function deleteUser(Request $request)
    {

        $user = Auth::user();
        $user->email = 'Account_Del_'.date('Y-m-d').'_'.$user->email;
        $user->active=0;
        $user->save();

        // Revoke all tokens for the user
        $user->tokens()->delete();
            return response()->json(['success' => true, 'message' => 'Account Deleted Successfully']);
        // }
    }

    

   
}
