<?php

namespace App\Http\Controllers\Api;
use App\Jobs\SendCommandToDevice;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\AuxOperation;
use App\Models\BillingData;
use App\Models\EventM;
use App\Models\instantData;
use App\Models\LoadProfileData;
use App\Models\MeterVisual;
use App\Models\MonthlyBillingData;
use App\Models\TransactonStatus;
use App\Models\TrappingEventSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ApiC extends Controller
{



    // 3.3.1
    public function aux_relay_operation(Request $request)
    {
        // pr('test');
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'transactionid' => 'required|string',
            'request_datetime' => 'required|string',
            'relay_operate' => 'required|string|in:0,1',
            // 'privatekey' => 'required|string',

        ]);

        if ($validator->fails()) return result(0, $validator->errors()->first(),[], 422);

        // print_r($request->all());
        // die;
        // $data=AuxOperation::where('global_device_id',$request->global_devic_id)->get();
        $meter_with_aux=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
        $result=[];
        $command=[];
        if($meter_with_aux)
        {

            foreach ($meter_with_aux as $key => $value) {
                if($value->is_aux_relay==1)
                {
                    $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Command Saved Successfully  for Execution'];
                    MeterVisual::where(['global_device_id'=> $value->global_device_id])->update(['auxr_status'=>(int)$request->relay_operate,'auxr_datetime'=>$request->request_datetime]);
                   
                   
                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'aux_relay_operation','d'=>['auxr_status'=>(int)$request->relay_operate]];
                }
                else
                {
                    $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>0,'remarks'=>'Relay is not available in meter'];
                }
            }
        }
        else
        {
            
        }
        if(!empty($command))
        // pr($command);
        SendCommandToDevice::dispatch($command);
        
        // pr($meter_with_aux);

        return result(1,'MDC will turn off/onn all meters having individual status o/1',$result);
    }

    // 3.3.2
    public function time_synchronization(Request $request)
    {
        $validator = Validator::make($request->all(), [
            // 'global_device_id' => 'required|Array',
            'transactionid' => 'required|string',
            'global_device_id'=>'required|Array',
            'request_datetime'=>'required|string',


        ]);
        $command=[];
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);
        
         foreach ($request->global_device_id as $key => $value) {
            $command[]=['gid'=>$value,'at'=>'order','a'=>'update_time','d'=>['time'=>date('Y-m-d H:i:s')]];
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);


        // $data=TransactonStatus::where('transactionid ',$request->transactionid)->where('global_device_id ',$request->global_device_id)->first();
        // if($data && (!empty($data)))
        // {
            // $result=[];
            // foreach($request->global_device_id as $key  => $row)
            // {
            //     $data= new TransactonStatus();
            //     $result[]=['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>1,'remarks'=>'Command Save'];

            //     $data->request_cancelled=1;
            //     $data->global_device_id=$request->global_device_id;
            //     $data->type='Update Date and Type';
            //     $data->response_data='Transection Cancelled by MDM';
            //     $data->command_receiving_datetime=date('Y-m-d H:i:s');
            //     $data->status_level=0;
            //     $data->indv_status=0;
            //     $data->save();
            //     // return result(1, "Transection Cancelled having indv_status 1",$data,$request->transactionid);
            // // }
            // // else
            // // {
            //     // $result[]=['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>0,'remarks'=>'Transection Cant not be cancell'];
            //     // }

            // }
            return result(1,'Time will update for those device having inv_staus 1',[]);
        // else
            // return result(0,"Record not found aginst Transection Id : ".$request->transactionid,[],$request->transactionid);
            // return result(1,'Transection Cancelled having indv_status 1',['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>0,'remarks'=>'Record not Found Against TransectionId']);


        // $data=TransactonStatus::where('transactionid ',$request->transactionid)->get();
        // if($data)
        // return result('1', $data->type." response against requested meters",$data,$request->transactionid);
        // else
        //     return result('0',"Record not found aginst Transection Id : ".$request->transactionid,[],$request->transactionid);

    }

    // 3.3.3
    public function sanctioned_load_control(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'load_limit'=>'required|string',
            'maximum_retries'=>'required|string',
            'retry_interval'=>'required|string',
            'threshold_duration'=>'required|string',
            'retry_clear_interval'=>'required|string',



        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $meter_with_aux=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
        $result=[];
        $command=[];
        if($meter_with_aux)
        {

            foreach ($meter_with_aux as $key => $value) {
                    $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Sanctioned Load will be updated'];
                    $d=[
                        'sanc_datetime'=>$request->request_datetime,
                        'sanc_load_limit'=>$request->load_limit,
                        'sanc_maximum_retries'=>$request->maximum_retries,
                        'sanc_retry_interval'=>$request->retry_interval,
                        'sanc_threshold_duration'=>$request->threshold_duration,
                        'sanc_retry_clear_interval'=>$request->retry_clear_interval
                         ];
                    MeterVisual::where(['global_device_id'=> $value->global_device_id])
                    ->update($d);

                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'sanctioned_load_control','d'=>$d];         
            }
        }
        else
        {
            return result(0,'Data Not Found',[]);
        }
        if(!empty($command))
        SendCommandToDevice::dispatch($command);
        return result(1,'Sanctioned Load will be updated for meters having individual status as 1',$result);
    }
    // 3.3.4
    public function load_shedding_scheduling(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            // 'load_limit'=>'required|string',
            'start_datetime'=>'required|string',
            'end_datetime'=>'required|string',
            // 'retry_interval'=>'required|string',
            // 'threshold_duration'=>'required|string',
            'load_shedding_slabs'=>'required|Array',



        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if(!$data->isEmpty())
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Load Shedding Schedule will be updated'];
                     $d=[
                        //   'wsim_datetime'=>$request->request_datetime,
                          'lsch_start_datetime'=>$request->start_datetime,
                          'lsch_end_datetime'=>$request->end_datetime,
                          'lsch_load_shedding_slabs'=>$request->load_shedding_slabs
                     ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])
                     ->update($d);
                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'load_shedding_scheduling','d'=>$d];          
             }
         }
         else
         {
             return result(0,'Device Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Load Shedding Schedule will be updated for meters having individual status as 1',$result);

    }
      // 3.3.5
    public function update_time_of_use(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'activation_datetime'=>'required|string',
            'day_profile'=>'required|Array',
            'week_profile'=>'required|Array',
            'season_profile'=>'required|Array',
            'holiday_profile'=>'required|Array',



        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,
                                'msn'=>$value->msn,'indv_status'=>1,
                                'remarks'=>'Load Shedding Schedule will be updated'];
                     $d=     [
                        //   'wsim_datetime'=>$request->request_datetime,
                        //   'lsch_start_datetime'=>$request->start_datetime,
                        //   'lsch_end_datetime'=>$request->end_datetime,
                        'tiou_activation_datetime'=>$request->activation_datetime,
                        'tiou_day_profile'=>json_encode($request->day_profile),
                        'tiou_week_profile'=>json_encode($request->week_profile),
                        'tiou_season_profile'=>json_encode($request->season_profile),
                        'tiou_holiday_profile'=>json_encode($request->holiday_profile)
                        //   ''=>json_enocde($request->),

                     ];      

                     MeterVisual::where(['global_device_id'=> $value->global_device_id])
                                ->update($d);

                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_time_of_use','d'=>$d];                       
             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Load Shedding Schedule will be updated for meters having individual status as 1',$result);

    }
     // 3.3.6
    public function device_creation(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'device_identity' => 'required|Array',
            'request_datetime' => 'required|string',
            'initial_communication_time'=>'required|string',
            'communication_interval'=>'required|string',
            'device_type'=>'required|string',
            'mdi_reset_date'=>'required|string',
            'mdi_reset_time'=>'required|string',

            'sim_number'=>'required|string',
            'sim_id'=>'required|string',
            'phase'=>'required|string',
            'meter_type'=>'required|string',
            'communication_mode'=>'required|string',
            'communication_type'=>'required|string',
            'bidirectional_device'=>'required|string',
        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

        //  $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
        //  if($data)
        //  {
            // pr($request->device_identity);
             foreach ($request->device_identity as $key => $v) {
                $value=(object)($v);
                $exists = MeterVisual::where('global_device_id', $value->global_device_id)->exists();
                $exist2 = MeterVisual::where('msn', $value->dsn)->exists();

                if ($exists) {
                    $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->dsn,'indv_status'=>0,'remarks'=>'gobal Device Id Exits'];
                }
                if ($exist2) {
                    $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->dsn,'indv_status'=>0,'remarks'=>'MSN  Exits'];
                }
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->dsn,'indv_status'=>1,'remarks'=>'Meter Creation in Progress'];
                     MeterVisual::insert([
                                            'dmdt_datetime' => $request->request_datetime,
                                            'dmdt_initial_communication_time'=>$request->initial_communication_time,
                                            'dmdt_communication_interval'=>$request->communication_interval,
                                            'device_type'=>$request->device_type,
                                            'mdi_reset_date'=>$request->mdi_reset_date,
                                            'mdi_reset_time'=>$request->mdi_reset_time,
                                            'sim_number'=>$request->sim_number,
                                            'msim_id'=>$request->sim_id,
                                            'dmdt_phase'=>$request->phase,
                                            'dmdt_meter_type'=>$request->meter_type,
                                            'dmdt_communication_mode'=>$request->communication_mode,
                                            'dmdt_communication_type'=>$request->communication_type,
                                            'dmdt_bidirectional_device'=>$request->bidirectional_device,
                                            ]);
             }
        //  }
        //  else
        //  {
        //      return result(0,'Data Not Found',[]);
        //  }
         return result(1,'Meters with individual status 1 are created successfully',$result);

    }
    // 3.3.7
    public function update_ip_port(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'primary_ip_address'=>'required|string',
            'secondary_ip_address'=>'required|string',
            'primary_port'=>'required|string',
            'secondary_port'=>'required|string',
        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'IP Addresses will be updated'];
                    $d=[
                        'ippo_datetime'=>$request->request_datetime,
                        'ippo_primary_ip_address'=>$request->primary_ip_address,
                        'ippo_secondary_ip_address'=>$request->secondary_ip_address,
                        'ippo_primary_port'=>$request->primary_port,
                        'ippo_secondary_port'=>$request->secondary_port,

                    ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])
                     ->update($d);
                     $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_ip_port','d'=>$d];
             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Sanctioned Load will be updated for meters having individual status as 1',$result);



    }
     // 3.3.8
    public function meter_data_sampling(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'activation_datetime'=>'required|string',
            'data_type'=>'required|string',
            'sampling_interval'=>'required|string',
            'sampling_initial_time'=>'required|string',
        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Optical Port has been activated'];
                     $d=[
                         'mdsm_sampling_interval'=>$request->sampling_interval,
                         'mdsm_activation_datetime'=>$request->activation_datetime,
                        'mdsm_data_type'=>$request->data_type,
                        'mdsm_sampling_initial_time'=>$request->sampling_initial_time,
                     ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])->update($d);
                     $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'meter_data_sampling','d'=>$d];

             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Optical Port has been activated for meters having individual status as 1',$result);



        // $data=TransactonStatus::where('transactionid ',$request->transactionid)->get();
        // if($data)
        // return result('1', $data->type." response against requested meters",$data,$request->transactionid);
        // else
        //     return result('0',"Record not found aginst Transection Id : ".$request->transactionid,[],$request->transactionid);

    }

       // 3.3.8
       public function apms_tripping_events(Request $request)
       {
           $validator = Validator::make($request->all(), [
               'global_device_id' => 'required|Array',
               'request_datetime' => 'required|string',
               'type'=>'required|string',
               'critical_event_threshold_limit'=>'required|string',
               'critical_event_log_time'=>'required|string',
               "tripping_event_threshold_limit"=>'required|string',
               'tripping_event_log_time'=>'required|string',
               'enable_tripping'=>'required|string',
           ]);
           if ($validator->fails())
            return result(0, $validator->errors()->first(),[], 422);
   
            $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
            $result=[];
            $command=[];
            if($data)
            {
   
                foreach ($data as $key => $value) {
                         $setting=TrappingEventSetting::where(['global_device_id'=>$value->global_device_id,'type'=>$request->type])->first();   
                            if($setting)
                            {
                                $setting->critical_event_threshold_limit=$request->critical_event_threshold_limit;
                                $setting->critical_event_log_time=$request->critical_event_log_time;
                                $setting->critical_event_threshold_limit=$request->
                                $setting->tripping_event_threshold_limit=$request->tripping_event_threshold_limit;
                                $setting->tripping_event_log_time=$request->tripping_event_log_time;
                                $setting->enable_tripping=$request->enable_tripping;
                                $setting->save();
                                $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Setting Update'];
                            }
                            else
                            {
                                $setting= new TrappingEventSetting();
                                $setting->global_device_id=$request->global_device_id;
                                $setting->type=$request->type;
                                $setting->request_datetime=$request->request_datetime;
                                $setting->critical_event_threshold_limit=$request->critical_event_threshold_limit;
                                $setting->critical_event_log_time=$request->critical_event_log_time;
                                $setting->critical_event_threshold_limit=$request->
                                $setting->tripping_event_threshold_limit=$request->tripping_event_threshold_limit;
                                $setting->tripping_event_log_time=$request->tripping_event_log_time;
                                $setting->enable_tripping=$request->enable_tripping;
                                $setting->save();
                                $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Setting Update'];
                            }

                       
                        
                            $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'apms_tripping_events','d'=>'Trapping Setting Changed'];
   
                }
            }
            else
            {
                return result(0,'Data Not Found',[]);
            }
            if(!empty($command))
            SendCommandToDevice::dispatch($command);
            return result(1,'Trapping Event Save Successfully  having status as 1',$result);
       }

    // 3.3.9
    public function active_meter_optical_port(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'optical_port_on_datetime'=>'required|string',
            'optical_port_off_datetime'=>'required|string'

        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Optical Port has been activated'];
                     $d=[
                        'ippo_datetime'=>$request->request_datetime,
                        'oppo_optical_port_on_datetime'=>$request->optical_port_on_datetime,
                        'oppo_optical_port_off_datetime'=>$request->optical_port_off_datetime,
                     ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])->update($d);
                     $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'active_meter_optical_port','d'=>$d];

             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Optical Port has been activated for meters having individual status as 1',$result);



    }


    // 3.3.10
    public function update_wake_up_sim_number(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            'wakeup_number_1'=>'required|string',
            'wakeup_number_2'=>'required|string',
            'wakeup_number_3'=>'required|string'

        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Wakeup numbers have been updated'];
                     $d=[
                        'wsim_datetime'=>$request->request_datetime,
                        'wsim_wakeup_number_1'=>$request->wakeup_number_1,
                        'wsim_wakeup_number_2'=>$request->wakeup_number_2,
                        'wsim_wakeup_number_3'=>$request->wakeup_number_3,
                     ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])
                     ->update($d);
                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_wake_up_sim_number','d'=>$d];
             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Wakeup numbers have been updated for meters having individual status as 1',$result);



    }

     // 3.3.10
     public function update_meter_status(Request $request)
     {
         $validator = Validator::make($request->all(), [
             'global_device_id' => 'required|Array',
             'request_datetime' => 'required|string',
             'meter_activation_status'=>'required|string|in:0,1',

         ]);
         if ($validator->fails())
          return result(0, $validator->errors()->first(),[], 422);

          $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
          $result=[];
          if($data)
          {

              foreach ($data as $key => $value) {
                      $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Meter Status have been updated'];
                      MeterVisual::where(['global_device_id'=> $value->global_device_id])
                      ->update([
                               'mtst_datetime'=>$request->request_datetime,
                               'mtst_meter_activation_status'=>$request->meter_activation_status,
                              ]);
                              $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_meter_status','d'=>['mtst_meter_activation_status'=>$request->meter_activation_status]];
              }
          }
          else
          {
              return result(0,'Data Not Found',[]);
          }
          if(!empty($command))
          SendCommandToDevice::dispatch($command);
          return result(1,'Meter Status have been updated for meters having individual status as 1',$result);



     }

       // 3.3.12
    public function update_device_metadata(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|Array',
            'request_datetime' => 'required|string',
            // 'privatekey' => 'required|string',

            'communication_mode'=>'required|string',

            'bidirectional_device'=>'required|string',
            'communication_type'=>'required|string',
            'initial_communication_time'=>'required|string',

            'communication_interval'=>'required|string',
            'phase'=>'required|string',
            'meter_type'=>'required|string',





        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);


         $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
         $result=[];
         $command=[];
         if($data)
         {

             foreach ($data as $key => $value) {
                     $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'Meta Data have been updated '];
                     $d=[
                            'dmdt_datetime'=>$request->request_datetime,
                            'dmdt_communication_mode'=>$request->communication_mode,
                            'dmdt_bidirectional_device'=>$request->bidirectional_device,
                            'dmdt_communication_type'=>$request->communication_type,
                            'dmdt_initial_communication_time'=>$request->initial_communication_time,
                            'dmdt_communication_interval'=>$request->communication_interval,
                            'dmdt_phase'=>$request->phase,
                            'dmdt_meter_type'=>$request->meter_type,
                            ];
                     MeterVisual::where(['global_device_id'=> $value->global_device_id])
                     ->update($d);

                     $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_device_metadata','d'=>$d];
             }
         }
         else
         {
             return result(0,'Data Not Found',[]);
         }
         if(!empty($command))
         SendCommandToDevice::dispatch($command);
         return result(1,'Meta Data have been updated for meters having individual status as 1',$result);



    }

     // 3.3.12
     public function update_mdi_reset_date(Request $request)
     {
         $validator = Validator::make($request->all(), [
             'global_device_id' => 'required|Array',
             'request_datetime' => 'required|string',

             'mdi_reset_date'=>'required|integer',

             'mdi_reset_time'=>'required|string',

         ]);
         if ($validator->fails())
          return result(0, $validator->errors()->first(),[], 422);

         
          $data=MeterVisual::whereIn('global_device_id',$request->global_device_id)->get();
          $result=[];
          $command=[];
          if($data)
          {

              foreach ($data as $key => $value) {
                      $result[]=['global_device_id'=> $value->global_device_id,'msn'=>$value->msn,'indv_status'=>1,'remarks'=>'MDI Reset parameter have been updated '];
                       $d= [
                           'mdi_reset_date'=>$request->mdi_reset_date,
                           'mdi_reset_time'=>$request->mdi_reset_time,
                       ];
                      MeterVisual::where(['global_device_id'=> $value->global_device_id])
                      ->update($d);
                    $command[]=['gid'=>$value->global_device_id,'at'=>'order','a'=>'update_mdi_reset_date','d'=>$d];        
              }
          }
          else
          {
              return result(0,'Data Not Found',[]);
          }
          if(!empty($command))
          SendCommandToDevice::dispatch($command);
          return result(1,'MDI Reset parameter have been updated for meters having individual status as 1',$result);



     }



    // 3.4.1
    public function on_demand_data_read(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required',
            'transactionid' => 'required',
            'privatekey' => 'required',
            'start_datetime' => 'required',
            'end_datetime' => 'required',
            'type' => 'required|string|in:INST,BILL,MBIL,LPRO,EVNT',
        ]);

        if ($validator->fails())
        return result(0, $validator->errors()->first(),[], 422);

        if($request->type=='INST')
        {
            $data=instantData::where('global_device_id',$request->global_devic_id)->orderBy('id','desc')->first();
            return result(1,'',$data);
        }
        else if($request->type=='BILL')
        {
            $data=BillingData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            return result(1,'',$data);
        }
        else if($request->type=='MBIL')
        {
            $data=MonthlyBillingData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            return result(1,'',$data);
        }
        else if($request->type=='LPRO')
        {

            $data=LoadProfileData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            return result(1,'',$data);

        }
        else
        {
            $data=EventM::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            return result(1,'',$data);
        }

        // $data=AuxOperation::where('global_device_id',$request->global_devic_id)->get();

        // return result(1,'',$data);
    }

    // 3.4.2
    public function on_demand_parameter_read(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required',
            'transactionid' => 'required',
            'privatekey' => 'required',
            'type' => 'required',

        ]);

        if ($validator->fails())
        return result(0, $validator->errors()->first(),[], 422);


        if($request->type=='AUXR')
        {
            $data=MeterVisual::select('is_aux_relay')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='DVTM')
        {
            // $data=BillingData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            // return result(1,'',$data);
        }
        else if($request->type=='SANC')
        {
            // $data=MonthlyBillingData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            // return result(1,'',$data);
        }
        else if($request->type=='LSCH')
        {

            // $data=LoadProfileData::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
            // return result(1,'',$data);

        }
        else if($request->type=='TIOU')
        {

        }
        else if($request->type=='IPPO')
        {
            $data=MeterVisual::select('ippo_primary_ip_address','ippo_secondary_ip_address','ippo_primary_port','ippo_secondary_port')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='MDSM')
        {

        }
        else if($request->type=='OPPO')
        {

        }
        else if($request->type=='WSIM')
        {
            $data=MeterVisual::select('wsim_wakeup_number_1','wsim_wakeup_number_2','wsim_wakeup_number_3')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='MSIM')
        {
            $data=MeterVisual::select('msim_id','sim_number')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='MTST')
        {
            $data=MeterVisual::select('mtst_meter_activation_status')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='DMDT')
        {

        }
        else if($request->type=='MDI')
        {
            $data=MeterVisual::select('mdi_reset_date','mdi_reset_time')->where('global_device_id',$request->global_devic_id)->first();
            return result(1,'',$data);
        }
        else if($request->type=='OVFC')
        {

        }
        else if($request->type=='UVFC')
        {

        }
        else if($request->type=='OCFC')
        {

        }
        else if($request->type=='OLFC')
        {

        }
        else if($request->type=='VUFC')
        {

        }
        else if($request->type=='PFFC')
        {

        }
        else if($request->type=='CUFC')
        {

        }
        else if($request->type=='HAPF')
        {

        }


        // else
        // {
        //     $data=EventM::where('global_device_id',$request->global_devic_id)->where('db_datetime','<=',$request->end_datetime)->where('db_datetime','>=',$request->start_datetime)->orderBy('id','desc')->get();
        //     return result(1,'',$data);
        // }
    }
    // 3.4.3
    public function transaction_status(Request $request)
    {
        $validator = Validator::make($request->all(), [
            // 'global_device_id' => 'required|Array',
            'transactionid' => 'required|string',


        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

        $data=TransactonStatus::where('transactionid ',$request->transactionid)->first();
        if($data)
        return result(1, $data->type." response against requested meters",$data,$request->transactionid);
        else
            return result(0,"Record not found aginst Transection Id : ".$request->transactionid,[],$request->transactionid);

    }

    // 3.4.4
    public function transaction_cancel(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'global_device_id' => 'required|string ',
            'transactionid' => 'required|string',


        ]);
        if ($validator->fails())
         return result(0, $validator->errors()->first(),[], 422);

        $data=TransactonStatus::where('transactionid ',$request->transactionid)->where('global_device_id ',$request->global_device_id)->first();
        if($data && (!empty($data)))
        {
            if($data->status_level>=1 && $data->status_level<=3)
            {
                $result[]=['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>1,'remarks'=>'Transection cancelled'];

                $data->request_cancelled=1;
                $data->response_data='Transection Cancelled by MDM';
                $data->request_cancel_datetime=date('Y-m-d H:i:s');
                $data->request_cancel_reason='MDM Request for Cancellation';
                $data->save();
                return result(1, "Transection Cancelled having indv_status 1",$data,$request->transactionid);
            }
            else
            {
                $result[]=['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>0,'remarks'=>'Transection Cant not be cancell'];
                return result(1,'Transection Cant not be cancell',$result);
            }

        }
        else
            // return result(0,"Record not found aginst Transection Id : ".$request->transactionid,[],$request->transactionid);
            return result(1,'Transection Cancelled having indv_status 1',['global_device_id'=> $request->global_device_id,'msn'=>$request->msn,'indv_status'=>0,'remarks'=>'Record not Found Against TransectionId']);

    }


}
